/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.ocsp.extensions.AcceptableResponses;
import iaik.x509.ocsp.extensions.ArchiveCutoff;
import iaik.x509.ocsp.extensions.CrlID;
import iaik.x509.ocsp.extensions.ExtendedRevoked;
import iaik.x509.ocsp.extensions.Nonce;
import iaik.x509.ocsp.extensions.PreferredSignatureAlgorithms;
import iaik.x509.ocsp.extensions.ServiceLocator;
import iaik.x509.ocsp.extensions.commonpki.CertHash;

public class OCSPExtensions
extends X509Extensions {
    static Class Q;
    static Class R;
    static Class S;
    static Class T;
    static Class U;
    static Class V;
    static Class W;
    static Class X;

    public OCSPExtensions() {
        super(2, 4);
    }

    public OCSPExtensions(int n2, int n3) {
        super(n2, n3);
    }

    public OCSPExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        this();
        this.decode(aSN1Object);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        byte[] byArray = null;
        boolean bl = true;
        if (this.critical_extensions != null) {
            byArray = (byte[])this.critical_extensions.get(objectID);
        }
        if (byArray == null) {
            if (this.noncritical_extensions != null) {
                byArray = (byte[])this.noncritical_extensions.get(objectID);
            }
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        try {
            ASN1Object aSN1Object = null;
            if (objectID.equals(Nonce.oid)) {
                if (byArray[0] == 4) {
                    try {
                        aSN1Object = DerCoder.decode(byArray);
                    }
                    catch (CodingException codingException) {
                        // empty catch block
                    }
                }
                if (aSN1Object == null) {
                    aSN1Object = new OCTET_STRING(byArray);
                }
            } else {
                aSN1Object = DerCoder.decode(byArray);
            }
            v3Extension.init(aSN1Object);
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new X509ExtensionInitException(objectID, bl, codingException.toString());
        }
        return v3Extension;
    }

    public boolean addExtension(V3Extension v3Extension) throws X509ExtensionException {
        ASN1Object aSN1Object = v3Extension.toASN1Object();
        byte[] byArray = aSN1Object == null ? new byte[]{} : (v3Extension.getObjectID().equals(Nonce.oid) && !Nonce.getWrapNonceValue() ? ((Nonce)v3Extension).getValue() : DerCoder.encode(v3Extension.toASN1Object()));
        if (v3Extension.isCritical()) {
            this.createExtensionsTable(true);
            return this.critical_extensions.put(v3Extension.getObjectID(), byArray) != null;
        }
        this.createExtensionsTable(false);
        return this.noncritical_extensions.put(v3Extension.getObjectID(), byArray) != null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        OCSPExtensions.register(AcceptableResponses.oid, Q == null ? (Q = OCSPExtensions.class$("iaik.x509.ocsp.extensions.AcceptableResponses")) : Q);
        OCSPExtensions.register(ArchiveCutoff.oid, R == null ? (R = OCSPExtensions.class$("iaik.x509.ocsp.extensions.ArchiveCutoff")) : R);
        OCSPExtensions.register(CrlID.oid, S == null ? (S = OCSPExtensions.class$("iaik.x509.ocsp.extensions.CrlID")) : S);
        OCSPExtensions.register(Nonce.oid, T == null ? (T = OCSPExtensions.class$("iaik.x509.ocsp.extensions.Nonce")) : T);
        OCSPExtensions.register(ServiceLocator.oid, U == null ? (U = OCSPExtensions.class$("iaik.x509.ocsp.extensions.ServiceLocator")) : U);
        OCSPExtensions.register(CertHash.oid, V == null ? (V = OCSPExtensions.class$("iaik.x509.ocsp.extensions.commonpki.CertHash")) : V);
        OCSPExtensions.register(ExtendedRevoked.oid, W == null ? (W = OCSPExtensions.class$("iaik.x509.ocsp.extensions.ExtendedRevoked")) : W);
        OCSPExtensions.register(PreferredSignatureAlgorithms.oid, X == null ? (X = OCSPExtensions.class$("iaik.x509.ocsp.extensions.PreferredSignatureAlgorithms")) : X);
    }
}

