/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.CertificateResponse;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.ResponderID;
import iaik.x509.ocsp.Response;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.extensions.Nonce;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Enumeration;

public class BasicOCSPResponse
extends Response {
    public static final ObjectID responseType = ObjectID.basicOcspResponse;
    private ASN1 c;
    private int d;
    private ResponderID e;
    private ChoiceOfTime f;
    private SingleResponse[] g;
    private OCSPExtensions h;
    private AlgorithmID i;
    private X509Certificate[] j;
    private byte[] k;
    private boolean l;
    static Class a;
    static Class b;

    public BasicOCSPResponse() {
        this.d = 1;
        this.a();
        this.c = new ASN1();
    }

    public BasicOCSPResponse(InputStream inputStream) throws IOException, CodingException {
        this.decode(inputStream);
    }

    public BasicOCSPResponse(byte[] byArray) throws CodingException {
        this.decode(byArray);
    }

    private void a() {
        this.l = true;
        this.c = null;
    }

    private void b() {
        if (this.l) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    private void c() {
        this.l = false;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.c = new ASN1(aSN1Object);
        try {
            this.d();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public void decode(byte[] byArray) throws CodingException {
        try {
            this.c = new ASN1(byArray);
            this.d();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.toString());
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            this.c = new ASN1(inputStream);
            this.d();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new IOException(x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    private void d() throws CodingException, X509ExtensionException {
        ASN1Object aSN1Object;
        int n2 = 0;
        ASN1Object aSN1Object2 = this.c.getComponentAt(0);
        this.i = new AlgorithmID(this.c.getComponentAt(1));
        ASN1Object aSN1Object3 = this.c.getComponentAt(2);
        this.k = (byte[])((BIT_STRING)aSN1Object3).getValue();
        if (this.c.countComponents() == 4) {
            this.j = (X509Certificate[])ASN.parseSequenceOf((ASN1Object)this.c.getComponentAt(3).getValue(), a == null ? (a = BasicOCSPResponse.class$("iaik.x509.X509Certificate")) : a);
        }
        if ((aSN1Object = aSN1Object2.getComponentAt(0)).isA(ASN.CON_SPEC) && aSN1Object.getAsnType().getTag() == 0) {
            BigInteger bigInteger = (BigInteger)((ASN1Object)aSN1Object.getValue()).getValue();
            this.d = bigInteger.intValue() + 1;
            ++n2;
        }
        this.e = new ResponderID(aSN1Object2.getComponentAt(0 + n2));
        this.f = new ChoiceOfTime(aSN1Object2.getComponentAt(1 + n2));
        aSN1Object = aSN1Object2.getComponentAt(2 + n2);
        this.g = (SingleResponse[])ASN.parseSequenceOf(aSN1Object, b == null ? (b = BasicOCSPResponse.class$("iaik.x509.ocsp.SingleResponse")) : b);
        int n3 = 3 + n2;
        if (n3 < aSN1Object2.countComponents()) {
            aSN1Object = aSN1Object2.getComponentAt(n3);
            this.h = new OCSPExtensions((ASN1Object)aSN1Object.getValue());
        }
        this.c.clearASN1Object();
        this.c();
    }

    private ASN1Object e() throws OCSPException {
        if (this.e == null) {
            throw new OCSPException("Responder ID not set!");
        }
        if (this.f == null) {
            throw new OCSPException("ProducedAt date not set!");
        }
        if (this.g == null || this.g.length == 0) {
            throw new OCSPException("No single responses set!");
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.d > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.d - 1)));
            }
            sEQUENCE.addComponent(this.e.toASN1Object());
            sEQUENCE.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(ASN.createSequenceOf(this.g));
            if (this.h != null && this.h.countExtensions() > 0) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.h.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new OCSPException(exception.toString());
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, string, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, provider);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, null, provider);
    }

    private void a(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        Signature signature;
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign response! No signature algorithm specified!");
        }
        this.i = algorithmID;
        Signature signature2 = signature = provider != null ? this.i.getSignatureInstance(provider) : this.i.getSignatureInstance(string);
        if (algorithmParameterSpec != null) {
            signature.setParameter(algorithmParameterSpec);
        }
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.i) && !this.i.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.i.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.e();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.k = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.k);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.i.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            if (this.j != null && this.j.length > 0) {
                sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.j)));
            }
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new OCSPException(signatureException.toString());
        }
        this.c();
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot set signature! No signature algorithm specified!");
        }
        if (byArray == null || byArray.length == 0) {
            throw new OCSPException("Cannot set empty signature value!");
        }
        this.i = algorithmID;
        this.k = byArray;
        ASN1Object aSN1Object = this.e();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.k);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.i.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            if (this.j != null && this.j.length > 0) {
                sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.j)));
            }
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.toString());
        }
        this.c();
    }

    public byte[] getEncoded() {
        this.b();
        return this.c.toByteArray();
    }

    public int getVersion() {
        return this.d;
    }

    public ObjectID getResponseType() {
        return responseType;
    }

    public ResponderID getResponderID() {
        return this.e;
    }

    public SingleResponse[] getSingleResponses() {
        return this.g;
    }

    public int countSingleResponses() {
        return this.g.length;
    }

    public SingleResponse getSingleResponse(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        return (SingleResponse)this.getCertificateResponse(x509Certificate, x509Certificate2, generalName);
    }

    public SingleResponse getSingleResponse(ReqCert reqCert) throws OCSPException {
        return (SingleResponse)this.getCertificateResponse(reqCert);
    }

    public CertificateResponse getCertificateResponse(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        if (this.g != null) {
            Throwable throwable = null;
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                SingleResponse singleResponse = this.g[i2];
                try {
                    if (!singleResponse.isResponseFor(x509Certificate, x509Certificate2, generalName)) continue;
                    return singleResponse;
                }
                catch (OCSPException oCSPException) {
                    if (throwable != null) continue;
                    throwable = oCSPException;
                }
            }
            if (throwable != null) {
                throw new OCSPException("Cannot check single responses. " + throwable.getMessage());
            }
        }
        return null;
    }

    public CertificateResponse getCertificateResponse(ReqCert reqCert) throws OCSPException {
        if (this.g != null) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                object = this.g[i2];
                if (((SingleResponse)object).isResponseFor(reqCert)) {
                    return object;
                }
                if (reqCert.getType() != ((SingleResponse)object).getReqCert().getType()) {
                    bl = true;
                    continue;
                }
                if (bl2 || reqCert.getType() != 0) continue;
                CertID certID = (CertID)reqCert.getReqCert();
                CertID certID2 = (CertID)((SingleResponse)object).getReqCert().getReqCert();
                if (certID.getHashAlgorithm().equals(certID2.getHashAlgorithm())) continue;
                bl2 = true;
            }
            if (bl || bl2) {
                String string = "No response found, but some responses have ";
                object = bl2 ? "certIDs with different hash algorithms" : "";
                string = string + (String)(bl ? "different ReqCert types " + (bl2 ? "or " + (String)object : "") : (bl2 ? object : ""));
                throw new OCSPException(string);
            }
        }
        return null;
    }

    public Date getProducedAt() {
        return this.f == null ? null : this.f.getDate();
    }

    public byte[] getTBSResponseData() throws CodingException {
        try {
            if (this.c != null && this.c.toByteArray() != null) {
                return this.c.getFirstObject();
            }
            return DerCoder.encode(this.e());
        }
        catch (OCSPException oCSPException) {
            throw new CodingException(oCSPException.toString());
        }
    }

    public byte[] getSignature() {
        return this.k;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.i;
    }

    public void verify(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, null, null);
    }

    public void verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, string, null);
    }

    public void verify(PublicKey publicKey, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, null, provider);
    }

    private void a(PublicKey publicKey, String string, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.b();
        Signature signature = provider != null ? this.i.getSignatureInstance(provider) : this.i.getSignatureInstance(string);
        try {
            byte[] byArray = this.c.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.k)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public X509Certificate verify() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, OCSPException {
        X509Certificate x509Certificate = null;
        if (this.j == null || this.j.length == 0) {
            throw new OCSPException("Cannot verify request. No certificates included.");
        }
        x509Certificate = this.getSignerCertificate();
        if (x509Certificate == null) {
            X509Certificate[] x509CertificateArray = Util.arrangeCertificateChain(this.j, false);
            x509Certificate = x509CertificateArray != null && x509CertificateArray.length > 0 ? x509CertificateArray[0] : this.j[0];
        }
        this.verify(x509Certificate.getPublicKey());
        return x509Certificate;
    }

    public boolean containsCertificates() {
        return this.j != null && this.j.length > 0;
    }

    public ASN1Object toASN1Object() {
        this.b();
        return this.c.toASN1Object();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.c.writeTo(outputStream);
    }

    public void setResponderID(ResponderID responderID) {
        this.e = responderID;
        this.a();
    }

    public void setProducedAt(Date date) {
        this.f = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
        this.a();
    }

    public void setSingleResponses(SingleResponse[] singleResponseArray) {
        this.g = singleResponseArray;
        this.a();
        if (this.g != null) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                if (this.g[i2].getReqCert().getType() == 0) continue;
                this.d = 2;
                break;
            }
        }
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.j = x509CertificateArray;
        this.a();
    }

    public X509Certificate[] getCertificates() {
        return this.j;
    }

    public X509Certificate getSignerCertificate() {
        X509Certificate x509Certificate = null;
        if (this.j != null && this.e != null) {
            for (int i2 = 0; i2 < this.j.length; ++i2) {
                try {
                    if (!this.e.isResponderIdFor(this.j[i2])) continue;
                    x509Certificate = this.j[i2];
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return x509Certificate;
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.h == null) {
            this.h = new OCSPExtensions();
        }
        this.h.addExtension(v3Extension);
        this.a();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.h == null ? false : this.h.removeExtension(objectID);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.h != null) {
            this.h.removeAllExtensions();
            this.a();
        }
        this.h = null;
    }

    public Enumeration listExtensions() {
        return this.h == null ? null : this.h.listExtensions();
    }

    public boolean hasExtensions() {
        return this.h == null ? false : this.h.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.h == null ? false : this.h.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.h == null ? 0 : this.h.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.h == null ? null : this.h.getExtension(objectID);
    }

    public void setNonce(byte[] byArray) throws X509ExtensionException {
        this.addExtension(new Nonce(byArray));
    }

    public byte[] getNonce() throws X509ExtensionInitException {
        Nonce nonce = (Nonce)this.getExtension(Nonce.oid);
        return nonce == null ? null : nonce.getValue();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.d + "\n");
        stringBuffer.append("ResponderID: " + this.e + "\n");
        stringBuffer.append("ProducedAt: " + this.f + "\n");
        if (bl) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                stringBuffer.append("singleResponse " + i2 + ": {\n");
                Util.printIndented(this.g[i2].toString(true), true, "  ", stringBuffer);
                stringBuffer.append("\n}");
            }
        } else {
            stringBuffer.append("singleResponses: " + this.g.length);
        }
        stringBuffer.append("\n");
        if (this.h != null) {
            if (bl) {
                stringBuffer.append(this.h);
            } else {
                stringBuffer.append("Extensions: " + this.h.countExtensions());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("Signature algorithm: " + this.i + "\n");
        if (this.j != null) {
            stringBuffer.append("certificates: " + this.j.length + "\n");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

