/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.net.ldap;

import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.net.ldap.a;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapURLConnection
extends URLConnection {
    public static final String SEARCH_SCOPE_BASE = "base";
    public static final String SEARCH_SCOPE_ONELEVEL = "one";
    public static final String SEARCH_SCOPE_SUBTREE = "sub";
    public static final String AD_CA_CERTIFICATE = "caCertificate;binary";
    public static final String AD_USER_CERTIFICATE = "userCertificate;binary";
    public static final String AD_CERTIFICATE = "caCertificate;binary,userCertificate;binary";
    public static final String AD_ATTRIBUTE_CERTIFICATE = "attributeCertificate;binary";
    public static final String AD_CERTIFICATE_REVOCATION_LIST = "certificateRevocationList;binary";
    public static final String AD_AUTHORITY_REVOCATION_LIST = "authorityRevocationList;binary";
    public static final String AD_REVOCATION_LIST = "authorityRevocationList;binary,certificateRevocationList;binary";
    public static final String AD_DELTA_REVOCATION_LIST = "deltaRevocationList;binary";
    public static final String RP_BASE_DN = "dn";
    public static final String RP_SEARCH_SCOPE = "scope";
    public static final String RP_SIZE_LIMIT = "sizeLimit";
    public static final String RP_FILTER = "filter";
    public static final String RP_ATTRIBUTE_DESCRIPTION = "attributeDescription";
    public static final String RP_EXTENSIONS = "extensions";
    public static final String RP_SECURITY_AUTHENTICATION = "securityAuthentication";
    public static final String RP_SECURITY_PRINCIPAL = "securityPrincipal";
    public static final String RP_SECURITY_CREDENTIALS = "securityCredentials";
    private static Vector c = new Vector();
    private static int d;
    private static int e;
    private String f;
    private String[] g;
    private int h = -1;
    private int i = 0;
    private String j;
    private String k;
    private int l = 0;
    private int m = d;
    private int n = e;
    private String o;
    private String p;
    private String q;
    DirContext a;
    DirContext b;
    private InputStream r;

    public static void setDefaultConnectTimeout(int n2) {
        d = n2 < 0 ? -1 : n2;
    }

    public static int getDefaultConnectTimeout() {
        return d;
    }

    public static void addConnectTimeoutEnvPropKey(String string) {
        if (string == null) {
            throw new NullPointerException("Property key must not be null!");
        }
        c.addElement(string);
    }

    public static void setDefaultReadTimeOut(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout (" + n2 + ") cannot be negative");
        }
        e = n2;
    }

    public static int getDefaultReadTimeOut() {
        return e;
    }

    public LdapURLConnection(URL uRL) throws IOException {
        super(uRL);
        this.doInput = true;
        this.doOutput = false;
        this.allowUserInteraction = false;
        this.useCaches = false;
        this.ifModifiedSince = 0L;
        this.a();
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.g == null || this.g.length == 0) {
            throw new IOException("No attributes specified!");
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.url.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(this.url.getHost());
        int n2 = this.url.getPort();
        if (n2 > 0) {
            stringBuffer.append(':');
            stringBuffer.append(n2);
        }
        try {
            String string;
            Object object;
            Hashtable<String, String> hashtable = null;
            int n3 = c.size();
            if (this.o != null) {
                hashtable = new Hashtable<String, String>(3 + n3, 1.0f);
                hashtable.put("java.naming.security.authentication", this.o);
                if (!this.o.toLowerCase(Locale.US).equals("none")) {
                    if (this.p != null) {
                        hashtable.put("java.naming.security.principal", this.p);
                    }
                    if (this.q != null) {
                        hashtable.put("java.naming.security.credentials", this.q);
                    }
                }
            }
            if (this.m > -1) {
                if (hashtable == null) {
                    hashtable = new Hashtable(n3, 1.0f);
                }
                object = c.elements();
                while (object.hasMoreElements()) {
                    hashtable.put((String)object.nextElement(), String.valueOf(this.m));
                }
            }
            if (this.n > -1) {
                if (hashtable == null) {
                    hashtable = new Hashtable(n3, 1.0f);
                }
                hashtable.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.n));
            }
            this.a = hashtable != null ? new InitialDirContext(hashtable) : new InitialDirContext();
            this.b = (DirContext)this.a.lookup(stringBuffer.toString());
            object = new SearchControls();
            ((SearchControls)object).setSearchScope(this.i);
            ((SearchControls)object).setTimeLimit(this.n);
            ((SearchControls)object).setCountLimit(this.l);
            ((SearchControls)object).setReturningAttributes(this.g);
            String string2 = this.f;
            if (string2 == null || string2.length() == 0) {
                string2 = "";
            }
            if ((string = this.j) == null) {
                string = this.b(this.g);
            }
            NamingEnumeration<SearchResult> namingEnumeration = this.b.search(string2, string, (SearchControls)object);
            this.r = new a(this, namingEnumeration);
            this.connected = true;
        }
        catch (NamingException namingException) {
            if (this.b != null) {
                try {
                    this.b.close();
                }
                catch (NamingException namingException2) {
                    // empty catch block
                }
            }
            if (this.a != null) {
                try {
                    this.a.close();
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
            }
            this.b = null;
            this.a = null;
            throw new IOException(this, namingException.toString(), namingException){
                private static final long serialVersionUID = 5607903656478303144L;
                private final NamingException a;
                private final LdapURLConnection b;
                {
                    this.b = ldapURLConnection;
                    this.a = namingException;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public void disconnect() {
        if (this.b != null) {
            try {
                this.b.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        this.b = null;
        this.a = null;
        this.connected = false;
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.r;
    }

    public Object getContent() throws IOException {
        this.connect();
        Vector<X509Extension> vector = new Vector<X509Extension>();
        X509Extension[] x509ExtensionArray = null;
        if (this.r != null) {
            InputStream inputStream = this.r;
            if (this.h != -1) {
                switch (this.h) {
                    case 0: {
                        try {
                            while (true) {
                                X509Certificate x509Certificate = new X509Certificate(inputStream);
                                vector.addElement(x509Certificate);
                            }
                        }
                        catch (EOFException eOFException) {
                            try {
                                this.r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Exception exception) {
                            try {
                                throw new IOException("Error parsing certificate: " + exception.toString());
                            }
                            catch (Throwable throwable) {
                                try {
                                    this.r.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        x509ExtensionArray = new X509Certificate[vector.size()];
                        vector.copyInto(x509ExtensionArray);
                        break;
                    }
                    case 2: {
                        try {
                            while (true) {
                                X509CRL x509CRL = new X509CRL(inputStream);
                                vector.addElement(x509CRL);
                            }
                        }
                        catch (EOFException eOFException) {
                            try {
                                this.r.close();
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {
                            try {
                                throw new IOException("Error parsing crl: " + exception.toString());
                            }
                            catch (Throwable throwable) {
                                try {
                                    this.r.close();
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        x509ExtensionArray = new X509CRL[vector.size()];
                        vector.copyInto(x509ExtensionArray);
                        break;
                    }
                    case 1: {
                        try {
                            while (true) {
                                AttributeCertificate attributeCertificate = new AttributeCertificate(inputStream);
                                vector.addElement(attributeCertificate);
                            }
                        }
                        catch (EOFException eOFException) {
                            try {
                                this.r.close();
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {
                            try {
                                throw new IOException("Error parsing certificate: " + exception.toString());
                            }
                            catch (Throwable throwable) {
                                try {
                                    this.r.close();
                                }
                                catch (Exception exception3) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        x509ExtensionArray = new AttributeCertificate[vector.size()];
                        vector.copyInto(x509ExtensionArray);
                        break;
                    }
                }
            }
        }
        return x509ExtensionArray;
    }

    private void a() throws IOException {
        StringTokenizer stringTokenizer;
        if (this.url == null) {
            throw new NullPointerException("URL must not be null!");
        }
        String string = this.unescape(this.url.getFile());
        int n2 = string.indexOf(63);
        int n3 = n2;
        if (n3 == -1) {
            n3 = string.length();
        }
        if (n3 > 1) {
            this.f = string.substring(1, n3);
        }
        String string2 = null;
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
        }
        if (string2 != null && (stringTokenizer = new StringTokenizer(string2, "?", true)).hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.compareTo("?") != 0) {
                try {
                    this.g = this.a(string3, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new MalformedURLException(illegalArgumentException.getMessage());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.compareTo("?") != 0) {
                    try {
                        this.i = LdapURLConnection.a(string4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MalformedURLException(illegalArgumentException.getMessage());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.compareTo("?") != 0) {
                        this.j = string5;
                        if (stringTokenizer.hasMoreTokens()) {
                            stringTokenizer.nextToken();
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        this.k = stringTokenizer.nextToken();
                        if (this.k.length() > 0) {
                            StringTokenizer stringTokenizer2 = new StringTokenizer(this.k, ",");
                            while (stringTokenizer2.hasMoreTokens()) {
                                String string6 = stringTokenizer2.nextToken();
                                if (!string6.startsWith("!")) continue;
                                throw new MalformedURLException("LDAP url contains unsupported critical extension: " + string6);
                            }
                        }
                    }
                }
            }
        }
    }

    private static int a(String string) throws IllegalArgumentException {
        int n2 = 0;
        String string2 = string.toLowerCase(Locale.US).trim();
        if (string2.length() > 0) {
            if (string2.equals(SEARCH_SCOPE_ONELEVEL)) {
                n2 = 1;
            } else if (string2.equals(SEARCH_SCOPE_SUBTREE)) {
                n2 = 2;
            } else if (!string2.equals(SEARCH_SCOPE_BASE)) {
                throw new IllegalArgumentException("Invalid search scope \"" + string + "\"! " + "Must be \"base\", \"one\" or \"sub\".");
            }
        }
        return n2;
    }

    private static String a(int n2) {
        String string = SEARCH_SCOPE_BASE;
        if (n2 == 1) {
            string = SEARCH_SCOPE_ONELEVEL;
        } else if (n2 == 2) {
            string = SEARCH_SCOPE_SUBTREE;
        }
        return string;
    }

    private String[] a(String string, boolean bl) throws IllegalArgumentException {
        Object object;
        int n2 = this.h;
        if (bl) {
            this.h = -1;
        }
        Vector<String> vector = new Vector<String>();
        try {
            if (string.length() > 0) {
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    this.b(string2);
                    vector.addElement(string2);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.h = n2;
            throw illegalArgumentException;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private String a(String[] stringArray) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[i2]);
            }
        }
        return (string = stringBuffer.toString()).length() == 0 ? null : string;
    }

    private String b(String[] stringArray) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            if (stringArray.length > 1) {
                stringBuffer.append("(|");
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2.length() <= 0) continue;
                stringBuffer.append("(");
                stringBuffer.append(string2);
                stringBuffer.append("=*)");
            }
            if (stringArray.length > 1) {
                stringBuffer.append(")");
            }
        }
        return (string = stringBuffer.toString()).length() <= 3 ? "(objectClass=*)" : string;
    }

    private void b(String string) throws IllegalArgumentException {
        int n2 = -1;
        String string2 = string.toLowerCase(Locale.US);
        if (string2.indexOf("revocation") != -1) {
            n2 = 2;
        } else if (string2.indexOf("certificate") != -1) {
            n2 = string2.indexOf("attributecertificate") != -1 ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Invalid attribute description: \"" + string + "\". " + "Only certificate and revocation list attributes allowed!");
        }
        if (this.h == -1) {
            this.h = n2;
        } else if (this.h != n2) {
            throw new IllegalArgumentException("Invalid attribute description: \"" + string + "\". " + "All attributes must have same type!");
        }
    }

    protected String unescape(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("Cannot unescape null String!");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            char c2 = string.charAt(i2);
            if (c2 != '%') {
                stringBuffer.append(c2);
                continue;
            }
            int[] nArray = new int[3];
            nArray[0] = Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
            if ((nArray[0] & 0xE0) == 224) {
                nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                nArray[2] = Integer.parseInt(string.substring(i2 + 7, i2 + 9), 16);
                n2 = ((nArray[0] & 0xF) << 12) + ((nArray[1] & 0x3F) << 6) + (nArray[2] & 0x3F);
                stringBuffer.append((char)n2);
                i2 += 8;
                continue;
            }
            if ((nArray[0] & 0xC0) == 192) {
                nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                n2 = ((nArray[0] & 0x1F) << 6) + (nArray[1] & 0x3F);
                stringBuffer.append((char)n2);
                i2 += 5;
                continue;
            }
            if ((nArray[0] & 0x80) == 0) {
                stringBuffer.append((char)nArray[0]);
                i2 += 2;
                continue;
            }
            throw new IOException("invlaid encoding");
        }
        return stringBuffer.toString();
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key must not be null");
        }
        if (string.equalsIgnoreCase(RP_BASE_DN)) {
            if (string2 == null) {
                this.f = null;
            } else {
                try {
                    this.f = string2.length() == 0 ? string2 : this.unescape(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Invalid dn encoding: " + exception.getMessage());
                }
            }
        } else if (string.equalsIgnoreCase(RP_SEARCH_SCOPE)) {
            this.i = string2 == null ? 0 : LdapURLConnection.a(string2);
        } else if (string.equalsIgnoreCase(RP_SIZE_LIMIT)) {
            try {
                if (string2 == null) {
                    this.l = 0;
                }
                int n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    throw new IllegalArgumentException("sizeLimit value (" + string2 + ") " + "must not be negative!");
                }
                this.l = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid sizeLimit value (" + string2 + "). " + "Must be numeric value!");
            }
        } else if (string.equalsIgnoreCase(RP_FILTER)) {
            if (string2 == null) {
                this.j = null;
            } else {
                try {
                    this.j = string2.length() == 0 ? string2 : this.unescape(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Invalid filter encoding: " + exception.getMessage());
                }
            }
        } else if (string.equalsIgnoreCase(RP_ATTRIBUTE_DESCRIPTION)) {
            if (string2 == null) {
                this.g = null;
                this.h = -1;
            } else {
                this.g = this.a(string2, true);
            }
        } else if (string.equalsIgnoreCase(RP_SECURITY_AUTHENTICATION)) {
            this.o = string2;
        } else if (string.equalsIgnoreCase(RP_SECURITY_PRINCIPAL)) {
            this.p = string2;
        } else if (string.equalsIgnoreCase(RP_SECURITY_CREDENTIALS)) {
            this.q = string2;
        } else {
            throw new IllegalArgumentException("Unsupported request property: " + string);
        }
    }

    public String getRequestProperty(String string) {
        super.getRequestProperty(string);
        String string2 = null;
        if (string != null) {
            if (string.equalsIgnoreCase(RP_BASE_DN)) {
                string2 = this.f;
            } else if (string.equalsIgnoreCase(RP_SEARCH_SCOPE)) {
                string2 = LdapURLConnection.a(this.i);
            } else if (string.equalsIgnoreCase(RP_SIZE_LIMIT)) {
                string2 = String.valueOf(this.l);
            } else if (string.equalsIgnoreCase(RP_FILTER)) {
                string2 = this.j != null ? this.j : this.b(this.g);
            } else if (string.equalsIgnoreCase(RP_ATTRIBUTE_DESCRIPTION)) {
                string2 = this.a(this.g);
            } else if (string.equalsIgnoreCase(RP_EXTENSIONS)) {
                string2 = this.k;
            } else if (string.equalsIgnoreCase(RP_SECURITY_AUTHENTICATION)) {
                string2 = this.o;
            } else if (string.equalsIgnoreCase(RP_SECURITY_PRINCIPAL)) {
                string2 = this.p;
            } else if (string.equalsIgnoreCase(RP_SECURITY_CREDENTIALS)) {
                string2 = this.q;
            }
        }
        return string2;
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key must not be null");
        }
        if (string.equalsIgnoreCase(RP_ATTRIBUTE_DESCRIPTION)) {
            String[] stringArray;
            if (string2 != null && string2.length() > 0 && (stringArray = this.a(string2, false)).length > 0) {
                if (this.g == null || this.g.length == 0) {
                    this.g = stringArray;
                } else {
                    int n2;
                    Vector<String> vector = new Vector<String>();
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        boolean bl = true;
                        for (int i2 = 0; i2 < this.g.length; ++i2) {
                            if (!stringArray[n2].equals(this.g[i2])) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        vector.addElement(stringArray[n2]);
                    }
                    if (vector.size() > 0) {
                        n2 = this.g.length;
                        this.g = (String[])Util.resizeArray(this.g, this.g.length + vector.size());
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            this.g[n2++] = (String)enumeration.nextElement();
                        }
                    }
                }
            }
        } else {
            this.setRequestProperty(string, string2);
        }
    }

    public void setConnectTimeout(int n2) {
        this.m = n2 < -1 ? -1 : n2;
    }

    public int getConnectTimeout() {
        return this.m;
    }

    public void setReadTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout (" + n2 + ") cannot be negative");
        }
        this.n = n2;
    }

    public int getReadTimeout() {
        return this.n;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("url: " + this.url);
        if (this.f != null) {
            stringBuffer.append("\ndn: " + this.f);
        }
        if (this.g != null && (string = this.a(this.g)) != null) {
            stringBuffer.append("\nattribute description: " + string);
        }
        stringBuffer.append("\nscope: \"" + LdapURLConnection.a(this.i) + "\"");
        if (this.j != null) {
            stringBuffer.append("\nfilter: " + this.j);
        } else {
            stringBuffer.append("\nfilter: " + this.b(this.g));
        }
        if (this.k != null) {
            stringBuffer.append("\nextensions (not supported): " + this.k);
        }
        stringBuffer.append("\nsize limit: " + this.l);
        stringBuffer.append("\nconnect time out (ms): " + this.m);
        if (this.m == -1) {
            stringBuffer.append(" (not specified)");
        }
        stringBuffer.append("\nread time out (ms): " + this.n);
        if (this.o != null) {
            stringBuffer.append("\nsecurity authentication method: \"" + this.o + "\"");
        }
        return stringBuffer.toString();
    }

    public String getHeaderField(String string) {
        String string2 = null;
        if (string != null) {
            String string3 = string.toLowerCase(Locale.US);
            if (string3.equals("content-type")) {
                if (this.h != -1) {
                    switch (this.h) {
                        case 0: {
                            string2 = "certificate;binary";
                            break;
                        }
                        case 1: {
                            string2 = AD_ATTRIBUTE_CERTIFICATE;
                            break;
                        }
                        case 2: {
                            string2 = "revocationList;binary";
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (string3.equals("content-encoding")) {
                string2 = "DER";
            }
        }
        return string2;
    }

    public void setDoInput(boolean bl) {
    }

    public void setDoOutput(boolean bl) {
    }

    public void setAllowUserInteraction(boolean bl) {
    }

    public void setUseCaches(boolean bl) {
    }

    public void setIfModifiedSince(long l2) {
    }

    static {
        c.addElement("com.sun.jndi.ldap.connect.timeout");
        d = -1;
        e = 0;
        Util.toString(null, -1, 1);
    }
}

