/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures.etsi;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;
import java.util.ArrayList;
import java.util.Iterator;

public class QcCClegislation
extends QCStatementInfo {
    public static final ObjectID statementID = ObjectID.qcCClegislation;
    private ArrayList a = new ArrayList(1);

    public QcCClegislation() {
    }

    public QcCClegislation(String[] stringArray) {
        this();
        if (stringArray == null) {
            throw new NullPointerException("countryNames must not be null!");
        }
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("countryNames must not be empty!");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addCountryName(stringArray[i2]);
        }
    }

    public QcCClegislation(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public void addCountryName(String string) {
        if (string == null) {
            throw new NullPointerException("countryName must not be null!");
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException("countryName must consist of two characters!");
        }
        this.a.add(string);
    }

    public String[] getCountryNames() {
        return this.a.toArray(new String[0]);
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a.clear();
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType() + "). CountryNames must be SEQUENCE OF!");
        }
        int n2 = aSN1Object.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (!aSN1Object2.isA(ASN.PrintableString)) {
                throw new CodingException("CountryName must be ASN.1 PrintableString!");
            }
            String string = (String)aSN1Object2.getValue();
            this.a.add(string);
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            sEQUENCE.addComponent(new PrintableString(string));
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.a.iterator();
        stringBuffer.append("Country Name(s): ");
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

