/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.netscape;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.ObjectID;
import iaik.x509.V3Extension;

public class NetscapeCertType
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_NetscapeCertType;
    public static final int SSL_CLIENT = 128;
    public static final int SSL_SERVER = 64;
    public static final int S_MIME = 32;
    public static final int OBJECT_SIGNING = 16;
    public static final int SSL_CA = 4;
    public static final int S_MIME_CA = 2;
    public static final int OBJECT_SIGNING_CA = 1;
    private int a = 0;

    public NetscapeCertType() {
    }

    public NetscapeCertType(int n2) {
        this.a = n2;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) {
        byte[] byArray = (byte[])((BIT_STRING)aSN1Object).getValue();
        this.a = byArray[0];
    }

    public ASN1Object toASN1Object() {
        BIT_STRING bIT_STRING = null;
        byte[] byArray = new byte[]{(byte)this.a};
        int n2 = 0;
        for (int i2 = 0; i2 < 8 && (byArray[0] & 1 << i2) == 0; ++i2) {
            ++n2;
        }
        bIT_STRING = new BIT_STRING(byArray, n2);
        return bIT_STRING;
    }

    public void setCertType(int n2) {
        this.a = n2;
    }

    public int getCertType() {
        return this.a;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NetscapeCertType:");
        if ((this.a & 0x80) != 0) {
            stringBuffer.append(" SSL Client |");
        }
        if ((this.a & 0x40) != 0) {
            stringBuffer.append(" SSL Server |");
        }
        if ((this.a & 0x20) != 0) {
            stringBuffer.append(" S/MIME |");
        }
        if ((this.a & 0x10) != 0) {
            stringBuffer.append(" Object Signing |");
        }
        if ((this.a & 4) != 0) {
            stringBuffer.append(" SSL CA |");
        }
        if ((this.a & 2) != 0) {
            stringBuffer.append(" S/MIME CA |");
        }
        if ((this.a & 1) != 0) {
            stringBuffer.append(" Object Signing CA |");
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '|') {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

