/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class SubjectKeyIdentifier
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_SubjectKeyIdentifier;
    private byte[] a;

    public SubjectKeyIdentifier() {
    }

    public SubjectKeyIdentifier(byte[] byArray) {
        this.a = byArray;
    }

    public SubjectKeyIdentifier(PublicKey publicKey) throws CodingException, NoSuchAlgorithmException {
        Object object;
        byte[] byArray = null;
        try {
            object = publicKey.getEncoded();
            ASN1Object aSN1Object = DerCoder.decode((byte[])object);
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object.getComponentAt(1);
            byArray = (byte[])bIT_STRING.getValue();
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
        object = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                object = IaikSecurity.getMessageDigestInstance("SHA-1", IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object == null) {
            object = MessageDigest.getInstance("SHA-1");
        }
        ((MessageDigest)object).update(byArray);
        this.a = ((MessageDigest)object).digest();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) {
        this.a = (byte[])aSN1Object.getValue();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = ASN.create(ASN.OCTET_STRING, this.a);
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return aSN1Object;
    }

    public void set(byte[] byArray) {
        this.a = byArray;
    }

    public byte[] get() {
        return this.a;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        String string = this.a != null ? Util.toString(this.a) : "";
        return string;
    }
}

