/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_PrivateKeyUsagePeriod;
    private ChoiceOfTime a = null;
    private ChoiceOfTime b = null;

    public PrivateKeyUsagePeriod() {
    }

    public PrivateKeyUsagePeriod(Date date, Date date2) {
        if (date != null) {
            this.a = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
        }
        if (date2 != null) {
            this.b = new ChoiceOfTime(date2, ASN.GeneralizedTime, false);
        }
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            block6: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
                cON_SPEC.forceImplicitlyTagged(ASN.GeneralizedTime);
                ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                int n2 = cON_SPEC.getAsnType().getTag();
                switch (n2) {
                    case 0: {
                        this.a = new ChoiceOfTime(aSN1Object2);
                        continue block6;
                    }
                    case 1: {
                        this.b = new ChoiceOfTime(aSN1Object2);
                        continue block6;
                    }
                    default: {
                        throw new X509ExtensionException("Invalid tag: " + n2 + "!");
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.toString());
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.a.toASN1Object(), true));
        }
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(1, this.b.toASN1Object(), true));
        }
        return sEQUENCE;
    }

    public Date getNotBefore() {
        return this.a.getDate();
    }

    public Date getNotAfter() {
        return this.b.getDate();
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("not before: " + this.a + "\n");
        stringBuffer.append("not after : " + this.b);
        return stringBuffer.toString();
    }
}

