/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class IssuingDistributionPoint
extends V3Extension {
    public static final ObjectID oid = ObjectID.crlExt_IssuingDistributionPoint;
    private ASN1Type a = null;
    private boolean b = false;
    private boolean c = false;
    private int d = -1;
    private boolean e = false;
    private boolean f = false;

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("No DistributionPoint!");
        }
        try {
            block10: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
                int n2 = cON_SPEC.getAsnType().getTag();
                switch (n2) {
                    case 0: {
                        CON_SPEC cON_SPEC2 = (CON_SPEC)cON_SPEC.getValue();
                        int n3 = cON_SPEC2.getAsnType().getTag();
                        if (n3 == 0) {
                            cON_SPEC2.forceImplicitlyTagged(ASN.SEQUENCE);
                            this.a = new GeneralNames((ASN1Object)cON_SPEC2.getValue());
                            continue block10;
                        }
                        if (n3 == 1) {
                            cON_SPEC2.forceImplicitlyTagged(ASN.SET);
                            this.a = new RDN((ASN1Object)cON_SPEC2.getValue());
                            continue block10;
                        }
                        throw new CodingException("DistributionPointName: Unknown type [parse]!");
                    }
                    case 1: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.b = (Boolean)bOOLEAN.getValue();
                        continue block10;
                    }
                    case 2: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.c = (Boolean)bOOLEAN.getValue();
                        continue block10;
                    }
                    case 3: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                        BIT_STRING bIT_STRING = (BIT_STRING)cON_SPEC.getValue();
                        StringBuffer stringBuffer = new StringBuffer(bIT_STRING.getBinaryString()).reverse();
                        this.d = Integer.parseInt(stringBuffer.toString(), 2);
                        continue block10;
                    }
                    case 4: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.e = (Boolean)bOOLEAN.getValue();
                        continue block10;
                    }
                    case 5: {
                        cON_SPEC.forceImplicitlyTagged(ASN.BOOLEAN);
                        BOOLEAN bOOLEAN = (BOOLEAN)cON_SPEC.getValue();
                        this.f = (Boolean)bOOLEAN.getValue();
                        continue block10;
                    }
                    default: {
                        throw new CodingException("Invalid issuingDistributionPoint: unsupported tag number: " + n2);
                    }
                }
            }
            if (this.b && this.c) {
                throw new X509ExtensionException("OnlyContainsUserCerts and OnlyContainsCaCerts are not allowed both to be true!");
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        if (this.b && this.c) {
            throw new X509ExtensionException("OnlyContainsUserCerts and OnlyContainsCaCerts are not allowed both to be true!");
        }
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            if (this.a != null) {
                int n2 = -1;
                if (this.a instanceof GeneralNames) {
                    n2 = 0;
                } else if (this.a instanceof RDN) {
                    n2 = 1;
                } else {
                    throw new InternalErrorException("DistributionPointName: Unknown type [create]!");
                }
                CON_SPEC cON_SPEC = new CON_SPEC(n2, this.a.toASN1Object(), bl);
                sEQUENCE.addComponent(new CON_SPEC(0, cON_SPEC));
            }
            if (this.b) {
                sEQUENCE.addComponent(new CON_SPEC(1, new BOOLEAN(this.b), bl));
            }
            if (this.c) {
                sEQUENCE.addComponent(new CON_SPEC(2, new BOOLEAN(this.c), bl));
            }
            if (this.d != -1) {
                StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.d));
                stringBuffer.reverse();
                sEQUENCE.addComponent(new CON_SPEC(3, new BIT_STRING(stringBuffer.toString()), bl));
            }
            if (this.e) {
                sEQUENCE.addComponent(new CON_SPEC(4, new BOOLEAN(this.e), bl));
            }
            if (this.f) {
                sEQUENCE.addComponent(new CON_SPEC(5, new BOOLEAN(this.f), bl));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public void setDistributionPointName(ASN1Type aSN1Type) throws IllegalArgumentException {
        if (!(aSN1Type instanceof GeneralNames) && !(aSN1Type instanceof RDN)) {
            throw new IllegalArgumentException("Only instances of GeneralNames or RDN are accepted!");
        }
        this.a = aSN1Type;
    }

    public void setOnlyContainsUserCerts(boolean bl) {
        this.b = bl;
    }

    public void setOnlyContainsCaCerts(boolean bl) {
        this.c = bl;
    }

    public void setReasonFlags(int n2) {
        this.d = n2;
    }

    public void setIndirectCRL(boolean bl) {
        this.e = bl;
    }

    public void setOnlyContainsAttributeCerts(boolean bl) {
        this.f = bl;
    }

    public ASN1Type getDistributionPointName() {
        return this.a;
    }

    public boolean getOnlyContainsUserCerts() {
        return this.b;
    }

    public boolean getOnlyContainsCaCerts() {
        return this.c;
    }

    public int getReasonFlags() {
        return this.d;
    }

    public boolean getIndirectCRL() {
        return this.e;
    }

    public boolean getOnlyContainsAttributeCerts() {
        return this.f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("DistributionPoint: ");
            stringBuffer.append(this.a.toString() + "\n");
        }
        stringBuffer.append("onlyContainsUserCerts: " + this.b + "\n");
        stringBuffer.append("onlyContainsCaCerts: " + this.c + "\n");
        if (this.d > 0) {
            stringBuffer.append("reasonFlags: ");
            if ((this.d & 1) != 0) {
                stringBuffer.append("unused | ");
            }
            if ((this.d & 2) != 0) {
                stringBuffer.append("keyCompromise | ");
            }
            if ((this.d & 4) != 0) {
                stringBuffer.append("cACompromise | ");
            }
            if ((this.d & 8) != 0) {
                stringBuffer.append("affiliationChanged|");
            }
            if ((this.d & 0x10) != 0) {
                stringBuffer.append("superseded | ");
            }
            if ((this.d & 0x20) != 0) {
                stringBuffer.append("cessationOfOperation | ");
            }
            if ((this.d & 0x40) != 0) {
                stringBuffer.append("certificateHold | ");
            }
            stringBuffer.setLength(stringBuffer.length() - 3);
            stringBuffer.append("\n");
        }
        stringBuffer.append("indirectCRL: " + this.e + "\n");
        stringBuffer.append("onlyContainsAttributeCerts: " + this.f + "\n");
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

