/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Vector;

public class ExtendedKeyUsage
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_ExtendedKeyUsage;
    public static final ObjectID anyExtendedKeyUsage = new ObjectID("2.5.29.37.0", "Any extended key usage", null, false);
    public static final ObjectID serverAuth = new ObjectID("1.3.6.1.5.5.7.3.1", "TLS Web server authentication", null, false);
    public static final ObjectID clientAuth = new ObjectID("1.3.6.1.5.5.7.3.2", "TLS Web client authentication", null, false);
    public static final ObjectID codeSigning = new ObjectID("1.3.6.1.5.5.7.3.3", "Code signing", null, false);
    public static final ObjectID emailProtection = new ObjectID("1.3.6.1.5.5.7.3.4", "E-mail protection", null, false);
    public static final ObjectID ipsecEndSystem = new ObjectID("1.3.6.1.5.5.7.3.5", "IP security end system", null, false);
    public static final ObjectID ipsecTunnel = new ObjectID("1.3.6.1.5.5.7.3.6", "IP security tunel termination", null, false);
    public static final ObjectID ipsecUser = new ObjectID("1.3.6.1.5.5.7.3.7", "IP security user", null, false);
    public static final ObjectID timeStamping = new ObjectID("1.3.6.1.5.5.7.3.8", "Timestamping", null, false);
    public static final ObjectID ocspSigning = new ObjectID("1.3.6.1.5.5.7.3.9", "OCSPSigning", null, false);
    public static final ObjectID iKEIntermediate = new ObjectID("1.3.6.1.5.5.8.2.2", "iKEIntermediate", null, false);
    public static final ObjectID microsoftSGC = new ObjectID("1.3.6.1.4.1.311.10.3.3", "Microsoft Server Gated Cryptography", null, false);
    public static final ObjectID netscapeSGC = new ObjectID("2.16.840.1.113730.4.1", "Netscape Server Gated Cryptography", null, false);
    public static final ObjectID tslSigning = new ObjectID("0.4.0.2231.3.0", "tsl-signing", null, false);
    private Vector a = new Vector();

    public ExtendedKeyUsage() {
    }

    public ExtendedKeyUsage(ObjectID objectID) {
        this();
        this.addKeyPurposeID(objectID);
    }

    public ExtendedKeyUsage(ObjectID[] objectIDArray) {
        this();
        for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
            this.addKeyPurposeID(objectIDArray[i2]);
        }
    }

    public void addKeyPurposeID(ObjectID objectID) {
        if (!this.a.contains(objectID)) {
            this.a.addElement(objectID);
        }
    }

    public boolean removeKeyPurposeID(ObjectID objectID) {
        return this.a.removeElement(objectID);
    }

    public void removeAllKeyPurposeIDs() {
        this.a.removeAllElements();
    }

    public ObjectID[] getKeyPurposeIDs() {
        Object[] objectArray = new ObjectID[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public boolean contains(ObjectID objectID) {
        return this.a.contains(objectID);
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            sEQUENCE.addComponent((ASN1Object)this.a.elementAt(i2));
        }
        return sEQUENCE;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                this.a.addElement(aSN1Object.getComponentAt(i2));
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException("Error decoding extension: " + exception.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            stringBuffer.append("KeyPurposeId " + i2 + ":  " + ((ObjectID)this.a.elementAt(i2)).getName() + "\n");
        }
        if (stringBuffer.length() >= 1) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

