/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class BasicConstraints
extends V3Extension {
    public static final ObjectID oid = ObjectID.certExt_BasicConstraints;
    private boolean a = false;
    private int b = -1;

    public BasicConstraints() {
    }

    public BasicConstraints(boolean bl, int n2) {
        this.a = bl;
        this.b = n2;
    }

    public BasicConstraints(boolean bl) {
        this.a = bl;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
                if (aSN1Object2.isA(ASN.BOOLEAN)) {
                    this.a = (Boolean)aSN1Object2.getValue();
                    continue;
                }
                if (!aSN1Object2.isA(ASN.INTEGER)) continue;
                this.b = ((BigInteger)aSN1Object2.getValue()).intValue();
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.toString());
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a) {
            sEQUENCE.addComponent(new BOOLEAN(this.a));
        }
        if (this.b != -1) {
            sEQUENCE.addComponent(new INTEGER(this.b));
        }
        return sEQUENCE;
    }

    public void setPathLenConstraint(int n2) {
        this.b = n2;
    }

    public void setCa(boolean bl) {
        this.a = bl;
    }

    public int getPathLenConstraint() {
        return this.b;
    }

    public boolean ca() {
        return this.a;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CA: ").append(this.a ? "yes" : "no");
        if (this.b >= 0) {
            stringBuffer.append("\nPathLenConstraint: ");
            stringBuffer.append(Integer.toString(this.b));
        }
        return stringBuffer.toString();
    }
}

