/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Enumeration;
import java.util.Vector;

public class AcceptableCertPolicies
extends V3Extension {
    public static final ObjectID oid = ObjectID.attrCertExt_AcceptableCertPolicies;
    private Vector a = new Vector();

    public ASN1Object toASN1Object() throws X509ExtensionException {
        if (this.a == null) {
            throw new X509ExtensionException("No CertPolicyIds set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            sEQUENCE.addComponent((ObjectID)enumeration.nextElement());
        }
        return sEQUENCE;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 AcceptedCertPolicies. Must be SEQUENCE OF!");
        }
        this.a = new Vector();
        try {
            int n2 = aSN1Object.countComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
                if (!aSN1Object2.isA(ASN.ObjectID)) {
                    throw new X509ExtensionException("Invalid ASN.1 CertPolicyId. Expected ObjectID!");
                }
                this.a.addElement(aSN1Object2);
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.toString());
        }
    }

    public String[] getPolicyOIDs() {
        ObjectID[] objectIDArray = this.getPolicies();
        String[] stringArray = new String[objectIDArray.length];
        for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
            stringArray[i2] = objectIDArray[i2].getID();
        }
        return stringArray;
    }

    public ObjectID[] getPolicies() {
        Object[] objectArray = new ObjectID[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public void addAcceptableCertPolicy(String string) {
        this.addAcceptableCertPolicy(new ObjectID(string));
    }

    public void addAcceptableCertPolicy(ObjectID objectID) {
        this.a.addElement(objectID);
    }

    public void removeAcceptablePolicy(ObjectID objectID) {
        this.a.removeElement(objectID);
    }

    public void removeAcceptablePolicy(String string) {
        this.removeAcceptablePolicy(new ObjectID(string));
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.a.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("certPolicy[" + n2++ + "]: " + enumeration.nextElement() + "\n");
        }
        if (stringBuffer.length() >= 1) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

