/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.ObjectDigestInfo;

public class V2Form
implements AttCertIssuer {
    GeneralNames a;
    IssuerSerial b;
    ObjectDigestInfo c;

    public V2Form(GeneralNames generalNames) {
        if (generalNames == null) {
            throw new IllegalArgumentException("Cannot create V2Form: Missing issuer name!");
        }
        this.a = generalNames;
    }

    public V2Form(Name name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create V2Form: Missing issuerName!");
        }
        GeneralName generalName = new GeneralName(4, name);
        this.a = new GeneralNames(generalName);
    }

    public V2Form(GeneralNames generalNames, IssuerSerial issuerSerial, ObjectDigestInfo objectDigestInfo) {
        if (generalNames == null && issuerSerial == null && objectDigestInfo == null) {
            throw new IllegalArgumentException("All components of a V2Form are not allowed to be null!");
        }
        this.a = generalNames;
        this.b = issuerSerial;
        this.c = objectDigestInfo;
    }

    public V2Form(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public GeneralNames getIssuerName() {
        return this.a;
    }

    public Name getIssuerDN() {
        GeneralName[] generalNameArray;
        Name name = null;
        if (this.a != null && (generalNameArray = this.a.getNames(4)).length > 0) {
            name = (Name)generalNameArray[0].getName();
        }
        return name;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.b;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.c;
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            try {
                sEQUENCE.addComponent(this.a.toASN1Object());
            }
            catch (CodingException codingException) {
                throw new InternalErrorException("Error when adding issuerName component: " + codingException.getMessage(), codingException);
            }
        }
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.b.toASN1Object(), bl));
        }
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(1, this.c.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.countComponents();
        if (n2 > 3) {
            throw new CodingException("Cannot decode V2Form: invalid number of components: " + n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (aSN1Object2.isA(ASN.CON_SPEC)) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                int n3 = cON_SPEC.getAsnType().getTag();
                switch (n3) {
                    case 0: {
                        this.b = new IssuerSerial((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    case 1: {
                        this.c = new ObjectDigestInfo((ASN1Object)cON_SPEC.getValue());
                        break;
                    }
                    default: {
                        throw new CodingException("Cannot decode V2Form. Invalid tag: " + n3);
                    }
                }
                continue;
            }
            this.a = new GeneralNames(aSN1Object2);
        }
        if (this.a == null && this.b == null && this.c == null) {
            throw new CodingException("All components of a V2Form are not allowed to be null!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof V2Form)) {
            return false;
        }
        V2Form v2Form = (V2Form)object;
        if (this.a != null && v2Form.a != null ? !this.a.equals(v2Form.a) : this.a != null || v2Form.a != null) {
            return false;
        }
        if (this.b != null && v2Form.b != null ? !this.b.equals(v2Form.b) : this.b != null || v2Form.b != null) {
            return false;
        }
        if (this.c != null && v2Form.c != null) {
            return this.c.equals(v2Form.c);
        }
        return this.c == null && v2Form.c == null;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.a != null) {
            n2 += this.a.hashCode();
        }
        if (this.b != null) {
            n2 += this.b.hashCode();
        }
        if (this.c != null) {
            n2 += this.c.hashCode();
        }
        return n2;
    }

    public int getVForm() {
        return 2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (this.a != null) {
            stringBuffer.append("issuerName: " + this.a);
            bl = false;
        }
        if (this.b != null) {
            stringBuffer.append((bl ? "" : "\n") + "baseCertificateID: " + this.b);
            bl = false;
        }
        if (this.c != null) {
            stringBuffer.append((bl ? "" : "\n") + "objectDigestInfo: " + this.c);
        }
        return stringBuffer.toString();
    }
}

