/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.ObjectDigestInfo;
import iaik.x509.extensions.SubjectAltName;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;

public class Holder {
    IssuerSerial a;
    GeneralNames b;
    ObjectDigestInfo c;

    public Holder() {
    }

    public Holder(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public IssuerSerial getBaseCertificateID() {
        return this.a;
    }

    public void setBaseCertificateID(IssuerSerial issuerSerial) {
        this.a = issuerSerial;
    }

    public void setBaseCertificateID(X509Certificate x509Certificate) {
        this.a = new IssuerSerial(x509Certificate);
    }

    public GeneralNames getEntityName() {
        return this.b;
    }

    public void setEntityName(GeneralNames generalNames) {
        this.b = generalNames;
    }

    public void setEntityName(X509Certificate x509Certificate) throws IllegalArgumentException {
        boolean bl = false;
        Name name = (Name)x509Certificate.getSubjectDN();
        if (!name.isEmpty()) {
            GeneralNames generalNames;
            GeneralName generalName = new GeneralName(4, name);
            this.b = generalNames = new GeneralNames(generalName);
            bl = true;
        } else {
            try {
                GeneralNames generalNames;
                Enumeration enumeration;
                SubjectAltName subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
                if (subjectAltName != null && (enumeration = (generalNames = subjectAltName.getGeneralNames()).getNames()).hasMoreElements()) {
                    this.b = generalNames;
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Cannot create entityName. Certificate has empty subjectDN field and no SubjectAltName extension.");
        }
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.c;
    }

    public void setObjectDigestInfo(ObjectDigestInfo objectDigestInfo) {
        this.c = objectDigestInfo;
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.a.toASN1Object(), bl));
        }
        if (this.b != null) {
            try {
                sEQUENCE.addComponent(new CON_SPEC(1, this.b.toASN1Object(), bl));
            }
            catch (CodingException codingException) {
                throw new InternalErrorException("Error when adding entityName component: " + codingException.getMessage(), codingException);
            }
        }
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.c.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        int n2 = 1;
        if (aSN1Object.getAsnType().equals(ASN.SEQUENCE) && (n2 = aSN1Object.countComponents()) > 3) {
            throw new CodingException("Cannot decode Holder: invalid number of components: " + n2);
        }
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            CON_SPEC cON_SPEC;
            if (aSN1Object.getAsnType().equals(ASN.SEQUENCE)) {
                cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            } else {
                cON_SPEC = (CON_SPEC)aSN1Object;
            }
            int n3 = cON_SPEC.getAsnType().getTag();
            switch (n3) {
                case 0: {
                    this.a = new IssuerSerial((ASN1Object)cON_SPEC.getValue());
                    continue block5;
                }
                case 1: {
                    this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                    continue block5;
                }
                case 2: {
                    this.c = new ObjectDigestInfo((ASN1Object)cON_SPEC.getValue());
                    continue block5;
                }
                default: {
                    throw new CodingException("Cannot decode Holder. Invalid tag: " + n3);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Holder)) {
            return false;
        }
        Holder holder = (Holder)object;
        if (this.a != null && holder.a != null ? !this.a.equals(holder.a) : this.a != null || holder.a != null) {
            return false;
        }
        if (this.b != null && holder.b != null ? !this.b.equals(holder.b) : this.b != null || holder.b != null) {
            return false;
        }
        if (this.c != null && holder.c != null) {
            return this.c.equals(holder.c);
        }
        return this.c == null && holder.c == null;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.a != null) {
            n2 += this.a.hashCode();
        }
        if (this.b != null) {
            n2 += this.b.hashCode();
        }
        if (this.c != null) {
            n2 += this.c.hashCode();
        }
        return n2;
    }

    public boolean identifiesCert(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (this.a != null) {
            return this.a.identifiesCert(x509Certificate);
        }
        if (this.b != null) {
            Name name = (Name)x509Certificate.getSubjectDN();
            if (name != null && !name.isEmpty()) {
                GeneralName generalName = new GeneralName(4, name);
                GeneralNames generalNames = new GeneralNames(generalName);
                return generalNames.equals(this.b);
            }
            try {
                SubjectAltName subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
                if (subjectAltName != null) {
                    GeneralNames generalNames = subjectAltName.getGeneralNames();
                    if (this.b.equals(generalNames)) {
                        return true;
                    }
                    Enumeration enumeration = this.b.getNames();
                    boolean bl = false;
                    while (enumeration.hasMoreElements()) {
                        GeneralName generalName = (GeneralName)enumeration.nextElement();
                        Enumeration enumeration2 = generalNames.getNames();
                        bl = false;
                        while (enumeration2.hasMoreElements()) {
                            if (!generalName.equals(enumeration2.nextElement())) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        return false;
                    }
                }
            }
            catch (X509ExtensionException x509ExtensionException) {
                return false;
            }
            return false;
        }
        if (this.c != null) {
            return this.c.identifiesCert(x509Certificate);
        }
        return false;
    }

    public String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("baseCertificateID: \n" + this.a.a("  "));
            bl = false;
        }
        if (this.b != null) {
            stringBuffer.append((bl ? "" : "\n") + "entityName: " + this.b);
            bl = false;
        }
        if (this.c != null) {
            stringBuffer.append((bl ? "" : "\n") + "objectDigestInfo: " + this.c);
        }
        return stringBuffer.toString();
    }
}

