/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.utils.CollectionVector;
import iaik.utils.Util;
import iaik.x509.attr.ACRL;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class AttributeCertificateFactory
extends CertificateFactorySpi {
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            return new AttributeCertificate(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Error reading from InputStream: " + iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Object[] objectArray = null;
        try {
            objectArray = Util.readAttributeCertificateChain(inputStream);
            return AttributeCertificateFactory.a(objectArray);
        }
        catch (Exception exception) {
            throw new CertificateException("Error parsing attribute certificates: " + exception.toString());
        }
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            return new ACRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException("Error reading from InputStream: " + iOException.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        Object[] objectArray = null;
        try {
            objectArray = Util.readACRLChain(inputStream);
            return AttributeCertificateFactory.a(objectArray);
        }
        catch (IOException iOException) {
            throw new CRLException("Error reading ACRL: " + iOException.toString());
        }
    }

    private static Collection a(Object[] objectArray) {
        CollectionVector collectionVector = new CollectionVector();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                collectionVector.add(objectArray[i2]);
            }
        }
        return collectionVector;
    }
}

