/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificateExtensions;
import iaik.x509.attr.Holder;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import iaik.x509.attr.extensions.ProxyInfo;
import iaik.x509.attr.extensions.TargetInformation;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class AttributeCertificate
extends Certificate
implements ASN1Type,
X509Extension {
    private transient ASN1 g;
    private int h = 2;
    private Holder i;
    private AttCertIssuer j;
    private AlgorithmID k;
    private BigInteger l;
    private ChoiceOfTime m;
    private ChoiceOfTime n;
    private Vector o;
    private BigInteger p;
    private AttributeCertificateExtensions q;
    private byte[] r;
    private boolean s;
    private byte[] t;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;

    public static void registerStandardAttributeImplementations() {
        Attribute.register(ObjectID.accessIdentity, a == null ? (a = AttributeCertificate.class$("iaik.x509.attr.attributes.AccessIdentity")) : a);
        Attribute.register(ObjectID.chargingIdentity, b == null ? (b = AttributeCertificate.class$("iaik.x509.attr.attributes.ChargingIdentity")) : b);
        Attribute.register(ObjectID.clearance, c == null ? (c = AttributeCertificate.class$("iaik.x509.attr.attributes.Clearance")) : c);
        Attribute.register(ObjectID.group, d == null ? (d = AttributeCertificate.class$("iaik.x509.attr.attributes.Group")) : d);
        Attribute.register(ObjectID.role, e == null ? (e = AttributeCertificate.class$("iaik.x509.attr.attributes.Role")) : e);
        Attribute.register(ObjectID.authenticationInfo, f == null ? (f = AttributeCertificate.class$("iaik.x509.attr.attributes.ServiceAuthenticationInfo")) : f);
    }

    public AttributeCertificate() {
        super("X.509-AC");
        this.a();
        this.o = new Vector();
        this.g = new ASN1();
    }

    public AttributeCertificate(InputStream inputStream) throws IOException, CertificateException {
        this();
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public AttributeCertificate(byte[] byArray) throws CertificateException {
        this();
        if (byArray == null) {
            throw new NullPointerException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.g = new ASN1(byArray);
            this.d();
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    private void a() {
        this.s = true;
        this.t = null;
        this.g = null;
    }

    private void b() {
        if (this.s) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    private void c() {
        this.s = false;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse certificate from a null object!");
        }
        this.g = new ASN1(aSN1Object);
        try {
            this.d();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public void decode(InputStream inputStream) throws IOException, CertificateException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.g = new ASN1(inputStream);
            this.d();
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    private void d() throws CertificateException, X509ExtensionException {
        int n2 = 0;
        try {
            int n3;
            Object object;
            ASN1Object aSN1Object = this.g.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.g.getComponentAt(1));
            ASN1Object aSN1Object2 = this.g.getComponentAt(2);
            this.r = (byte[])((BIT_STRING)aSN1Object2).getValue();
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(0);
            if (aSN1Object3.isA(ASN.INTEGER)) {
                object = (BigInteger)aSN1Object3.getValue();
                this.h = ((BigInteger)object).intValue() + 1;
                ++n2;
            } else {
                this.h = 1;
            }
            this.i = new Holder(aSN1Object.getComponentAt(0 + n2));
            aSN1Object3 = aSN1Object.getComponentAt(1 + n2);
            if (aSN1Object3.isA(ASN.CON_SPEC)) {
                object = (CON_SPEC)aSN1Object3;
                ((CON_SPEC)object).forceImplicitlyTagged(ASN.SEQUENCE);
                this.j = new V2Form((ASN1Object)((CON_SPEC)object).getValue());
            } else {
                this.j = new V1Form(aSN1Object3);
            }
            this.k = new AlgorithmID(aSN1Object.getComponentAt(2 + n2));
            if (!algorithmID.equals(this.k)) {
                throw new CertificateException("Certificate signature algorithm mismatch");
            }
            this.l = (BigInteger)aSN1Object.getComponentAt(3 + n2).getValue();
            object = new ASN1(aSN1Object.getComponentAt(4 + n2));
            this.m = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.n = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            aSN1Object3 = aSN1Object.getComponentAt(5 + n2);
            for (n3 = 0; n3 < aSN1Object3.countComponents(); ++n3) {
                this.o.addElement(new Attribute(aSN1Object3.getComponentAt(n3)));
            }
            n3 = 6 + n2;
            while (n3 < aSN1Object.countComponents()) {
                if ((aSN1Object3 = aSN1Object.getComponentAt(n3++)).isA(ASN.BIT_STRING)) {
                    this.p = new BigInteger(1, (byte[])aSN1Object3.getValue());
                    continue;
                }
                this.q = new AttributeCertificateExtensions(aSN1Object3);
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        this.g.clearASN1Object();
        this.c();
    }

    private ASN1Object e() throws CertificateEncodingException {
        if (this.i == null) {
            throw new CertificateEncodingException("Holder not set!");
        }
        if (this.j == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.k == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.l == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.m == null) {
            throw new CertificateEncodingException("Valid not before time not set!");
        }
        if (this.n == null) {
            throw new CertificateEncodingException("Valid not after time not set!");
        }
        if (this.o.isEmpty()) {
            throw new CertificateEncodingException("No Attributes set!");
        }
        if (this.q != null && !this.q.hasExtensions()) {
            this.q = null;
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.h > 1) {
                sEQUENCE.addComponent(new INTEGER(this.h - 1));
            }
            sEQUENCE.addComponent(this.i.toASN1Object());
            boolean bl = true;
            if (this.j.getVForm() == 1) {
                sEQUENCE.addComponent(this.j.toASN1Object());
            } else {
                sEQUENCE.addComponent(new CON_SPEC(0, this.j.toASN1Object(), bl));
            }
            sEQUENCE.addComponent(this.k.toASN1Object());
            sEQUENCE.addComponent(new INTEGER(this.l));
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.m.toASN1Object());
            sEQUENCE2.addComponent(this.n.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            Enumeration enumeration = this.o.elements();
            while (enumeration.hasMoreElements()) {
                sEQUENCE3.addComponent(((Attribute)enumeration.nextElement()).toASN1Object(true));
            }
            sEQUENCE.addComponent(sEQUENCE3);
            if (this.p != null) {
                BIT_STRING bIT_STRING = new BIT_STRING(this.p.toByteArray());
                sEQUENCE.addComponent(bIT_STRING);
            }
            if (this.q != null) {
                sEQUENCE.addComponent(this.q.toASN1Object());
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, string, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, Provider provider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, provider);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, null, provider);
    }

    private void a(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string, Provider provider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        Signature signature;
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        this.k = algorithmID;
        Signature signature2 = signature = provider != null ? this.k.getSignatureInstance(provider) : this.k.getSignatureInstance(string);
        if (algorithmParameterSpec != null) {
            signature.setParameter(algorithmParameterSpec);
        }
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.k) && !this.k.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.k.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a();
        object = this.e();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.r = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.r);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.k.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.g = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.toString());
        }
        this.c();
    }

    public void setSignature(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot sign certificate! No signature value specified!");
        }
        this.r = byArray;
        ASN1Object aSN1Object = this.e();
        this.a();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.r);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.k.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.g = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        this.c();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.m == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.m.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.n == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.n.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        this.b();
        return this.toByteArray();
    }

    public int getVersion() {
        return this.h;
    }

    public BigInteger getSerialNumber() {
        return this.l;
    }

    public AttCertIssuer getIssuer() {
        return this.j;
    }

    public Holder getHolder() {
        return this.i;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public Date getNotBeforeTime() {
        return this.m == null ? null : this.m.getDate();
    }

    public Date getNotAfterTime() {
        return this.n == null ? null : this.n.getDate();
    }

    public byte[] getAcInfo() throws CertificateEncodingException {
        try {
            if (this.g != null && this.g.toByteArray() != null) {
                return this.g.getFirstObject();
            }
            return DerCoder.encode(this.e());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.k = algorithmID;
        this.a();
    }

    public byte[] getSignature() {
        return this.r;
    }

    public String getSigAlgName() {
        String string = null;
        if (this.k != null) {
            try {
                string = this.k.getJcaStandardName();
            }
            catch (Exception exception) {
                string = this.k.getName();
            }
        }
        return string;
    }

    public String getSigAlgOID() {
        return this.k == null ? null : this.k.getAlgorithm().getID();
    }

    public byte[] getSigAlgParams() {
        if (this.k == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.k.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public boolean[] getIssuerUniqueID() {
        if (this.p == null) {
            return null;
        }
        String string = this.p.toString(2);
        return Util.toBooleanArray(string);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null, string, null);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.verify(publicKey, null, provider);
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec, String string, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.b();
        Signature signature = provider != null ? this.k.getSignatureInstance(provider) : this.k.getSignatureInstance(string);
        try {
            byte[] byArray = this.g.getFirstObject();
            if (algorithmParameterSpec != null) {
                String string2 = "";
                if (algorithmParameterSpec instanceof DSAParameterSpec) {
                    string2 = "DSAParameterSpec";
                }
                Util.setSignatureParameters(signature, algorithmParameterSpec, string2);
            }
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.r)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null, null, null);
    }

    public void verify(DSAPublicKey dSAPublicKey, DSAParameterSpec dSAParameterSpec) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.b();
        Signature signature = IaikSecurity.getSignatureInstance("DSA", IAIK.getInstance());
        try {
            byte[] byArray = this.g.getFirstObject();
            Util.setSignatureParameters(signature, dSAParameterSpec, "DSAParameterSpec");
            signature.initVerify(dSAPublicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.r)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        try {
            this.verify(publicKey, algorithmParameterSpec, null, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.toString());
        }
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, algorithmParameterSpec, string, null);
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        try {
            this.verify(publicKey, algorithmParameterSpec, null, provider);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.toString());
        }
    }

    public ASN1Object toASN1Object() {
        this.b();
        return this.g.toASN1Object();
    }

    public byte[] toByteArray() {
        this.b();
        return this.g.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.g.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.g = new ASN1(objectInputStream);
            this.d();
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.l = bigInteger;
        this.a();
    }

    public void setIssuer(AttCertIssuer attCertIssuer) {
        this.j = attCertIssuer;
        this.a();
    }

    public void setNotBeforeTime(Date date) {
        this.m = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
        this.a();
    }

    public void setNotAfterTime(Date date) {
        this.n = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
        this.a();
    }

    public void setHolder(Holder holder) {
        this.i = holder;
        this.a();
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.p = new BigInteger(Util.fromBooleanArray(blArray), 2);
        this.a();
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.k;
    }

    public byte[] getFingerprint() {
        this.b();
        return this.g.fingerprint();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.b();
        MessageDigest messageDigest = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                messageDigest = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(string);
        }
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprintSHA() {
        if (this.t == null) {
            try {
                this.t = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.t;
    }

    public String toString() {
        return this.toString(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.q == null ? null : this.q.getCriticalExtensionOIDs();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.q == null ? null : this.q.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.q == null ? null : this.q.getExtensionValue(string);
    }

    public byte[] getRawExtensionValue(String string) {
        return this.q == null ? null : this.q.getRawExtensionValue(string);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.q == null) {
            this.q = new AttributeCertificateExtensions();
        }
        if (v3Extension instanceof ProxyInfo) {
            ((ProxyInfo)v3Extension).specifyHolder(this.i);
        }
        this.q.addExtension(v3Extension);
        this.a();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.q == null ? false : this.q.removeExtension(objectID);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.q != null) {
            this.q.removeAllExtensions();
            this.a();
        }
        this.q = null;
    }

    public Enumeration listExtensions() {
        Enumeration enumeration = null;
        if (this.q != null) {
            Enumeration enumeration2 = this.q.listExtensions();
            if (enumeration2.hasMoreElements()) {
                Vector<V3Extension> vector = new Vector<V3Extension>();
                while (enumeration2.hasMoreElements()) {
                    V3Extension v3Extension = (V3Extension)enumeration2.nextElement();
                    if (v3Extension instanceof ProxyInfo) {
                        ((ProxyInfo)v3Extension).specifyHolder(this.i);
                    }
                    vector.addElement(v3Extension);
                }
                enumeration = vector.elements();
            } else {
                enumeration = enumeration2;
            }
        }
        return enumeration;
    }

    public boolean hasExtensions() {
        return this.q == null ? false : this.q.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.q == null ? false : this.q.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.q == null ? 0 : this.q.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        V3Extension v3Extension = null;
        if (this.q != null && (v3Extension = this.q.getExtension(objectID)) instanceof ProxyInfo) {
            ((ProxyInfo)v3Extension).specifyHolder(this.i);
        }
        return v3Extension;
    }

    public void addAttribute(Attribute attribute) {
        if (attribute != null) {
            this.a();
            int n2 = this.o.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!attribute.getType().equals(((Attribute)this.o.elementAt(i2)).getType())) continue;
                this.o.setElementAt(attribute, i2);
                return;
            }
            this.o.addElement(attribute);
        }
    }

    public void setAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            this.o.removeAllElements();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                this.o.addElement(attributeArray[i2]);
            }
            this.a();
        }
    }

    public void removeAllAttributes() {
        this.o.removeAllElements();
        this.a();
    }

    public Attribute removeAttribute(ObjectID objectID) {
        if (objectID != null) {
            int n2 = this.o.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!objectID.equals(((Attribute)this.o.elementAt(i2)).getType())) continue;
                Attribute attribute = (Attribute)this.o.elementAt(i2);
                this.o.removeElementAt(i2);
                this.a();
                return attribute;
            }
        }
        return null;
    }

    public Enumeration getAttributes() {
        return this.o.elements();
    }

    public Attribute getAttribute(ObjectID objectID) {
        if (this.o == null) {
            return null;
        }
        Enumeration enumeration = this.o.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getType().equals(objectID)) continue;
            return attribute;
        }
        return null;
    }

    public boolean isTargetFor(Object object) throws TargetException {
        boolean bl = true;
        try {
            TargetInformation targetInformation = (TargetInformation)this.getExtension(TargetInformation.oid);
            bl = targetInformation.isTargetFor(object);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new TargetException("Error parsing TargetInformation extension: " + x509ExtensionInitException.toString());
        }
        return bl;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.h);
        stringBuffer.append("\nHolder: { " + this.i + " }");
        stringBuffer.append("\nIssuer: {" + this.j + "}");
        stringBuffer.append("\nSignature algorithm: " + this.k);
        stringBuffer.append("\nSerial number:       " + this.l);
        stringBuffer.append("\nSerial number (hex): 0x" + this.l.toString(16));
        stringBuffer.append("\nValid not before time: " + this.m);
        stringBuffer.append("\nValid not after  time: " + this.n);
        stringBuffer.append("\nAttributes: ");
        if (bl) {
            Enumeration enumeration = this.o.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("\n" + enumeration.nextElement());
            }
        } else {
            stringBuffer.append(this.o.size());
        }
        stringBuffer.append("\n");
        if (this.p != null) {
            stringBuffer.append("Issuer Unique ID:       " + this.p + "\n");
            stringBuffer.append("Issuer Unique ID (hex): 0x" + this.p.toString(16) + "\n");
        }
        stringBuffer.append("\n");
        if (this.q != null) {
            if (bl) {
                stringBuffer.append(this.q);
            } else {
                stringBuffer.append("Extensions: " + this.q.countExtensions() + "\n");
            }
        }
        stringBuffer.append("Certificate Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Certificate Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AttributeCertificate.registerStandardAttributeImplementations();
        Util.toString(null, -1, 1);
    }
}

