/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.ReasonCode;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class RevokedCertificate
extends X509CRLEntry
implements Cloneable {
    private BigInteger a;
    private ChoiceOfTime b;
    private X509Extensions c;
    private ReasonCode d;
    private int e = 2;

    public Object clone() {
        RevokedCertificate revokedCertificate = null;
        try {
            revokedCertificate = (RevokedCertificate)super.clone();
            revokedCertificate.a(this.toASN1Object());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return revokedCertificate;
    }

    RevokedCertificate() {
    }

    public RevokedCertificate(ASN1Object aSN1Object) throws CRLException {
        try {
            this.a(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
    }

    public RevokedCertificate(X509Certificate x509Certificate, Date date) {
        this.a = x509Certificate.getSerialNumber();
        this.b = new ChoiceOfTime(date, true, false);
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.a = bigInteger;
        this.b = new ChoiceOfTime(date, true, false);
    }

    public ASN1Object toASN1Object() throws CRLException {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(this.b.toASN1Object());
            if (this.c != null) {
                if (this.c.countExtensions() > 0) {
                    sEQUENCE.addComponent(this.c.toASN1Object());
                }
            } else if (this.d != null) {
                X509Extensions x509Extensions = new X509Extensions(2, 2);
                x509Extensions.addExtension(this.d);
                sEQUENCE.addComponent(x509Extensions.toASN1Object());
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.getMessage());
        }
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse revoked certificate from a null object!");
        }
        try {
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            ChoiceOfTime choiceOfTime = new ChoiceOfTime(aSN1Object.getComponentAt(1));
            X509Extensions x509Extensions = null;
            if (aSN1Object.countComponents() > 2) {
                x509Extensions = new X509Extensions(this.e, this.e);
                x509Extensions.decode(aSN1Object.getComponentAt(2));
            }
            this.a = bigInteger;
            this.b = choiceOfTime;
            if (x509Extensions != null) {
                if (x509Extensions.countExtensions() == 1) {
                    ReasonCode reasonCode = (ReasonCode)x509Extensions.getExtension(ReasonCode.oid);
                    if (reasonCode != null) {
                        this.d = reasonCode;
                    } else {
                        this.c = x509Extensions;
                    }
                } else {
                    this.c = x509Extensions;
                }
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.getMessage());
        }
    }

    public byte[] getEncoded() throws CRLException {
        return DerCoder.encode(this.toASN1Object());
    }

    public BigInteger getSerialNumber() {
        return this.a;
    }

    public Date getRevocationDate() {
        return this.b.getDate();
    }

    public Set getCriticalExtensionOIDs() {
        Set<String> set = null;
        if (this.d != null && this.d.isCritical()) {
            set = new HashSet<String>();
            set.add(this.d.getObjectID().getID());
        }
        if (set == null && this.c != null) {
            set = this.c.getCriticalExtensionOIDs();
        }
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    public Set getNonCriticalExtensionOIDs() {
        Set<String> set = null;
        if (this.d != null && !this.d.isCritical()) {
            set = new HashSet<String>();
            set.add(this.d.getObjectID().getID());
        }
        if (set == null && this.c != null) {
            set = this.c.getNonCriticalExtensionOIDs();
        }
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    public byte[] getExtensionValue(String string) {
        byte[] byArray = this.getRawExtensionValue(string);
        if (byArray != null) {
            byArray = DerCoder.encode(new OCTET_STRING(byArray));
        }
        return byArray;
    }

    public byte[] getRawExtensionValue(String string) {
        byte[] byArray = null;
        if (this.d != null && string.equals(ReasonCode.oid.getID())) {
            byArray = DerCoder.encode(this.d.toASN1Object());
        } else if (this.c != null) {
            byArray = this.c.getRawExtensionValue(string);
        }
        return byArray;
    }

    boolean a(ObjectID objectID) {
        boolean bl = false;
        if (this.d != null) {
            bl = objectID.equals(ReasonCode.oid);
        } else if (this.c != null) {
            bl = this.c.a(objectID);
        }
        return bl;
    }

    public boolean hasExtensions() {
        boolean bl;
        boolean bl2 = bl = this.d != null;
        if (!bl) {
            bl = this.c == null ? false : this.c.hasExtensions();
        }
        return bl;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.c == null ? false : this.c.hasUnsupportedCriticalExtension();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.c != null) {
            this.c.addExtension(v3Extension);
        } else if (v3Extension instanceof ReasonCode) {
            this.d = (ReasonCode)v3Extension;
        } else {
            this.c = new X509Extensions(this.e, this.e);
            if (this.d != null) {
                this.c.addExtension(this.d);
                this.d = null;
            }
            this.c.addExtension(v3Extension);
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        if (this.d != null && objectID.equals(ReasonCode.oid)) {
            this.d = null;
            bl = true;
        } else {
            boolean bl2 = bl = this.c == null ? false : this.c.removeExtension(objectID);
            if (bl) {
                int n2 = this.c.countExtensions();
                if (n2 == 1) {
                    try {
                        ReasonCode reasonCode = (ReasonCode)this.c.getExtension(ReasonCode.oid);
                        if (reasonCode != null) {
                            this.d = reasonCode;
                            n2 = 0;
                        }
                    }
                    catch (X509ExtensionInitException x509ExtensionInitException) {
                        // empty catch block
                    }
                }
                if (n2 == 0) {
                    this.c = null;
                }
            }
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.d != null) {
            this.d = null;
        }
        if (this.c != null) {
            this.c.removeAllExtensions();
            this.c = null;
        }
    }

    public Enumeration listExtensions() {
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this.c == null ? null : this.c.listExtensions();
        if (enumeration == null) {
            Vector<ReasonCode> vector;
            if (this.d != null) {
                vector = new Vector<ReasonCode>(1);
                vector.add(this.d);
            } else {
                vector = new Vector(0);
            }
            enumeration = vector.elements();
        }
        return enumeration;
    }

    public int countExtensions() {
        int n2 = 0;
        if (this.d != null) {
            n2 = 1;
        } else if (this.c != null) {
            n2 = this.c.countExtensions();
        }
        return n2;
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        V3Extension v3Extension;
        V3Extension v3Extension2 = v3Extension = this.c == null ? null : this.c.getExtension(objectID);
        if (v3Extension == null && this.d != null && objectID.equals(ReasonCode.oid)) {
            v3Extension = this.d;
        }
        return v3Extension;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RevokedCertificate:\n");
        stringBuffer.append("serial number:       " + this.a + "\n");
        stringBuffer.append("serial number (hex): 0x" + this.a.toString(16) + "\n");
        stringBuffer.append("revocation date: " + this.b.getDate() + "\n");
        if (this.hasExtensions()) {
            if (bl) {
                if (this.d != null) {
                    stringBuffer.append("Extensions: ReasonCode: " + this.d + "\n");
                } else {
                    stringBuffer.append(this.c);
                }
            } else {
                int n2 = this.c != null ? this.c.countExtensions() : (this.d != null ? 1 : 0);
                stringBuffer.append("Extensions: " + n2 + "\n");
            }
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

