/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.IA5String;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs10.CertRequest;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class NetscapeCertRequest
implements CertRequest,
Serializable {
    private static final long serialVersionUID = 4398154537985923477L;
    private ASN1 a;
    private PublicKey b;
    private AlgorithmID c;
    private byte[] d;
    private IA5String e;
    private boolean f;
    private byte[] g;

    public NetscapeCertRequest(InputStream inputStream) throws IOException, CodingException {
        this.a = new ASN1(inputStream);
        this.d();
    }

    public NetscapeCertRequest(byte[] byArray) throws CodingException {
        this.a = new ASN1(byArray);
        this.d();
    }

    public NetscapeCertRequest(PublicKey publicKey, String string) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey must not be null!");
        }
        if (string == null) {
            throw new NullPointerException("challenge must not be null!");
        }
        this.b = publicKey;
        this.e = new IA5String(string);
        this.a();
    }

    private void a() {
        this.f = true;
        this.g = null;
        this.a = null;
    }

    private void b() {
        if (this.f) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    private void c() {
        this.f = false;
    }

    private void d() throws CodingException {
        int n2 = this.a.countComponents();
        if (n2 != 3) {
            throw new CodingException("Invalid number of components (" + n2 + ") of SignedPublicKeyAndChallenge! Expected 3.");
        }
        try {
            ASN1Object aSN1Object = this.a.getComponentAt(0);
            n2 = aSN1Object.countComponents();
            if (n2 < 1 || n2 > 2) {
                throw new CodingException("Invalid number of components (" + n2 + ") of PublicKeyAndChallenge! Expected 2.");
            }
            this.c = new AlgorithmID(this.a.getComponentAt(1));
            ASN1Object aSN1Object2 = this.a.getComponentAt(2);
            this.d = (byte[])aSN1Object2.getValue();
            try {
                this.b = PublicKeyInfo.getPublicKey(aSN1Object.getComponentAt(0));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CodingException("Unable to create PublicKey: " + invalidKeyException.toString());
            }
            if (aSN1Object.countComponents() > 1) {
                ASN1Object aSN1Object3 = aSN1Object.getComponentAt(1);
                if (!aSN1Object3.isA(ASN.IA5String)) {
                    throw new CodingException("Invalid ASN.1 type for challenge. Must be IA5String!");
                }
                this.e = (IA5String)aSN1Object3;
            }
            this.a.clearASN1Object();
            this.c();
        }
        catch (RuntimeException runtimeException) {
            throw new CodingException("Certificate request format error: " + runtimeException.toString());
        }
    }

    private ASN1Object e() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(DerCoder.decode(this.b.getEncoded()));
        if (this.e != null) {
            sEQUENCE.addComponent(this.e);
        }
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        BIT_STRING bIT_STRING = new BIT_STRING(this.d);
        SEQUENCE sEQUENCE = null;
        sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(aSN1Object);
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(bIT_STRING);
        this.a = new ASN1(sEQUENCE);
    }

    public byte[] getPublicKeyAndChallenge() throws CodingException {
        if (this.a != null && this.a.toByteArray() != null) {
            return this.a.getFirstObject();
        }
        return DerCoder.encode(this.e());
    }

    public String getChallenge() {
        return this.e == null ? null : (String)this.e.getValue();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.a(algorithmID, privateKey, null, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.a(algorithmID, privateKey, string, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, Provider provider) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.a(algorithmID, privateKey, null, provider);
    }

    private void a(AlgorithmID algorithmID, PrivateKey privateKey, String string, Provider provider) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        if (privateKey == null) {
            throw new InvalidKeyException("Cannot sign this request. No private key specified!");
        }
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Cannot sign this request. No algorithm specified!");
        }
        this.c = algorithmID;
        Signature signature = provider != null ? this.c.getSignatureInstance(provider) : this.c.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.c) && !this.c.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.c.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.a();
            object = this.e();
            signature.update(DerCoder.encode((ASN1Object)object));
            this.d = signature.sign();
            this.a((ASN1Object)object);
            this.c();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws SignatureException {
        if (algorithmID == null) {
            throw new SignatureException("Cannot sign this request. No signature algorithm specified!");
        }
        if (byArray == null) {
            throw new SignatureException("Cannot sign this request. No signature value specified!");
        }
        this.c = algorithmID;
        this.d = byArray;
        try {
            this.a();
            ASN1Object aSN1Object = this.e();
            this.a(aSN1Object);
            this.c();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    public boolean verify() throws SignatureException {
        return this.a(null, null);
    }

    public boolean verify(String string) throws SignatureException {
        return this.a(string, null);
    }

    public boolean verify(Provider provider) throws SignatureException {
        return this.a(null, provider);
    }

    private boolean a(String string, Provider provider) throws SignatureException {
        this.b();
        try {
            Signature signature = provider != null ? this.c.getSignatureInstance(provider) : this.c.getSignatureInstance(string);
            byte[] byArray = this.a.getFirstObject();
            signature.initVerify(this.b);
            signature.update(byArray);
            return signature.verify(this.d);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.a = new ASN1(objectInputStream);
            this.d();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore CertificateRequest: " + codingException.toString());
        }
    }

    public byte[] toByteArray() {
        this.b();
        return this.a.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.a.writeTo(outputStream);
    }

    public AlgorithmID getSignatureAlgorithmID() {
        return this.c;
    }

    public PublicKey getPublicKey() throws InvalidKeyException {
        return this.b;
    }

    public byte[] getFingerprint() {
        this.b();
        return this.a.fingerprint();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.b();
        MessageDigest messageDigest = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                messageDigest = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(string);
        }
        messageDigest.update(this.a.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprintSHA() {
        if (this.g == null) {
            try {
                this.g = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.g;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append(this.b.toString());
        }
        if (this.e != null) {
            stringBuffer.append("\nchallenge: " + this.e.getValue());
        }
        if (this.c != null) {
            stringBuffer.append("\nSignature algorithm: " + this.c + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        return stringBuffer.toString();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

