/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.pkcs.pkcs8.RawPrivateKey;
import iaik.security.provider.IAIK;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.Base64Exception;
import iaik.utils.Base64InputStream;
import iaik.utils.Base64OutputStream;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import iaik.utils.PemOutputStream;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.UTF8CodingException;
import iaik.x509.PublicKeyInfo;
import iaik.x509.RawPublicKey;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.ACRL;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.SecretKeySpec;

public class Util {
    public static final int DEFAULT_JVM_DATA_MODEL = 32;
    private static boolean d = true;
    private static final String[] e = new String[]{"ISO8859_1", "iso-8859-1", "ISO-8859-1", "iso_8859-1", "iso8859-1", "iso_8859_1", "iso8859_1", "Cp1252", "ASCII", "Default"};
    private static final byte[] f = new byte[]{97, 65, 122, 90, 48, 57, 43, 47, 61};
    private static String g;
    private static boolean h;
    static Class a;
    static Class b;
    static Class c;

    public static void setDefaultRFC2253StringEscaping(boolean bl) {
        d = bl;
    }

    public static boolean getDefaultRFC2253StringEscaping() {
        return d;
    }

    private Util() {
    }

    public static boolean loadClass(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (bl) {
                clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String string) throws IOException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            Util.a(inputStream, byArray, 0, byArray.length);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    private static void a(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3;
        int n5 = n3;
        while (n5 > 0) {
            int n6 = inputStream.read(byArray, n2, n5);
            if (n6 == -1) {
                throw new EOFException("Connection closed by remote host.");
            }
            n5 -= n6;
            n2 += n6;
            if (n4-- != 0) continue;
            throw new IOException("Could not read all data!");
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[2048];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Argument \"source\" must not be null.");
        }
        if (byArray == null) {
            byArray = new byte[4096];
        }
        if (outputStream != null) {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
        } else {
            while (inputStream.read(byArray) >= 0) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String toString(byte by) {
        char[] cArray = new char[2];
        int n2 = (by & 0xF0) >> 4;
        int n3 = by & 0xF;
        cArray[0] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        cArray[1] = (char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3);
        String string = new String(cArray);
        return string;
    }

    private static void a(byte by, char[] cArray, int n2) {
        int n3 = (by & 0xF0) >> 4;
        int n4 = by & 0xF;
        cArray[n2++] = (char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3);
        cArray[n2] = (char)(n4 > 9 ? 65 + n4 - 10 : 48 + n4);
    }

    public static String toString(byte[] byArray, int n2, int n3) {
        return Util.toString(byArray, n2, n3, ":");
    }

    public static String toString(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null && n2 == -1 && n3 == 1) {
            Util.b();
            return null;
        }
        if (byArray.length < n2 + n3) {
            n3 = byArray.length - n2;
        }
        if (n3 == 0) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        char[] cArray = string.toCharArray();
        int n4 = string.length();
        if (n4 > 0) {
            n4 = n4 * n3 - n4;
        }
        char[] cArray2 = new char[(n3 << 1) + n4];
        int n5 = 0;
        boolean bl = true;
        int n6 = n2 + n3;
        for (int i2 = n2; i2 < n6; ++i2) {
            if (bl) {
                bl = false;
            } else {
                for (int i3 = 0; i3 < cArray.length; ++i3) {
                    cArray2[n5++] = cArray[i3];
                }
            }
            Util.a(byArray[i2], cArray2, n5);
            n5 += 2;
        }
        String string2 = new String(cArray2);
        return string2;
    }

    public static String toString(byte[] byArray) {
        return Util.toString(byArray, 0, byArray.length);
    }

    public static String toString(byte[] byArray, String string) {
        return Util.toString(byArray, 0, byArray.length, string);
    }

    public static String toString(int n2) {
        return Util.toString(n2, ":");
    }

    public static String toString(int n2, String string) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return Util.toString(byArray, string);
    }

    public static String toString(int[] nArray, int n2, int n3, String string) {
        if (nArray == null && n2 == -1 && n3 == 1) {
            Util.b();
            return null;
        }
        if (nArray.length < n2 + n3) {
            n3 = nArray.length - n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n3 << 1);
        boolean bl = true;
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.toString(nArray[i2], string));
        }
        return stringBuffer.toString();
    }

    public static String toString(int[] nArray, int n2, int n3) {
        return Util.toString(nArray, n2, n3, ":");
    }

    public static String toString(int[] nArray) {
        return Util.toString(nArray, 0, nArray.length, ":");
    }

    public static String toString(int[] nArray, String string) {
        return Util.toString(nArray, 0, nArray.length, string);
    }

    public static String toString(long l2) {
        return Util.toString(l2, ":");
    }

    public static String toString(long l2, String string) {
        return Util.toString((int)(l2 >> 32), string) + string + Util.toString((int)l2, string);
    }

    public static String toString(long[] lArray, int n2, int n3, String string) {
        if (lArray == null && n2 == -1 && n3 == 1) {
            Util.b();
            return null;
        }
        if (lArray.length < n2 + n3) {
            n3 = lArray.length - n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n3 << 1);
        boolean bl = true;
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.toString(lArray[i2], string));
        }
        return stringBuffer.toString();
    }

    public static String toString(long[] lArray, int n2, int n3) {
        return Util.toString(lArray, n2, n3, ":");
    }

    public static String toString(long[] lArray) {
        return Util.toString(lArray, 0, lArray.length, ":");
    }

    public static String toString(long[] lArray, String string) {
        return Util.toString(lArray, 0, lArray.length, string);
    }

    public static byte[] Base64Encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        try {
            base64OutputStream.write(byArray);
            base64OutputStream.flush();
        }
        catch (IOException iOException) {
            throw new InternalErrorException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] Base64Decode(byte[] byArray) throws Base64Exception {
        Base64InputStream base64InputStream = new Base64InputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        try {
            int n2;
            while ((n2 = base64InputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new Base64Exception(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toBase64String(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Data input must not be null!");
        }
        return Util.toASCIIString(Util.Base64Encode(byArray));
    }

    public static byte[] fromBase64String(String string) throws Base64Exception {
        if (string == null) {
            throw new NullPointerException("Base64 encoded data must not be null!");
        }
        return Util.Base64Decode(Util.toASCIIBytes(string));
    }

    public static byte[] resizeArray(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, byArray.length));
        return byArray2;
    }

    public static Object[] resizeArray(Object[] objectArray, int n2) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(n2, objectArray.length));
        return objectArray2;
    }

    public static void reverseArray(Object[] objectArray, int n2, int n3) {
        if (objectArray != null && objectArray.length > 0) {
            int n4 = n2 + n3 - 1;
            int n5 = n2 + (n3 >>> 1);
            for (int i2 = n2; i2 < n5; ++i2) {
                Object object = objectArray[i2];
                objectArray[i2] = objectArray[n4];
                objectArray[n4--] = object;
            }
        }
    }

    public static void fillArray(byte[] byArray, InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = byArray.length; i2 > 0; i2 -= n3) {
            n3 = inputStream.read(byArray, n2, i2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 += n3;
        }
    }

    public static Vector getVector(Object[] objectArray) {
        return new IaikVector(objectArray);
    }

    public static Object[] toArray(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object[] toArray(Vector vector, Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, vector.size());
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void waitKey() {
        try {
            System.out.println("Hit the <RETURN> key.");
            do {
                System.in.read();
            } while (System.in.available() > 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int toByte(char c2, int n2) {
        int n3 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 + 10 : (c2 >= 'a' && c2 <= 'z' ? c2 - 97 + 10 : -1));
        if (n3 < 0 || n3 >= n2) {
            return -1;
        }
        return n3;
    }

    public static byte[] toByteArray(String string) {
        int n2 = string.length();
        int n3 = -1;
        int n4 = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n4 == -1) {
                n4 = Util.toByte(string.charAt(i2), 16);
            } else {
                n3 = Util.toByte(string.charAt(i2), 16);
            }
            if (n4 == -1 || n3 == -1) continue;
            byteArrayOutputStream.write(n4 << 4 | n3);
            n3 = -1;
            n4 = -1;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(int n2) {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    public static byte[] toByteArray(long l2) {
        return new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
    }

    public static byte[] decodeByteArray(String string) throws RuntimeException {
        try {
            return Util.Base64Decode(Util.toASCIIBytes(string));
        }
        catch (Base64Exception base64Exception) {
            throw new RuntimeException("Fatal decoding error: " + base64Exception);
        }
    }

    public static String encodeByteArray(byte[] byArray) {
        byte[] byArray2 = Util.Base64Encode(byArray);
        return Util.toSourceCodeString(byArray2);
    }

    public static int[] decodeIntArray(String string) throws RuntimeException {
        try {
            byte[] byArray = Util.toASCIIBytes(string);
            byte[] byArray2 = Util.Base64Decode(byArray);
            int n2 = byArray2.length >>> 2;
            int[] nArray = new int[n2];
            CryptoUtils.squashBytesToInts(byArray2, 0, nArray, 0, n2);
            return nArray;
        }
        catch (Base64Exception base64Exception) {
            throw new RuntimeException("Fatal decoding error: " + base64Exception);
        }
    }

    public static String encodeIntArray(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2 << 2];
        CryptoUtils.spreadIntsToBytes(nArray, 0, byArray, 0, n2);
        byte[] byArray2 = Util.Base64Encode(byArray);
        return Util.toSourceCodeString(byArray2);
    }

    public static String fromBooleanArray(boolean[] blArray) {
        char[] cArray = new char[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            cArray[i2] = blArray[i2] ? 49 : 48;
        }
        return new String(cArray);
    }

    public static boolean[] toBooleanArray(String string) {
        boolean[] blArray = new boolean[string.length()];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            blArray[i2] = string.charAt(i2) == '1';
        }
        return blArray;
    }

    public static String toSourceCodeString(byte[] byArray) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string2 != null) {
                    printWriter.println("\"" + string2 + "\" +");
                }
                string2 = string;
            }
            printWriter.println("\"" + string2 + "\";");
            printWriter.flush();
            return Util.toASCIIString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String toPemString(Certificate certificate) {
        String string = null;
        byte[] byArray = Util.toPemArray(certificate);
        if (byArray != null) {
            string = Util.toASCIIString(byArray);
        }
        return string;
    }

    public static String toPemString(AttributeCertificate attributeCertificate) {
        String string = null;
        byte[] byArray = Util.toPemArray(attributeCertificate);
        if (byArray != null) {
            string = Util.toASCIIString(byArray);
        }
        return string;
    }

    public static String toPemString(X509CRL x509CRL) {
        String string = null;
        byte[] byArray = Util.toPemArray(x509CRL);
        if (byArray != null) {
            string = Util.toASCIIString(byArray);
        }
        return string;
    }

    public static String toPemString(PrivateKey privateKey) {
        String string = null;
        byte[] byArray = Util.toPemArray(privateKey);
        if (byArray != null) {
            string = Util.toASCIIString(byArray);
        }
        return string;
    }

    public static String toPemString(CertificateRequest certificateRequest) {
        String string = null;
        byte[] byArray = Util.toPemArray(certificateRequest);
        if (byArray != null) {
            string = Util.toASCIIString(byArray);
        }
        return string;
    }

    public static String toPemString(byte[] byArray, String string) {
        String string2 = null;
        byte[] byArray2 = Util.toPemArray(byArray, string);
        if (byArray2 != null) {
            string2 = Util.toASCIIString(byArray2);
        }
        return string2;
    }

    public static byte[] toPemArray(Certificate certificate) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = Base64OutputStream.getLineBreak();
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN CERTIFICATE-----"));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.Base64Encode(certificate.getEncoded()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.toASCIIBytes("-----END CERTIFICATE-----"));
            byteArrayOutputStream.write(byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(Certificate[] certificateArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                byte[] byArray = Util.toPemArray(certificateArray[i2]);
                if (byArray == null) {
                    return null;
                }
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(AttributeCertificate attributeCertificate) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = Base64OutputStream.getLineBreak();
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN ATTRIBUTE CERTIFICATE-----"));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.Base64Encode(attributeCertificate.getEncoded()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.toASCIIBytes("-----END ATTRIBUTE CERTIFICATE-----"));
            byteArrayOutputStream.write(byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(X509CRL x509CRL) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = Base64OutputStream.getLineBreak();
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN X509 CRL-----"));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.Base64Encode(x509CRL.getEncoded()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.toASCIIBytes("-----END X509 CRL-----"));
            byteArrayOutputStream.write(byArray);
        }
        catch (CRLException cRLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(PrivateKey privateKey) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = Base64OutputStream.getLineBreak();
        try {
            String string;
            String string2;
            if (privateKey instanceof EncryptedPrivateKeyInfo) {
                string2 = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
                string = "-----END ENCRYPTED PRIVATE KEY-----";
            } else {
                string2 = "-----BEGIN PRIVATE KEY-----";
                string = "-----END PRIVATE KEY-----";
            }
            byteArrayOutputStream.write(Util.toASCIIBytes(string2));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.Base64Encode(privateKey.getEncoded()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.toASCIIBytes(string));
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(CertificateRequest certificateRequest) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = Base64OutputStream.getLineBreak();
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN NEW CERTIFICATE REQUEST-----"));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.Base64Encode(certificateRequest.toByteArray()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(Util.toASCIIBytes("-----END NEW CERTIFICATE REQUEST-----"));
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toPemArray(byte[] byArray, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            PemOutputStream pemOutputStream = new PemOutputStream(byteArrayOutputStream, "-----BEGIN " + string + "-----", "-----END " + string + "-----");
            pemOutputStream.write(byArray);
            pemOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static long[] bubbleSort(long[] lArray) {
        boolean bl;
        do {
            bl = false;
            int n2 = 1;
            int n3 = 0;
            while (n2 < lArray.length) {
                if (lArray[n3] > lArray[n2]) {
                    bl = true;
                    int n4 = n2;
                    lArray[n4] = lArray[n4] ^ lArray[n3];
                    int n5 = n3;
                    lArray[n5] = lArray[n5] ^ lArray[n2];
                    int n6 = n2;
                    lArray[n6] = lArray[n6] ^ lArray[n3];
                }
                ++n2;
                ++n3;
            }
        } while (bl);
        return lArray;
    }

    public static int[] bubbleSort(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            int n2 = 1;
            int n3 = 0;
            while (n2 < nArray.length) {
                if (nArray[n3] > nArray[n2]) {
                    bl = true;
                    int n4 = n2;
                    nArray[n4] = nArray[n4] ^ nArray[n3];
                    int n5 = n3;
                    nArray[n5] = nArray[n5] ^ nArray[n2];
                    int n6 = n2;
                    nArray[n6] = nArray[n6] ^ nArray[n3];
                }
                ++n2;
                ++n3;
            }
        } while (bl);
        return nArray;
    }

    public static X509Certificate[] convertCertificateChain(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            x509CertificateArray[i2] = certificateArray[i2] instanceof X509Certificate ? (X509Certificate)certificateArray[i2] : new X509Certificate(certificateArray[i2].getEncoded());
        }
        return x509CertificateArray;
    }

    public static X509Certificate convertCertificate(Certificate certificate) throws CertificateException {
        X509Certificate x509Certificate = null;
        if (certificate != null) {
            x509Certificate = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate.getEncoded());
        }
        return x509Certificate;
    }

    public static AttributeCertificate[] convertToAttributeCertificateChain(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        AttributeCertificate[] attributeCertificateArray = new AttributeCertificate[certificateArray.length];
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            attributeCertificateArray[i2] = certificateArray[i2] instanceof AttributeCertificate ? (AttributeCertificate)certificateArray[i2] : new AttributeCertificate(certificateArray[i2].getEncoded());
        }
        return attributeCertificateArray;
    }

    public static AttributeCertificate convertToAttributeCertificate(Certificate certificate) throws CertificateException {
        AttributeCertificate attributeCertificate = null;
        if (certificate != null) {
            attributeCertificate = certificate instanceof AttributeCertificate ? (AttributeCertificate)certificate : new AttributeCertificate(certificate.getEncoded());
        }
        return attributeCertificate;
    }

    public static X509Certificate[] arrangeCertificateChain(X509Certificate[] x509CertificateArray, boolean bl) {
        if (x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0] != null) {
            int n2;
            int n3;
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
            vector.addElement(x509CertificateArray[0]);
            for (n3 = 1; n3 < x509CertificateArray.length; ++n3) {
                vector2.addElement(x509CertificateArray[n3]);
            }
            n3 = 0;
            boolean bl2 = false;
            while (!(vector2.size() <= 0 || bl2 && n3 != 0)) {
                Name name;
                Name name2;
                X509Certificate x509Certificate;
                X509Certificate x509Certificate2;
                int n4;
                n2 = 0;
                for (n4 = 0; n4 < vector2.size() && n2 == 0 && n3 == 0; ++n4) {
                    x509Certificate2 = (X509Certificate)vector.elementAt(vector.size() - 1);
                    x509Certificate = (X509Certificate)vector2.elementAt(n4);
                    name2 = (Name)x509Certificate2.getSubjectDN();
                    name = (Name)x509Certificate.getIssuerDN();
                    if (name2 == null || !name2.elements().hasMoreElements()) break;
                    if (!name.equals(name2)) continue;
                    try {
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        n2 = 1;
                        vector2.removeElementAt(n4);
                        vector.addElement(x509Certificate);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 == 0) {
                    n3 = 1;
                }
                n2 = 0;
                for (n4 = 0; n4 < vector2.size() && n2 == 0 && !bl2; ++n4) {
                    x509Certificate2 = (X509Certificate)vector2.elementAt(n4);
                    x509Certificate = (X509Certificate)vector.elementAt(0);
                    name2 = (Name)x509Certificate2.getSubjectDN();
                    name = (Name)x509Certificate.getIssuerDN();
                    if (!name.equals(name2)) continue;
                    try {
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        n2 = 1;
                        vector2.removeElementAt(n4);
                        vector.insertElementAt(x509Certificate2, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 != 0) continue;
                bl2 = true;
            }
            if (vector2.size() == 0) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[vector.size()];
                for (n2 = 0; n2 < x509CertificateArray2.length; ++n2) {
                    x509CertificateArray2[n2] = bl ? (X509Certificate)vector.elementAt(n2) : (X509Certificate)vector.elementAt(vector.size() - 1 - n2);
                }
                return x509CertificateArray2;
            }
            return null;
        }
        return null;
    }

    public static X509Certificate[] createCertificateChain(X509Certificate x509Certificate, Certificate[] certificateArray) throws CertificateException {
        Object[] objectArray;
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            return new X509Certificate[]{x509Certificate};
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>(4);
        try {
            String string;
            Name name;
            X509Certificate x509Certificate2;
            objectArray = new HashMap(certificateArray.length + 2);
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                if (!(certificateArray[i2] instanceof X509Certificate)) continue;
                x509Certificate2 = Util.convertCertificate(certificateArray[i2]);
                name = (Name)x509Certificate2.getSubjectDN();
                string = name.getRFC2253String();
                objectArray.put(string, x509Certificate2);
            }
            vector.addElement(x509Certificate);
            X509Certificate x509Certificate3 = x509Certificate;
            name = (Name)x509Certificate3.getIssuerDN();
            string = name.getRFC2253String();
            x509Certificate2 = (X509Certificate)objectArray.get(string);
            int n2 = 20;
            while (x509Certificate2 != null && !x509Certificate3.equals(x509Certificate2) && n2-- > 0 && Util.a(x509Certificate3, x509Certificate2)) {
                vector.addElement(x509Certificate2);
                x509Certificate3 = x509Certificate2;
                name = (Name)x509Certificate3.getIssuerDN();
                string = name.getRFC2253String();
                x509Certificate2 = (X509Certificate)objectArray.get(string);
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new CertificateException("Error parsing dn: " + rFC2253NameParserException.toString());
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CertificateException("Error parsing cert extension: " + x509ExtensionInitException.toString());
        }
        objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean a(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws X509ExtensionInitException, RFC2253NameParserException, CertificateException {
        boolean bl = true;
        AuthorityKeyIdentifier authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate.getExtension(AuthorityKeyIdentifier.oid);
        SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate2.getExtension(SubjectKeyIdentifier.oid);
        if (authorityKeyIdentifier != null) {
            byte[] byArray = authorityKeyIdentifier.getKeyIdentifier();
            if (byArray != null) {
                byte[] byArray2 = subjectKeyIdentifier.get();
                if (byArray2 != null) {
                    bl = CryptoUtils.equalsBlock(byArray, byArray2);
                }
            } else {
                try {
                    GeneralName[] generalNameArray;
                    BigInteger bigInteger;
                    GeneralNames generalNames = authorityKeyIdentifier.getAuthorityCertIssuer();
                    if (generalNames != null && (bigInteger = authorityKeyIdentifier.getAuthorityCertSerialNumber()) != null && (generalNameArray = generalNames.getNames(4)) != null && generalNameArray.length > 0) {
                        GeneralName generalName = generalNameArray[0];
                        Name name = (Name)generalName.getName();
                        Name name2 = (Name)x509Certificate2.getIssuerDN();
                        if (!name.getRFC2253String().equals(name2.getRFC2253String())) {
                            bl = false;
                        } else if (!bigInteger.equals(x509Certificate2.getSerialNumber())) {
                            bl = false;
                        }
                    }
                }
                catch (Exception exception) {
                    throw new CertificateException("Error checking authCertIssuer: " + exception.toString());
                }
            }
        }
        return bl;
    }

    public static X509Certificate[] readCertificateChain(InputStream inputStream) throws IOException {
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new X509Certificate(inputStream));
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to decode certificate: " + certificateException.toString());
        }
        Object[] objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static AttributeCertificate[] readAttributeCertificateChain(InputStream inputStream) throws IOException {
        Vector<AttributeCertificate> vector = new Vector<AttributeCertificate>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new AttributeCertificate(inputStream));
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to decode certificate: " + certificateException.toString());
        }
        Object[] objectArray = new AttributeCertificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static iaik.x509.X509CRL[] readCRLChain(InputStream inputStream) throws IOException {
        Vector<iaik.x509.X509CRL> vector = new Vector<iaik.x509.X509CRL>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new iaik.x509.X509CRL(inputStream));
            }
        }
        catch (CRLException cRLException) {
            throw new IOException("Unable to decode crl: " + cRLException.toString());
        }
        Object[] objectArray = new iaik.x509.X509CRL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static ACRL[] readACRLChain(InputStream inputStream) throws IOException {
        Vector<ACRL> vector = new Vector<ACRL>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new ACRL(inputStream));
            }
        }
        catch (CRLException cRLException) {
            throw new IOException("Unable to decode ACRL: " + cRLException.toString());
        }
        Object[] objectArray = new ACRL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static X509Certificate[] decodePkiPath(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new NullPointerException("pkiPath must not be null!");
        }
        try {
            ASN1 aSN1 = new ASN1(byArray);
            return (X509Certificate[])ASN.parseSequenceOf(aSN1.toASN1Object(), a == null ? (a = Util.class$("iaik.x509.X509Certificate")) : a);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
    }

    public static X509Certificate[] readPkiPath(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("certificates must not be null!");
        }
        try {
            ASN1 aSN1 = new ASN1(inputStream);
            return (X509Certificate[])ASN.parseSequenceOf(aSN1.toASN1Object(), a == null ? (a = Util.class$("iaik.x509.X509Certificate")) : a);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
    }

    public static byte[] encodeAsPkiPath(X509Certificate[] x509CertificateArray, boolean bl) throws CertificateException {
        ASN1Type[] aSN1TypeArray;
        if (x509CertificateArray == null) {
            throw new NullPointerException("certificates must not be null!");
        }
        if (bl) {
            aSN1TypeArray = Util.arrangeCertificateChain(x509CertificateArray, true);
            if (aSN1TypeArray == null) {
                throw new CertificateException("Could not sort certificates!");
            }
        } else {
            aSN1TypeArray = x509CertificateArray;
        }
        try {
            return DerCoder.encode(ASN.createSequenceOf(aSN1TypeArray));
        }
        catch (CodingException codingException) {
            throw new CertificateException("Error creating pki path: " + codingException.toString());
        }
    }

    public void writePkiPath(X509Certificate[] x509CertificateArray, boolean bl, OutputStream outputStream) throws CertificateException, IOException {
        outputStream.write(Util.encodeAsPkiPath(x509CertificateArray, bl));
    }

    public static int getJVMDataMode() {
        int n2;
        try {
            String string = System.getProperty("sun.arch.data.model");
            if (string == null) {
                string = System.getProperty("oracle.arch.data.model");
            }
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n2 = 32;
        }
        return n2;
    }

    public static byte[] getUTF8EncodingFromString(String string) throws UTF8CodingException {
        if (string == null) {
            throw new UTF8CodingException("Cannot UTF-8 encode a null string!");
        }
        return Util.getUTF8EncodingFromCharArray(string.toCharArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getUTF8EncodingFromCharArray(char[] cArray) throws UTF8CodingException {
        if (cArray == null) {
            throw new UTF8CodingException("Cannot UTF-8 encode a null array!");
        }
        int n2 = cArray.length;
        byte[] byArray = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = cArray[i2];
            if (n4 >= 55296) {
                if (n4 <= 56319) {
                    if (++i2 >= n2) {
                        throw new UTF8CodingException("Unexpected end of array found.");
                    }
                    char c2 = cArray[i2];
                    if (c2 < '\udc00') throw new UTF8CodingException("Invalid character in position " + i2 + ": " + Integer.toHexString(c2));
                    if (c2 > '\udfff') throw new UTF8CodingException("Invalid character in position " + i2 + ": " + Integer.toHexString(c2));
                    n4 = (n4 - 55296 << 10) + (c2 - 56320) + 65536;
                } else if (n4 >= 56320 && n4 <= 57343) {
                    throw new UTF8CodingException("Invalid character in position " + i2 + ": " + Integer.toHexString(n4));
                }
            }
            n3 = Util.a(n4, byArray, n3);
        }
        if (n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private static int a(int n2, byte[] byArray, int n3) throws UTF8CodingException {
        if (n2 >= 0 && n2 <= 127) {
            byArray[n3++] = (byte)n2;
        } else if (n2 >= 128 && n2 <= 2047) {
            n3 = Util.a(n2, 2, byArray, n3);
        } else if (n2 >= 2048 && n2 <= 65535) {
            n3 = Util.a(n2, 3, byArray, n3);
        } else if (n2 >= 65536 && n2 <= 0x10FFFF) {
            n3 = Util.a(n2, 4, byArray, n3);
        } else {
            throw new UTF8CodingException("Cannot perform UTF8 encoding! Character " + (char)n2 + " out of range!");
        }
        return n3;
    }

    private static int a(int n2, int n3, byte[] byArray, int n4) throws UTF8CodingException {
        if (n3 < 1 || n3 > 6) {
            throw new UTF8CodingException("Invalid number " + n3 + " of octets for UTF8 encoding. A character " + "only can be encoded as a sequence of 1 to 6 octets!");
        }
        if (n3 == 1) {
            byArray[n4++] = (byte)n2;
        } else {
            byArray[n4++] = (byte)(0xFF & 255 << 8 - n3 | n2 >> (n3 - 1) * 6 & 255 >> n3 + 1);
            for (int i2 = n3 - 2; i2 >= 0; --i2) {
                byArray[n4++] = (byte)(0x80 | n2 >> 6 * i2 & 0x3F);
            }
        }
        return n4;
    }

    public static char[] getCharsFromUTF8Encoding(byte[] byArray) throws UTF8CodingException {
        return Util.getCharsFromUTF8Encoding(byArray, false);
    }

    public static char[] getCharsFromUTF8Encoding(byte[] byArray, boolean bl) throws UTF8CodingException {
        return Util.a(byArray, bl);
    }

    public static String getStringFromUTF8Encoding(byte[] byArray) throws UTF8CodingException {
        char[] cArray = Util.a(byArray, false);
        return new String(cArray);
    }

    public static String getStringFromUTF8Encoding(byte[] byArray, boolean bl) throws UTF8CodingException {
        char[] cArray = Util.a(byArray, bl);
        return new String(cArray);
    }

    private static char[] a(byte[] byArray, boolean bl) throws UTF8CodingException {
        if (byArray == null) {
            throw new UTF8CodingException("Cannot decode string from null array!");
        }
        try {
            char[] cArray;
            int n2 = byArray.length;
            char[] cArray2 = new char[n2];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                int n5;
                int n6 = byArray[i2] & 0xFF;
                if (n6 >>> 7 == 0) {
                    cArray2[n3++] = (char)n6;
                    continue;
                }
                if (n6 >>> 5 == 6) {
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing second byte of 110xxxxx 10xxxxxx sequence!");
                    }
                    n5 = byArray[i2] & 0xFF;
                    try {
                        n4 = Util.getCharFromUTF8Array(new int[]{n6, n5});
                    }
                    catch (UTF8CodingException uTF8CodingException) {
                        if (bl) continue;
                        throw uTF8CodingException;
                    }
                    if (n4 < 128 || n4 > 2047) {
                        if (bl) continue;
                        throw new UTF8CodingException("Error in UTF8 encoding! 110xxxxx 10xxxxxx sequence out of range!");
                    }
                    cArray2[n3++] = (char)n4;
                    continue;
                }
                if (n6 >>> 4 == 14) {
                    int n7;
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing second byte of 1110xxxxx 10xxxxxx 10xxxxxx sequence!");
                    }
                    n5 = byArray[i2] & 0xFF;
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing third byte of 1110xxxxx 10xxxxxx 10xxxxxx sequence!");
                    }
                    n4 = byArray[i2] & 0xFF;
                    try {
                        n7 = Util.getCharFromUTF8Array(new int[]{n6, n5, n4});
                    }
                    catch (UTF8CodingException uTF8CodingException) {
                        if (bl) continue;
                        throw uTF8CodingException;
                    }
                    if (n7 < 2048 || n7 > 65535) {
                        if (bl) continue;
                        throw new UTF8CodingException("Error in UTF8 encoding! 1110xxxx 10xxxxxx 10xxxxxx sequence out of range!");
                    }
                    cArray2[n3++] = (char)n7;
                    continue;
                }
                if (n6 >>> 3 == 30) {
                    int n8;
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing second byte of 11110xxxx 10xxxxxx 10xxxxxx 10xxxxxx sequence!");
                    }
                    n5 = byArray[i2] & 0xFF;
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing third byte of 11110xxxx 10xxxxxx 10xxxxxx 10xxxxxx sequence!");
                    }
                    n4 = byArray[i2] & 0xFF;
                    if (++i2 >= n2) {
                        if (bl) break;
                        throw new UTF8CodingException("Error in UTF8 encoding. Missing fourth byte of 11110xxxx 10xxxxxx 10xxxxxx 10xxxxxx sequence!");
                    }
                    int n9 = byArray[i2] & 0xFF;
                    try {
                        n8 = Util.getCharFromUTF8Array(new int[]{n6, n5, n4, n9});
                    }
                    catch (UTF8CodingException uTF8CodingException) {
                        if (bl) continue;
                        throw uTF8CodingException;
                    }
                    if (n8 < 65536 || n8 > 0x10FFFF) {
                        if (bl) continue;
                        throw new UTF8CodingException("Error in UTF8 encoding! 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx sequence out of range!");
                    }
                    int n10 = ((n8 -= 65536) & 0x3FF) + 56320;
                    n8 = (n8 >> 10) + 55296;
                    cArray2[n3++] = (char)n8;
                    cArray2[n3++] = (char)n10;
                    continue;
                }
                if (bl) continue;
                throw new UTF8CodingException("Cannot parse UTF8 encoding! Character " + (char)n6 + " out of range!");
            }
            if (n3 == cArray2.length) {
                cArray = cArray2;
            } else {
                cArray = new char[n3];
                System.arraycopy(cArray2, 0, cArray, 0, n3);
            }
            return cArray;
        }
        catch (UTF8CodingException uTF8CodingException) {
            throw uTF8CodingException;
        }
        catch (Exception exception) {
            throw new UTF8CodingException(exception.getMessage());
        }
    }

    public static int getCharFromUTF8Array(int[] nArray) throws UTF8CodingException {
        if (nArray == null) {
            throw new UTF8CodingException("Cannot decode from a null value!");
        }
        int n2 = nArray.length;
        if (n2 < 1 || n2 > 6) {
            throw new UTF8CodingException("Invalid number " + n2 + " of octets for UTF8 encoding. A character " + "only can be encoded as a sequence of 1 to 6 octets!");
        }
        if (n2 == 1) {
            return nArray[0];
        }
        int n3 = (nArray[0] & 255 >> n2 + 1) << (n2 - 1) * 6;
        for (int i2 = 1; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            if ((n4 & 0xC0) != 128) {
                throw new UTF8CodingException("Error in UTF8 encoding! Invalid  10xxxxxx sequence!");
            }
            n3 |= (n4 & 0x3F) << 6 * (n2 - 1 - i2);
        }
        return n3;
    }

    public static String getRFC2253String(String string) throws UTF8CodingException {
        return Util.getRFC2253String(string.toCharArray());
    }

    public static String getRFC2253String(String string, boolean bl) throws UTF8CodingException {
        return Util.getRFC2253String(string.toCharArray(), bl);
    }

    public static String getRFC2253String(char[] cArray) throws UTF8CodingException {
        return Util.getRFC2253String(cArray, Util.getDefaultRFC2253StringEscaping());
    }

    public static String getRFC2253String(char[] cArray, boolean bl) throws UTF8CodingException {
        try {
            if (cArray == null) {
                throw new UTF8CodingException("Cannot UTF-8 encode a null array!");
            }
            int n2 = cArray.length;
            StringBuffer stringBuffer = new StringBuffer(n2 * 2);
            char[] cArray2 = new char[2];
            cArray2[0] = 92;
            char[] cArray3 = new char[3];
            cArray3[0] = 92;
            byte[] byArray = new byte[4];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = cArray[i2];
                if (c2 >= ' ' && c2 <= '~') {
                    if ((i2 == 0 || i2 == n2 - 1) && (c2 == ' ' || i2 == 0 && c2 == '#') || ",+\"\\<>;".indexOf(c2) != -1) {
                        cArray2[1] = c2;
                        stringBuffer.append(cArray2);
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                if (bl || c2 == '\u0000') {
                    n3 = 0;
                    n3 = Util.a(c2, byArray, n3);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Util.a(byArray[i3], cArray3);
                        stringBuffer.append(cArray3);
                    }
                    continue;
                }
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new UTF8CodingException(exception.getMessage());
        }
    }

    private static void a(byte by, char[] cArray) {
        int n2 = (by & 0xF0) >> 4;
        int n3 = by & 0xF;
        cArray[1] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        cArray[2] = (char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3);
    }

    public static byte[] convertEndian32(byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 + 3;
            byArray2[i2++] = byArray[n3--];
            byArray2[i2++] = byArray[n3--];
            byArray2[i2++] = byArray[n3--];
            byArray2[i2] = byArray[n3];
        }
        return byArray2;
    }

    public static void setEncoding(String string) {
        g = string;
    }

    private static synchronized void a() {
        if (g != null) {
            return;
        }
        for (int i2 = 0; i2 < e.length; ++i2) {
            try {
                String string = e[i2];
                byte[] byArray = "aAzZ09+/=".getBytes(string);
                if (!CryptoUtils.equalsBlock(byArray, f)) continue;
                g = string;
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new RuntimeException("Could not find a ASCII compatible encoding!");
    }

    public static String toASCIIString(byte[] byArray, int n2, int n3) {
        if (g == null) {
            Util.a();
        }
        try {
            return new String(byArray, n2, n3, g);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII encoding not supported?!: " + unsupportedEncodingException.toString());
        }
    }

    public static String toASCIIString(byte[] byArray) {
        return Util.toASCIIString(byArray, 0, byArray.length);
    }

    public static byte[] toASCIIBytes(String string) {
        if (g == null) {
            Util.a();
        }
        try {
            return string.getBytes(g);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII encoding not supported?!: " + unsupportedEncodingException.toString());
        }
    }

    public static BufferedReader getASCIIReader(InputStream inputStream) {
        if (g == null) {
            Util.a();
        }
        try {
            return new BufferedReader(new InputStreamReader(inputStream, g));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public static PrintWriter getASCIIWriter(OutputStream outputStream) {
        return Util.getASCIIWriter(outputStream, false);
    }

    public static PrintWriter getASCIIWriter(OutputStream outputStream, boolean bl) {
        if (g == null) {
            Util.a();
        }
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(outputStream, g), bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public static void compareTables(String string, int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            throw new RuntimeException("Error in " + string + " index " + i2 + ": " + Util.toString(nArray[i2]) + " != " + Util.toString(nArray2[i2]));
        }
    }

    public static void printTable(String string, byte[] byArray) {
        int[] nArray = new int[byArray.length >> 2];
        CryptoUtils.squashBytesToInts(byArray, 0, nArray, 0, nArray.length);
        Util.printTable(string, nArray);
    }

    public static void printTable(String string, int[] nArray) {
        int n2 = 0;
        System.out.println("*** " + string);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            System.out.print(Util.toString(nArray[i2]));
            if (n2++ == 5) {
                n2 = 0;
                System.out.println();
                continue;
            }
            System.out.print("  ");
        }
        System.out.println();
    }

    public static int calculateHashCode(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    private static synchronized void b() {
        if (h) {
            return;
        }
        h = true;
        String[] stringArray = new String[]{"******************************************************************************", "***                                                                        ***", "***                    Welcome to the IAIK JCE Library                     ***", "***                                                                        ***", "*** This version of IAIK JCE is licensed for use within the MOA SP/SS      ***", "*** and MOA ID context only. Any other use of this software is prohibited. ***", "*** For details please see http://jce.iaik.tugraz.at/sales/licences/.      ***", "*** This message does not appear in the registered commercial version.     ***", "***                                                                        ***", "******************************************************************************", ""};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            System.err.println(stringArray[i2]);
        }
    }

    public static Key decodeKey(int n2, String string, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException {
        if (n2 == 3) {
            return new SecretKeySpec(byArray, string);
        }
        if (n2 == 2) {
            KeyFactory keyFactory = null;
            try {
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        keyFactory = IaikSecurity.getKeyFactoryInstance(string, IAIK.getInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (keyFactory == null) {
                    try {
                        keyFactory = KeyFactory.getInstance(string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return new RawPrivateKey(byArray);
                    }
                }
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException.toString());
            }
        }
        if (n2 == 1) {
            KeyFactory keyFactory = null;
            try {
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        keyFactory = IaikSecurity.getKeyFactoryInstance(string, IAIK.getInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (keyFactory == null) {
                    try {
                        keyFactory = KeyFactory.getInstance(string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return new RawPublicKey(byArray);
                    }
                }
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                return keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException.toString());
            }
        }
        throw new InvalidKeyException("Unknown key type " + n2);
    }

    public static RSAPublicKey getRSAPublicKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return (RSAPublicKey)key;
        }
        if (key instanceof PublicKey) {
            PublicKey publicKey = PublicKeyInfo.getPublicKey(key.getEncoded(), (Provider)IAIK.getInstance());
            if (publicKey instanceof RSAPublicKey) {
                return (RSAPublicKey)publicKey;
            }
            throw new InvalidKeyException("Key is not an RSA public key: " + publicKey.getClass().getName());
        }
        throw new InvalidKeyException("Class does not represent an RSA public key: " + key.getClass().getName());
    }

    public static iaik.security.rsa.RSAPrivateKey getRSAPrivateKey(Key key) throws InvalidKeyException {
        if (key instanceof iaik.security.rsa.RSAPrivateKey) {
            return (iaik.security.rsa.RSAPrivateKey)key;
        }
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = PrivateKeyInfo.getPrivateKey(key.getEncoded(), "IAIK");
            if (privateKey instanceof iaik.security.rsa.RSAPrivateKey) {
                return (iaik.security.rsa.RSAPrivateKey)privateKey;
            }
            throw new InvalidKeyException("Key is not an RSA private key: " + privateKey.getClass().getName());
        }
        throw new InvalidKeyException("Class does not represent an RSA private key: " + key.getClass().getName());
    }

    public static int getKeyLength(PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            return ((java.security.interfaces.RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            return ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof DHPublicKey) {
            return ((DHPublicKey)publicKey).getParams().getP().bitLength();
        }
        return -1;
    }

    public static int getKeyLength(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)privateKey).getModulus().bitLength();
        }
        if (privateKey instanceof DSAPrivateKey) {
            return ((DSAPrivateKey)privateKey).getParams().getP().bitLength();
        }
        if (privateKey instanceof DHPrivateKey) {
            return ((DHPrivateKey)privateKey).getParams().getP().bitLength();
        }
        return -1;
    }

    public static int getDigestLength(AlgorithmID algorithmID) {
        int n2 = 0;
        ObjectID objectID = algorithmID.getAlgorithm();
        if (objectID.equals(AlgorithmID.sha1.getAlgorithm()) || objectID.equals(AlgorithmID.sha.getAlgorithm())) {
            n2 = 20;
        } else if (objectID.equals(AlgorithmID.sha256.getAlgorithm())) {
            n2 = 32;
        } else if (objectID.equals(AlgorithmID.sha384.getAlgorithm())) {
            n2 = 48;
        } else if (objectID.equals(AlgorithmID.sha512.getAlgorithm())) {
            n2 = 64;
        } else if (objectID.equals(AlgorithmID.sha224.getAlgorithm())) {
            n2 = 28;
        } else if (objectID.equals(AlgorithmID.sha3_256.getAlgorithm())) {
            n2 = 32;
        } else if (objectID.equals(AlgorithmID.sha3_384.getAlgorithm())) {
            n2 = 48;
        } else if (objectID.equals(AlgorithmID.sha3_512.getAlgorithm())) {
            n2 = 64;
        } else if (objectID.equals(AlgorithmID.sha3_224.getAlgorithm())) {
            n2 = 28;
        } else if (objectID.equals(AlgorithmID.md5.getAlgorithm())) {
            n2 = 16;
        } else if (objectID.equals(AlgorithmID.ripeMd160.getAlgorithm()) || objectID.equals(AlgorithmID.ripeMd160_ISO.getAlgorithm())) {
            n2 = 20;
        } else if (objectID.equals(AlgorithmID.ripeMd128.getAlgorithm()) || objectID.equals(AlgorithmID.ripeMd128_ISO.getAlgorithm())) {
            n2 = 16;
        } else if (objectID.equals(AlgorithmID.ripeMd256.getAlgorithm())) {
            n2 = 32;
        } else if (objectID.equals(AlgorithmID.whirlpool.getAlgorithm())) {
            n2 = 64;
        } else if (objectID.equals(AlgorithmID.gost3411.getAlgorithm())) {
            n2 = 32;
        } else if (objectID.equals(AlgorithmID.md2.getAlgorithm())) {
            n2 = 16;
        } else if (objectID.equals(AlgorithmID.md4.getAlgorithm())) {
            n2 = 16;
        } else {
            try {
                MessageDigest messageDigest = null;
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        messageDigest = algorithmID.getMessageDigestInstance(IAIK.getInstance());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (messageDigest == null) {
                    messageDigest = algorithmID.getMessageDigestInstance();
                }
                n2 = messageDigest.getDigestLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static int getDigestLength(String string) {
        int n2 = 0;
        String string2 = string.toUpperCase(Locale.US);
        if (string2.equals("SHA-1") || string2.equals("SHA1") || string2.equals("SHA")) {
            n2 = 20;
        } else if (string2.equals("SHA-256") || string2.equals("SHA256")) {
            n2 = 32;
        } else if (string2.equals("SHA-384") || string2.equals("SHA384")) {
            n2 = 48;
        } else if (string2.equals("SHA-512") || string2.equals("SHA512")) {
            n2 = 64;
        } else if (string2.equals("SHA-224") || string2.equals("SHA224")) {
            n2 = 28;
        } else if (string2.equals("SHA3-224") || string2.equals("SHA3224")) {
            n2 = 28;
        } else if (string2.equals("SHA3-256") || string2.equals("SHA3256")) {
            n2 = 32;
        } else if (string2.equals("SHA3-384") || string2.equals("SHA3384")) {
            n2 = 48;
        } else if (string2.equals("SHA3-512") || string2.equals("SHA3512")) {
            n2 = 64;
        } else if (string2.equals("SHA-512/224")) {
            n2 = 28;
        } else if (string2.equals("SHA-512/256")) {
            n2 = 32;
        } else if (string2.equals("MD5")) {
            n2 = 16;
        } else if (string2.equals("RIPEMD-160") || string2.equals("RIPEMD160")) {
            n2 = 20;
        } else if (string2.equals("RIPEMD-128") || string2.equals("RIPEMD128")) {
            n2 = 16;
        } else if (string2.equals("RIPEMD-256") || string2.equals("RIPEMD256")) {
            n2 = 32;
        } else if (string2.equals("RIPEMD-320") || string2.equals("RIPEMD320")) {
            n2 = 40;
        } else if (string2.equals("WHIRLPOOL")) {
            n2 = 64;
        } else if (string2.equals("GOST3411")) {
            n2 = 32;
        } else if (string2.equals("MD2")) {
            n2 = 16;
        } else if (string2.equals("MD4")) {
            n2 = 16;
        } else {
            try {
                MessageDigest messageDigest = null;
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        messageDigest = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (messageDigest == null) {
                    messageDigest = MessageDigest.getInstance(string);
                }
                n2 = messageDigest.getDigestLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static void setSignatureParameters(Signature signature, AlgorithmParameterSpec algorithmParameterSpec, String string) {
        boolean bl = false;
        try {
            String string2 = System.getProperty("java.version");
            boolean bl2 = true;
            if (string2 != null) {
                boolean bl3 = bl2 = !string2.startsWith("0") && !string2.startsWith("1.1.");
            }
            if (bl2) {
                try {
                    Class[] classArray = new Class[]{b == null ? (b = Util.class$("java.security.spec.AlgorithmParameterSpec")) : b};
                    Method method = (c == null ? (c = Util.class$("java.security.Signature")) : c).getDeclaredMethod("setParameter", classArray);
                    method.invoke((Object)signature, (Object[])new AlgorithmParameterSpec[]{algorithmParameterSpec});
                    bl = true;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bl) {
            try {
                signature.setParameter(string, algorithmParameterSpec);
            }
            catch (Throwable throwable) {
                signature.setParameter(null, algorithmParameterSpec);
            }
        }
    }

    public static String getRawCipherName(String string) {
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String printIndented(String string, boolean bl) {
        return Util.printIndented(string, bl, " ");
    }

    public static String printIndented(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Util.printIndented(string, bl, string2, stringBuffer);
        return stringBuffer.toString();
    }

    public static void printIndented(String string, boolean bl, StringBuffer stringBuffer) {
        Util.printIndented(string, bl, " ", stringBuffer);
    }

    public static void printIndented(String string, boolean bl, String string2, StringBuffer stringBuffer) {
        String string3 = string2 == null ? "" : string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string4 = stringTokenizer.nextToken();
        if (!bl) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(string3 + string4);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n" + string3 + stringTokenizer.nextToken());
        }
    }

    public static AlgorithmParameters getSignatureParameters(Signature signature) {
        boolean bl;
        AlgorithmParameters algorithmParameters;
        block7: {
            algorithmParameters = null;
            bl = false;
            try {
                String string = System.getProperty("java.version");
                if (string == null || string.compareTo("1.4") < 0) break block7;
                try {
                    Method method = (c == null ? (c = Util.class$("java.security.Signature")) : c).getDeclaredMethod("getParameters", null);
                    algorithmParameters = (AlgorithmParameters)method.invoke((Object)signature, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                bl = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                algorithmParameters = (AlgorithmParameters)signature.getParameter(null);
            }
            catch (Throwable throwable) {
                algorithmParameters = (AlgorithmParameters)signature.getParameter("");
            }
        }
        return algorithmParameters;
    }

    public static RSAPssParameterSpec createRsaPssParameters(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        int n2 = Util.getDigestLength(algorithmID);
        return Util.createRsaPssParameters(algorithmID, n2);
    }

    public static RSAPssParameterSpec createRsaPssParameters(AlgorithmID algorithmID, int n2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (n2 < 0 && (n2 = Util.getDigestLength(algorithmID)) == 0) {
            throw new InvalidAlgorithmParameterException("Cannot determine output length of hash algorithm!");
        }
        algorithmID = (AlgorithmID)algorithmID.clone();
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.mgf1.clone();
        algorithmID2.setParameter(algorithmID.toASN1Object());
        RSAPssParameterSpec rSAPssParameterSpec = new RSAPssParameterSpec(algorithmID, algorithmID2, n2);
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance(IAIK.getInstance());
        rSAPssParameterSpec.setHashEngine(messageDigest);
        MaskGenerationAlgorithm maskGenerationAlgorithm = algorithmID2.getMaskGenerationAlgorithmInstance(IAIK.getInstance());
        MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID);
        MessageDigest messageDigest2 = algorithmID.getMessageDigestInstance(IAIK.getInstance());
        mGF1ParameterSpec.setHashEngine(messageDigest2);
        maskGenerationAlgorithm.setParameters(mGF1ParameterSpec);
        rSAPssParameterSpec.setMGFEngine(maskGenerationAlgorithm);
        return rSAPssParameterSpec;
    }

    public static AlgorithmID createRsaPssAlgorithmID(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        int n2 = Util.getDigestLength(algorithmID);
        if (n2 == 0) {
            throw new InvalidAlgorithmParameterException("Cannot determine output length of hash algorithm!");
        }
        AlgorithmID algorithmID2 = Util.createRsaPssAlgorithmID((AlgorithmID)algorithmID.clone(), n2);
        return algorithmID2;
    }

    public static AlgorithmID createRsaPssAlgorithmID(AlgorithmID algorithmID, int n2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.rsassaPss.clone();
        RSAPssParameterSpec rSAPssParameterSpec = Util.createRsaPssParameters(algorithmID, n2);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("RSASSA-PSS", IAIK.getInstance());
            algorithmParameters.init(rSAPssParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Cannot init PSS params: " + invalidParameterSpecException.getMessage());
        }
        algorithmID2.setAlgorithmParameters(algorithmParameters);
        return algorithmID2;
    }

    public static RSAOaepParameterSpec createRsaOaepParameters(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.pSpecified.clone();
        byte[] byArray = new byte[]{};
        RSAOaepParameterSpec rSAOaepParameterSpec = Util.createRsaOaepParameters((AlgorithmID)algorithmID.clone(), algorithmID2, byArray);
        return rSAOaepParameterSpec;
    }

    public static RSAOaepParameterSpec createRsaOaepParameters(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PKCS1AlgorithmParameterSpec pKCS1AlgorithmParameterSpec;
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.mgf1.clone();
        algorithmID3.setParameter(algorithmID.toASN1Object());
        algorithmID2.setParameter(new OCTET_STRING(byArray));
        MessageDigest messageDigest = null;
        MaskGenerationAlgorithm maskGenerationAlgorithm = null;
        try {
            messageDigest = algorithmID.getMessageDigestInstance(IAIK.getInstance());
            maskGenerationAlgorithm = algorithmID3.getMaskGenerationAlgorithmInstance(IAIK.getInstance());
            pKCS1AlgorithmParameterSpec = new MGF1ParameterSpec(algorithmID);
            ((MGF1ParameterSpec)pKCS1AlgorithmParameterSpec).setHashEngine(messageDigest);
            maskGenerationAlgorithm.setParameters(pKCS1AlgorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidAlgorithmParameterException("Cannot init MGF engine: " + invalidAlgorithmParameterException.toString());
        }
        pKCS1AlgorithmParameterSpec = new RSAOaepParameterSpec(algorithmID, algorithmID3, algorithmID2);
        ((RSAOaepParameterSpec)pKCS1AlgorithmParameterSpec).setHashEngine(messageDigest);
        ((RSAOaepParameterSpec)pKCS1AlgorithmParameterSpec).setMGFEngine(maskGenerationAlgorithm);
        ((RSAOaepParameterSpec)pKCS1AlgorithmParameterSpec).setEncodeDefaultValues(Boolean.TRUE);
        return pKCS1AlgorithmParameterSpec;
    }

    public static AlgorithmID createRsaOaepAlgorithmID(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.pSpecified.clone();
        byte[] byArray = new byte[]{};
        AlgorithmID algorithmID3 = Util.createRsaOaepAlgorithmID((AlgorithmID)algorithmID.clone(), algorithmID2, byArray);
        return algorithmID3;
    }

    public static AlgorithmID createRsaOaepAlgorithmID(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.rsaesOAEP.clone();
        RSAOaepParameterSpec rSAOaepParameterSpec = Util.createRsaOaepParameters(algorithmID, algorithmID2, byArray);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("RSAES-OAEP", IAIK.getInstance());
            algorithmParameters.init(rSAOaepParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Cannot init OAEP params: " + invalidParameterSpecException.getMessage());
        }
        algorithmID3.setAlgorithmParameters(algorithmParameters);
        return algorithmID3;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        h = false;
        Util.toString(null, -1, 1);
    }

    private static class IaikVector
    extends Vector {
        private static final long serialVersionUID = -1508109320737291997L;

        public IaikVector(Object[] objectArray) {
            super(objectArray.length * 11 / 10);
            System.arraycopy(objectArray, 0, this.elementData, 0, objectArray.length);
            this.elementCount = objectArray.length;
        }
    }
}

