/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.pkcs.pkcs12.PKCS12KeyStore;
import iaik.pkcs.pkcs12.PKCS12ParsingException;
import iaik.security.keystore.IAIKKeyStoreParsingException;
import iaik.utils.IaikSecurity;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class UniversalKeyStore
extends KeyStoreSpi {
    public static final KeyStoreType KS_TYPE_PKCS12 = new KeyStoreType("PKCS12", "IAIK", "iaik.pkcs.pkcs12.PKCS12KeyStore");
    public static final KeyStoreType KS_TYPE_IAIK = new KeyStoreType("IAIKKeyStore", "IAIK", "iaik.security.keystore.IAIKKeyStore");
    static final KeyStoreType a = new KeyStoreType("JKS", "SUN");
    private static KeyStoreType[] d = new KeyStoreType[]{KS_TYPE_PKCS12, KS_TYPE_IAIK};
    private KeyStoreType[] e;
    KeyStoreSpi b;
    static Class c;

    public static final void setSupportedKeyStoreTypes(KeyStoreType[] keyStoreTypeArray) {
        if (keyStoreTypeArray == null) {
            throw new NullPointerException("keyStoreTypes must not be null!");
        }
        d = (KeyStoreType[])keyStoreTypeArray.clone();
    }

    public UniversalKeyStore() {
        this.e = (KeyStoreType[])d.clone();
    }

    UniversalKeyStore(KeyStoreType[] keyStoreTypeArray) {
        this.e = (KeyStoreType[])keyStoreTypeArray.clone();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.b.engineGetKey(string, cArray);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return this.b.engineGetCertificateChain(string);
    }

    public Certificate engineGetCertificate(String string) {
        return this.b.engineGetCertificate(string);
    }

    public Date engineGetCreationDate(String string) {
        return this.b.engineGetCreationDate(string);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.b.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.b.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.b.engineSetCertificateEntry(string, certificate);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.b.engineDeleteEntry(string);
    }

    public Enumeration engineAliases() {
        return this.b.engineAliases();
    }

    public boolean engineContainsAlias(String string) {
        return this.b.engineContainsAlias(string);
    }

    public int engineSize() {
        return this.b.engineSize();
    }

    public boolean engineIsKeyEntry(String string) {
        return this.b.engineIsKeyEntry(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.b.engineIsCertificateEntry(string);
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        return this.b.engineGetCertificateAlias(certificate);
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.b.engineStore(outputStream, cArray);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        InputStream inputStream2 = inputStream;
        if (inputStream != null) {
            inputStream2 = new BufferedInputStream(inputStream);
            inputStream2.mark(50000);
        }
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        IOException iOException = null;
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            block11: {
                KeyStoreType keyStoreType = this.e[i2];
                if (keyStoreType == null) continue;
                try {
                    String string;
                    String string2;
                    Provider provider;
                    KeyStoreSpi keyStoreSpi = keyStoreType.c();
                    if (keyStoreSpi instanceof a && "IAIK".equals((provider = ((a)keyStoreSpi).a()).getName()) && (string2 = (String)provider.get(string = "KeyStore." + keyStoreType.a())) != null && string2.startsWith("iaik.utils.UniversalKeyStore")) {
                        throw new NoSuchAlgorithmException("No IAIK KeyStore implementation for " + string + " available!");
                    }
                    keyStoreSpi.engineLoad(inputStream2, cArray);
                    this.b = keyStoreSpi;
                    noSuchAlgorithmException = null;
                    iOException = null;
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    if (noSuchAlgorithmException == null && iOException == null) {
                        noSuchAlgorithmException = noSuchAlgorithmException2;
                    }
                }
                catch (IOException iOException2) {
                    if ("PKCS12".equals(keyStoreType.a()) && "IAIK".equals(keyStoreType.b()) && !(iOException2 instanceof PKCS12ParsingException)) {
                        throw iOException2;
                    }
                    if ("IAIKKeyStore".equals(keyStoreType.a()) && "IAIK".equals(keyStoreType.b()) && !(iOException2 instanceof IAIKKeyStoreParsingException)) {
                        throw iOException2;
                    }
                    if (noSuchAlgorithmException != null || iOException != null) break block11;
                    iOException = iOException2;
                }
            }
            if (inputStream2 == null) continue;
            inputStream2.reset();
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PKCS12JKSKeyStore
    extends UniversalKeyStore {
        public PKCS12JKSKeyStore() {
            KeyStoreType[] keyStoreTypeArray;
            if (PKCS12KeyStore.getUseJKSFallBack()) {
                KeyStoreType[] keyStoreTypeArray2 = new KeyStoreType[2];
                keyStoreTypeArray2[0] = KS_TYPE_PKCS12;
                keyStoreTypeArray = keyStoreTypeArray2;
                keyStoreTypeArray2[1] = a;
            } else {
                KeyStoreType[] keyStoreTypeArray3 = new KeyStoreType[1];
                keyStoreTypeArray = keyStoreTypeArray3;
                keyStoreTypeArray3[0] = KS_TYPE_PKCS12;
            }
            super(keyStoreTypeArray);
        }
    }

    public static class KeyStoreType {
        private String b;
        private String c;
        private Provider d;
        String a;

        public KeyStoreType(String string, String string2) {
            this.b = string;
            this.c = string2;
        }

        public KeyStoreType(String string, Provider provider) {
            this.b = string;
            if (provider != null) {
                this.d = provider;
                this.c = provider.getName();
            }
        }

        KeyStoreType(String string, String string2, String string3) {
            this.b = string;
            this.c = string2;
            this.a = string3;
        }

        String a() {
            return this.b;
        }

        String b() {
            return this.c;
        }

        KeyStoreSpi c() throws NoSuchAlgorithmException {
            KeyStoreSpi keyStoreSpi = null;
            if (this.a != null) {
                try {
                    keyStoreSpi = (KeyStoreSpi)Class.forName(this.a).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (keyStoreSpi == null) {
                if (this.d == null) {
                    try {
                        keyStoreSpi = new a(this.b, this.c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (keyStoreSpi == null) {
                    try {
                        keyStoreSpi = new a(this.b, this.d);
                    }
                    catch (Exception exception) {
                        throw new NoSuchAlgorithmException(exception.toString());
                    }
                }
            }
            return keyStoreSpi;
        }
    }

    private static final class a
    extends KeyStoreSpi {
        private KeyStore a;

        a(String string, String string2) throws KeyStoreException, NoSuchProviderException {
            this.a = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
        }

        a(String string, Provider provider) throws KeyStoreException, NoSuchProviderException {
            if (provider == null) {
                this.a = KeyStore.getInstance(string);
            } else {
                try {
                    this.a = (KeyStore)IaikSecurity.getEngine(string, "KeyStore", c == null ? (c = UniversalKeyStore.class$("java.security.KeyStore")) : c, provider);
                }
                catch (Exception exception) {
                    throw new KeyStoreException(exception.toString());
                }
            }
        }

        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            try {
                return this.a.getKey(string, cArray);
            }
            catch (Exception exception) {
                throw new UnrecoverableKeyException(exception.toString());
            }
        }

        public Certificate[] engineGetCertificateChain(String string) {
            Certificate[] certificateArray = null;
            try {
                certificateArray = this.a.getCertificateChain(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return certificateArray;
        }

        public Certificate engineGetCertificate(String string) {
            Certificate certificate = null;
            try {
                certificate = this.a.getCertificate(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return certificate;
        }

        public Date engineGetCreationDate(String string) {
            Date date = null;
            try {
                date = this.a.getCreationDate(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return date;
        }

        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            this.a.setKeyEntry(string, key, cArray, certificateArray);
        }

        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            this.a.setKeyEntry(string, byArray, certificateArray);
        }

        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            this.a.setCertificateEntry(string, certificate);
        }

        public void engineDeleteEntry(String string) throws KeyStoreException {
            this.a.deleteEntry(string);
        }

        public Enumeration engineAliases() {
            Enumeration<String> enumeration = null;
            try {
                enumeration = this.a.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                enumeration = new Vector().elements();
            }
            return enumeration;
        }

        public boolean engineContainsAlias(String string) {
            boolean bl = false;
            try {
                bl = this.a.containsAlias(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return bl;
        }

        public int engineSize() {
            int n2 = 0;
            try {
                n2 = this.a.size();
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return n2;
        }

        public boolean engineIsKeyEntry(String string) {
            boolean bl = false;
            try {
                bl = this.a.isKeyEntry(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return bl;
        }

        public boolean engineIsCertificateEntry(String string) {
            boolean bl = false;
            try {
                bl = this.a.isCertificateEntry(string);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return bl;
        }

        public String engineGetCertificateAlias(Certificate certificate) {
            String string = null;
            try {
                string = this.a.getCertificateAlias(certificate);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return string;
        }

        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            try {
                this.a.store(outputStream, cArray);
            }
            catch (KeyStoreException keyStoreException) {
                throw new IOException(keyStoreException.toString());
            }
        }

        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            this.a.load(inputStream, cArray);
        }

        Provider a() {
            return this.a.getProvider();
        }
    }
}

