/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParserException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class RFC2253NameParser {
    private static boolean b;
    private static final Hashtable c;
    static Hashtable a;
    protected ParsedName name_ = new ParsedName();
    protected int position_ = 0;
    protected StringBuffer nameStrBuf_;

    public static void register(String string, ObjectID objectID) {
        RFC2253NameParser.register(string, objectID, true);
    }

    public static void register(String string, ObjectID objectID, boolean bl) {
        if (string != null) {
            c.put(string, objectID);
            if (!bl) {
                a.put(string.toUpperCase(), objectID);
            }
        }
    }

    public static void checkObjectIDForAssociatedOIDs(boolean bl) {
        b = bl;
    }

    public RFC2253NameParser(String string) {
        try {
            this.nameStrBuf_ = new StringBuffer(string);
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }

    public Name parse() throws RFC2253NameParserException {
        if (this.nameStrBuf_.length() == 0) {
            return new Name();
        }
        boolean bl = false;
        do {
            this.name_.rDNs_.addElement(this.parseRDN());
            this.skipSpace();
            if (this.position_ == this.nameStrBuf_.length()) {
                bl = false;
            } else if (this.nameStrBuf_.charAt(this.position_) == ',' || this.nameStrBuf_.charAt(this.position_) == ';') {
                ++this.position_;
                bl = true;
            } else {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("RDNs are not separated by comma or semicolon (position {0,number,integer}).", objectArray);
            }
            this.skipSpaceAndLineBreak();
        } while (bl);
        Name name = new Name();
        ShortNameOIDAssociation shortNameOIDAssociation = new ShortNameOIDAssociation();
        for (int i2 = this.name_.rDNs_.size() - 1; i2 >= 0; --i2) {
            RDN rDN = new RDN();
            ParsedRDN parsedRDN = (ParsedRDN)this.name_.rDNs_.elementAt(i2);
            for (int i3 = 0; i3 < parsedRDN.aVAs_.size(); ++i3) {
                Object object;
                Object object2;
                AVA aVA = (AVA)parsedRDN.aVAs_.elementAt(i3);
                ObjectID objectID = "0123456789".indexOf(aVA.type_.charAt(0)) == -1 ? shortNameOIDAssociation.getOID(aVA.type_) : new ObjectID(aVA.type_);
                if (aVA.hasHexValue_) {
                    object2 = null;
                    try {
                        object2 = aVA.value_.getBytes("ISO8859_1");
                        object = DerCoder.decode((byte[])object2);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (object2 != null) {
                            for (int i4 = 0; i4 < ((byte[])object2).length; ++i4) {
                                if (object2[i4] < 16) {
                                    stringBuffer.append("0");
                                }
                                stringBuffer.append(Integer.toHexString(object2[i4]));
                            }
                        }
                        Object[] objectArray = new Object[]{stringBuffer.toString()};
                        throw new RFC2253NameParserException("Cannot create AVA due to invalid hex value in attribute value (\"{0}\")", objectArray);
                    }
                } else {
                    object = aVA.value_;
                }
                object2 = object instanceof String ? (!PrintableString.isPrintableString((String)object) ? (Object)new UTF8String((String)object) : (Object)object) : (Object)object;
                iaik.asn1.structures.AVA aVA2 = new iaik.asn1.structures.AVA(objectID, object2);
                rDN.addAVA(aVA2, false);
            }
            name.addRDN(rDN);
        }
        return name;
    }

    protected ParsedRDN parseRDN() throws RFC2253NameParserException {
        ParsedRDN parsedRDN = new ParsedRDN();
        boolean bl = false;
        do {
            parsedRDN.aVAs_.addElement(this.parseAVA());
            this.skipSpace();
            if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '+') {
                ++this.position_;
                this.skipSpaceAndLineBreak();
                if (this.position_ == this.nameStrBuf_.length()) {
                    Object[] objectArray = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Cannot find another AVA after having parsed a plus (position {0,number,integer}).", objectArray);
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        return parsedRDN;
    }

    protected AVA parseAVA() throws RFC2253NameParserException {
        String string = this.parseAttrType();
        this.skipSpace();
        if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '=') {
            ++this.position_;
        } else {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot find attribute value after having parsed an equal (position {0,number,integer}).", objectArray);
        }
        this.skipSpace();
        AVA aVA = this.parseAttrValue();
        aVA.type_ = string;
        this.skipSpace();
        return aVA;
    }

    protected String parseAttrType() throws RFC2253NameParserException {
        this.skipOIDIntro();
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
            int n2;
            for (n2 = this.position_; n2 < this.nameStrBuf_.length() && (this.nameStrBuf_.charAt(n2) == '-' || "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(this.nameStrBuf_.charAt(n2)) != -1 || "0123456789".indexOf(this.nameStrBuf_.charAt(n2)) != -1); ++n2) {
            }
            if (n2 - this.position_ < 1) {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Attribute type short name is corrupt (position {0,number,integer}).", objectArray);
            }
            String string = this.nameStrBuf_.toString().substring(this.position_, n2);
            this.position_ = n2;
            return string;
        }
        int n3 = this.position_;
        int n4 = this.position_;
        int n5 = this.position_;
        boolean bl = false;
        while (true) {
            if (n5 < this.nameStrBuf_.length() && "0123456789".indexOf(this.nameStrBuf_.charAt(n5)) != -1) {
                ++n5;
                continue;
            }
            if (n5 - n4 < 1) {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Object Identifier representing attribute type is corrupt (position {0,number,integer}).", objectArray);
            }
            n3 = n5;
            if (this.nameStrBuf_.charAt(n5) == '.') {
                bl = true;
                n4 = ++n5;
            } else {
                bl = false;
            }
            if (!bl) break;
        }
        String string = this.nameStrBuf_.toString().substring(this.position_, n3);
        this.position_ = n3;
        return string;
    }

    protected AVA parseAttrValue() throws RFC2253NameParserException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        AVA aVA = new AVA();
        if (this.position_ == this.nameStrBuf_.length()) {
            aVA.value_ = stringBuffer.toString();
            return aVA;
        }
        boolean bl2 = this.nameStrBuf_.charAt(this.position_) == '\"';
        boolean bl3 = bl = this.nameStrBuf_.charAt(this.position_) == '#';
        if (bl2) {
            ++this.position_;
            if (this.position_ == this.nameStrBuf_.length()) {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", objectArray);
            }
            while (this.nameStrBuf_.charAt(this.position_) != '\"') {
                if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                    ++this.position_;
                    if (this.position_ == this.nameStrBuf_.length()) {
                        Object[] objectArray = new Object[]{new Integer(this.position_)};
                        throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", objectArray);
                    }
                    if (this.nameStrBuf_.charAt(this.position_) == '\\' || this.nameStrBuf_.charAt(this.position_) == '\"') {
                        stringBuffer.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                    } else {
                        stringBuffer.append(this.parseHexPairEscapeSequence());
                    }
                } else {
                    stringBuffer.append(this.nameStrBuf_.charAt(this.position_));
                    ++this.position_;
                }
                if (this.position_ != this.nameStrBuf_.length()) continue;
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", objectArray);
            }
            ++this.position_;
        } else if (bl) {
            aVA.hasHexValue_ = true;
            ++this.position_;
            stringBuffer.append(this.parseHexPair());
            while (this.position_ != this.nameStrBuf_.length() && "0123456789ABCDEFabcdef".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                stringBuffer.append(this.parseHexPair());
            }
        } else {
            while (this.position_ != this.nameStrBuf_.length() && ",;+".indexOf(this.nameStrBuf_.charAt(this.position_)) == -1) {
                if ("<>\"".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                    Object[] objectArray = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Invalid character (<>\") found in attribute value (position {0,number,integer}).", objectArray);
                }
                if (this.nameStrBuf_.charAt(this.position_) == ' ') {
                    if (this.position_ + 1 == this.nameStrBuf_.length() || ",;+".indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) != -1) {
                        int n2 = this.position_;
                        while (this.nameStrBuf_.charAt(n2 - 1) == ' ') {
                            --n2;
                        }
                        stringBuffer.setLength(stringBuffer.length() - this.position_ + n2);
                        ++this.position_;
                        continue;
                    }
                    stringBuffer.append(this.nameStrBuf_.charAt(this.position_));
                    ++this.position_;
                    continue;
                }
                if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                    ++this.position_;
                    if (this.position_ == this.nameStrBuf_.length()) {
                        Object[] objectArray = new Object[]{new Integer(this.position_)};
                        throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", objectArray);
                    }
                    if ("=# ,+\"\\<>;".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                        stringBuffer.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                        continue;
                    }
                    stringBuffer.append(this.parseHexPairEscapeSequence());
                    continue;
                }
                stringBuffer.append(this.nameStrBuf_.charAt(this.position_));
                ++this.position_;
            }
        }
        try {
            aVA.value_ = stringBuffer.toString();
            return aVA;
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }

    protected char parseHexPair() throws RFC2253NameParserException {
        if (this.nameStrBuf_.length() - this.position_ < 2) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot parse hex pair (position {0,number,integer}).", objectArray);
        }
        if ("0123456789ABCDEFabcdef".indexOf(this.nameStrBuf_.charAt(this.position_)) == -1 || "0123456789ABCDEFabcdef".indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) == -1) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Invalid hex pair character found when parsing a hex pair (position {0,number,integer}).", objectArray);
        }
        char c2 = (char)Integer.parseInt(this.nameStrBuf_.toString().substring(this.position_, this.position_ + 2), 16);
        this.position_ += 2;
        return c2;
    }

    protected char parseHexPairEscapeSequence() throws RFC2253NameParserException {
        char c2 = this.parseHexPair();
        if ((c2 & 0x80) == 0) {
            return c2;
        }
        if ((c2 & 0xE0) == 224) {
            ++this.position_;
            char c3 = this.parseHexPair();
            ++this.position_;
            char c4 = this.parseHexPair();
            int n2 = (c2 & 0xF) << 12;
            n2 += (c3 & 0x3F) << 6;
            return (char)(n2 += c4 & 0x3F);
        }
        ++this.position_;
        char c5 = this.parseHexPair();
        int n3 = (c2 & 0x1F) << 6;
        return (char)(n3 += c5 & 0x3F);
    }

    protected void skipSpace() {
        while (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == ' ') {
            ++this.position_;
        }
    }

    protected void skipSpaceAndLineBreak() {
        int n2 = this.nameStrBuf_.length();
        while (this.position_ < n2) {
            int n3;
            char c2 = this.nameStrBuf_.charAt(this.position_);
            if (c2 == ' ' || c2 == '\n') {
                ++this.position_;
                continue;
            }
            if (c2 != '\r' || (n3 = this.position_ + 1) >= n2 || this.nameStrBuf_.charAt(n3) != '\n') break;
            this.position_ += 2;
        }
    }

    protected void skipOIDIntro() {
        if (this.nameStrBuf_.length() - this.position_ < 4) {
            return;
        }
        String string = this.nameStrBuf_.toString().substring(this.position_, this.position_ + 4);
        if (string.equalsIgnoreCase("oid.")) {
            this.position_ += 4;
        }
    }

    static Hashtable a() {
        return c;
    }

    static boolean b() {
        return b;
    }

    static {
        c = new Hashtable(50);
        a = new Hashtable(50);
        RFC2253NameParser.register("CN", ObjectID.commonName, false);
        RFC2253NameParser.register("C", ObjectID.country, false);
        RFC2253NameParser.register("L", ObjectID.locality, false);
        RFC2253NameParser.register("ST", ObjectID.stateOrProvince, false);
        RFC2253NameParser.register("STREET", ObjectID.streetAddress, false);
        RFC2253NameParser.register("O", ObjectID.organization, false);
        RFC2253NameParser.register("OU", ObjectID.organizationalUnit, false);
        RFC2253NameParser.register("T", ObjectID.title, false);
        RFC2253NameParser.register("title", ObjectID.title, false);
        RFC2253NameParser.register("SN", ObjectID.surName, false);
        RFC2253NameParser.register("DC", ObjectID.domainComponent, false);
        RFC2253NameParser.register("UID", ObjectID.userid, false);
        RFC2253NameParser.register("serialNumber", ObjectID.serialNumber, false);
        RFC2253NameParser.register("postalAddress", ObjectID.postalAddress, false);
        RFC2253NameParser.register("postalCode", ObjectID.postalCode, false);
        RFC2253NameParser.register("telephoneNumber", ObjectID.telephoneNumber, false);
        RFC2253NameParser.register("telexNumber", ObjectID.telexNumber, false);
        RFC2253NameParser.register("description", ObjectID.description, false);
        RFC2253NameParser.register("givenName", ObjectID.givenName, false);
        RFC2253NameParser.register("initials", ObjectID.initials, false);
        RFC2253NameParser.register("generationQualifier", ObjectID.generationQualifier, false);
        RFC2253NameParser.register("uniqueIdentifier", ObjectID.uniqueIdentifier, false);
        RFC2253NameParser.register("dnQualifier", ObjectID.dnQualifier, false);
        RFC2253NameParser.register("pseudonym", ObjectID.pseudonym, false);
        RFC2253NameParser.register("dateOfBirth", ObjectID.dateOfBirth, false);
        RFC2253NameParser.register("placeOfBirth", ObjectID.placeOfBirth, false);
        RFC2253NameParser.register("gender", ObjectID.gender, false);
        RFC2253NameParser.register("countryOfCitizenship", ObjectID.countryOfCitizenship, false);
        RFC2253NameParser.register("countryOfResidence", ObjectID.countryOfResidence, false);
        RFC2253NameParser.register("personalTitle", ObjectID.personalTitle, false);
        RFC2253NameParser.register("EMail", ObjectID.emailAddress, false);
        RFC2253NameParser.register("E", ObjectID.emailAddress, false);
        RFC2253NameParser.register("EA", ObjectID.emailAddress, false);
        RFC2253NameParser.register("MAIL", ObjectID.emailAddress, false);
        RFC2253NameParser.register("EMAIL", ObjectID.emailAddress, false);
        RFC2253NameParser.register("emailAddress", ObjectID.emailAddress, false);
        RFC2253NameParser.register("EmailAddress", ObjectID.emailAddress, false);
        RFC2253NameParser.register("EMAILADDRESS", ObjectID.emailAddress, false);
    }

    protected static class ShortNameOIDAssociation {
        protected ShortNameOIDAssociation() {
        }

        protected ObjectID getOID(String string) throws RFC2253NameParserException {
            ObjectID objectID = null;
            if (string != null && (objectID = (ObjectID)RFC2253NameParser.a().get(string)) == null) {
                objectID = (ObjectID)a.get(string.toUpperCase());
                if (objectID == null) {
                    objectID = (ObjectID)a.get(string.toUpperCase(Locale.US));
                }
                if (objectID == null && RFC2253NameParser.b() && (objectID = ObjectID.getRegisteredObjectID(string)) == null) {
                    objectID = ObjectID.getRegisteredObjectID(string.toUpperCase(Locale.US));
                }
                if (objectID == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new RFC2253NameParserException("No Object identifier found for Short Name \"{0}\".", objectArray);
                }
            }
            return objectID;
        }
    }

    protected static class AVA {
        protected String type_;
        protected String value_;
        protected boolean hasHexValue_ = false;

        protected AVA() {
        }
    }

    protected static class ParsedRDN {
        protected Vector aVAs_ = new Vector();

        protected ParsedRDN() {
        }
    }

    protected static class ParsedName {
        protected Vector rDNs_ = new Vector();

        protected ParsedName() {
        }
    }
}

