/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.InternalErrorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class PretendedMessageDigest
extends MessageDigest
implements Cloneable {
    private ByteArrayOutputStream a;
    private int b;

    public PretendedMessageDigest() {
        super("DUMMY");
        this.a = new ByteArrayOutputStream(64);
    }

    public PretendedMessageDigest(String string, int n2) {
        super(string);
        if (string == null) {
            throw new NullPointerException("MessageDigest engine name must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Digest length must not be negative!");
        }
        this.b = n2;
        this.a = new ByteArrayOutputStream(this.b);
    }

    protected final void engineUpdate(byte by) {
        int n2;
        if (this.b > 0 && (n2 = this.a.size() + 1) > this.b) {
            throw new IllegalArgumentException("Total input data length " + n2 + " exceeds digest size " + this.b + ".");
        }
        this.a.write(by);
    }

    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.b > 0 && (n4 = this.a.size() + n3) > this.b) {
            throw new IllegalArgumentException("Total input data length " + n4 + " exceeds digest size " + this.b + ".");
        }
        this.a.write(byArray, n2, n3);
    }

    protected byte[] engineDigest() {
        byte[] byArray = this.a.toByteArray();
        if (this.b > 0 && byArray.length != this.b) {
            throw new IllegalArgumentException("Total input hash length " + byArray.length + " not equal to digest size " + this.b + ".");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("No hash value has been set!");
        }
        this.b = byArray.length;
        this.engineReset();
        return byArray;
    }

    public int engineGetDigestLength() {
        return this.b;
    }

    protected void engineReset() {
        this.a.reset();
    }

    public Object clone() {
        PretendedMessageDigest pretendedMessageDigest = null;
        try {
            pretendedMessageDigest = (PretendedMessageDigest)super.clone();
            byte[] byArray = this.a.toByteArray();
            pretendedMessageDigest.a = new ByteArrayOutputStream(byArray.length);
            try {
                pretendedMessageDigest.a.write(this.a.toByteArray());
            }
            catch (IOException iOException) {
                throw new InternalErrorException("Error copying buffer: " + iOException.getMessage(), iOException);
            }
            pretendedMessageDigest.b = this.b;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return pretendedMessageDigest;
    }
}

