/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public final class NumberTheory {
    public static final int SMALLEST_PRIME_SIZE = 160;
    public static final BigInteger ZERO = BigInteger.ZERO;
    public static final BigInteger ONE = BigInteger.ONE;
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    private static BigInteger[] a;
    private static final BigInteger b;

    private NumberTheory() {
    }

    public static int gcd(int n2, int n3) {
        while (n3 != 0) {
            int n4 = n2 % n3;
            n2 = n3;
            n3 = n4;
        }
        return n2;
    }

    public static int[] extGcd(int n2, int n3) {
        if (n3 == 0) {
            return new int[]{n2, 1, 0};
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n3 > 0) {
            int n8 = n2 / n3;
            int n9 = n2 - n8 * n3;
            int n10 = n4 - n8 * n5;
            int n11 = n6 - n8 * n7;
            n2 = n3;
            n3 = n9;
            n4 = n5;
            n5 = n10;
            n6 = n7;
            n7 = n11;
        }
        return new int[]{n2, n4, n6};
    }

    public static BigInteger nextPrime(BigInteger bigInteger) {
        bigInteger = bigInteger.setBit(0);
        while (!NumberTheory.isProbablePrime(bigInteger)) {
            bigInteger = bigInteger.add(TWO);
        }
        return bigInteger;
    }

    private static final BigInteger a(Random random) {
        byte[] byArray = new byte[13];
        random.nextBytes(byArray);
        byArray[0] = (byte)(byArray[0] & 0x1F);
        byArray[0] = (byte)(byArray[0] | 0x10);
        return new BigInteger(1, byArray);
    }

    public static BigInteger getStrongPrime(int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = ZERO.setBit(511 + 128 * n2);
        BigDecimal bigDecimal = new BigDecimal(Math.sqrt(2.0));
        BigInteger bigInteger3 = new BigDecimal(bigInteger2).multiply(bigDecimal).toBigInteger();
        while ((bigInteger = new BigInteger(512 + 128 * n2, random)).compareTo(bigInteger3) == -1) {
        }
        BigInteger bigInteger4 = NumberTheory.nextPrime(NumberTheory.a(random));
        BigInteger bigInteger5 = NumberTheory.nextPrime(NumberTheory.a(random));
        BigInteger bigInteger6 = bigInteger5.modInverse(bigInteger4).multiply(bigInteger5).subtract(bigInteger4.modInverse(bigInteger5).multiply(bigInteger4));
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger.add(bigInteger6.subtract(bigInteger).mod(bigInteger7));
        while (!NumberTheory.isProbablePrime(bigInteger8)) {
            bigInteger8 = bigInteger8.add(bigInteger7);
        }
        return bigInteger8;
    }

    public static boolean isProbablePrime(BigInteger bigInteger) {
        if (bigInteger.compareTo(ONE) <= 0) {
            return false;
        }
        if (NumberTheory.hasSmallFactors(bigInteger)) {
            return false;
        }
        return NumberTheory.millerRabin(bigInteger);
    }

    public static boolean millerRabin(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        int n3 = 0;
        if (n2 <= 500) {
            if (n2 < 160) {
                throw new IllegalArgumentException("bit length must be at least 160!");
            }
            if (n2 == 160) {
                n3 = 34;
            } else if (n2 <= 163) {
                n3 = 33;
            } else if (n2 <= 166) {
                n3 = 32;
            } else if (n2 <= 169) {
                n3 = 31;
            } else if (n2 <= 173) {
                n3 = 30;
            } else if (n2 <= 177) {
                n3 = 29;
            } else if (n2 <= 181) {
                n3 = 28;
            } else if (n2 <= 185) {
                n3 = 27;
            } else if (n2 <= 190) {
                n3 = 26;
            } else if (n2 <= 195) {
                n3 = 25;
            } else if (n2 <= 201) {
                n3 = 24;
            } else if (n2 <= 208) {
                n3 = 23;
            } else if (n2 <= 222) {
                n3 = 22;
            } else if (n2 <= 231) {
                n3 = 20;
            } else if (n2 <= 241) {
                n3 = 19;
            } else if (n2 <= 252) {
                n3 = 18;
            } else if (n2 <= 264) {
                n3 = 17;
            } else if (n2 <= 278) {
                n3 = 16;
            } else if (n2 <= 294) {
                n3 = 15;
            } else if (n2 <= 313) {
                n3 = 14;
            } else if (n2 <= 334) {
                n3 = 13;
            } else if (n2 <= 360) {
                n3 = 12;
            } else if (n2 <= 392) {
                n3 = 11;
            } else if (n2 <= 430) {
                n3 = 10;
            } else if (n2 <= 479) {
                n3 = 9;
            } else if (n2 <= 499) {
                n3 = 8;
            }
        } else {
            n3 = n2 <= 542 ? 8 : (n2 <= 626 ? 7 : (n2 <= 746 ? 6 : (n2 <= 926 ? 5 : (n2 <= 1232 ? 4 : (n2 <= 1853 ? 3 : 2)))));
        }
        Random random = new Random();
        BigInteger bigInteger2 = bigInteger.subtract(ONE);
        int n4 = bigInteger2.getLowestSetBit();
        BigInteger bigInteger3 = bigInteger2.shiftRight(n4);
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        int n5 = 0;
        while (++n5 <= n3) {
            BigInteger bigInteger5 = new BigInteger(n2 + 2, random);
            BigInteger bigInteger6 = (bigInteger5 = bigInteger5.mod(bigInteger4).add(ONE)).modPow(bigInteger3, bigInteger);
            if (bigInteger6.compareTo(ONE) == 0 || bigInteger6.compareTo(bigInteger2) == 0) continue;
            boolean bl = false;
            for (int i2 = 1; i2 < n4; ++i2) {
                if ((bigInteger6 = bigInteger6.modPow(TWO, bigInteger)).compareTo(bigInteger2) == 0) {
                    bl = true;
                    break;
                }
                if (bigInteger6.compareTo(ONE) != 0) continue;
                return false;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSmallFactors(BigInteger bigInteger) {
        if (!bigInteger.testBit(0)) {
            return true;
        }
        if (bigInteger.bitLength() < 59) {
            return false;
        }
        long l2 = bigInteger.mod(b).longValue();
        int n2 = (int)(l2 % 111546435L);
        if (n2 % 3 == 0 || n2 % 5 == 0 || n2 % 7 == 0 || n2 % 11 == 0 || n2 % 13 == 0 || n2 % 17 == 0 || n2 % 19 == 0 || n2 % 23 == 0) {
            return true;
        }
        int n3 = (int)(l2 % 58642669L);
        if (n3 % 29 == 0 || n3 % 31 == 0 || n3 % 37 == 0 || n3 % 41 == 0 || n3 % 43 == 0) {
            return true;
        }
        for (int i2 = 13; i2 < a.length; ++i2) {
            if (bigInteger.mod(a[i2]).signum() != 0) continue;
            return true;
        }
        return false;
    }

    static {
        b = BigInteger.valueOf(6541380665835015L);
        String string = "AAMABQAHAAsADQARABMAFwAdAB8AJQApACsALwA1ADsAPQBDAEcASQBPAFMAWQBhAGUAZwBrAG0AcQB/AIMAiQCLAJUAlwCdAKMApwCtALMAtQC/AMEAxQDHANMA3wDjAOUA6QDvAPEA+wEBAQcBDQEPARUBGQEbASUBMwE3ATkBPQFLAVEBWwFdAWEBZwFvAXUBewF/AYUBjQGRAZkBowGlAa8BsQG3AbsBwQHJAc0BzwHTAd8B5wHrAfMB9wH9AgkCCwIdAiMCLQIzAjkCOwJBAksCUQJXAlkCXwJlAmkCawJ3AoECgwKHAo0CkwKVAqECpQKrArMCvQLFAs8C1w==";
        byte[] byArray = Util.decodeByteArray(string);
        int n2 = byArray.length >> 1;
        a = new BigInteger[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n4++] & 0xFF;
            n5 = n5 << 8 | byArray[n4] & 0xFF;
            NumberTheory.a[n3] = BigInteger.valueOf(n5);
            ++n3;
            ++n4;
        }
    }
}

