/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.random.SecRandom;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Vector;

public class KeyAndCertificate {
    X509Certificate[] a;
    PrivateKey b;

    public KeyAndCertificate(String string) throws IOException {
        this(new FileInputStream(string), true);
    }

    public KeyAndCertificate(InputStream inputStream) throws IOException {
        this(Util.readStream(inputStream));
    }

    public KeyAndCertificate(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), true);
    }

    private KeyAndCertificate(InputStream inputStream, boolean bl) throws IOException {
        Cloneable cloneable;
        try {
            cloneable = new ASN1(inputStream).toASN1Object();
            this.b = ((ASN1Object)cloneable).countComponents() == 2 ? new EncryptedPrivateKeyInfo((ASN1Object)cloneable) : PrivateKeyInfo.getPrivateKey((ASN1Object)cloneable);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to decode private key: " + invalidKeyException.toString());
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to decode private key: " + codingException.toString());
        }
        cloneable = new Vector();
        try {
            while (inputStream.available() > 10) {
                ((Vector)cloneable).addElement(new X509Certificate(inputStream));
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to decode certificate: " + certificateException.toString());
        }
        this.a = new X509Certificate[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto(this.a);
        inputStream.close();
    }

    public KeyAndCertificate(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.a = x509CertificateArray;
        this.b = privateKey;
    }

    public X509Certificate[] getCertificateChain() {
        return this.a;
    }

    public PrivateKey getPrivateKey() {
        return this.b;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.b != null) {
            try {
                n2 += Util.calculateHashCode(this.b.getEncoded());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.a != null) {
            try {
                n2 += Util.calculateHashCode(this.a[0].getEncoded());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof KeyAndCertificate)) {
            return false;
        }
        KeyAndCertificate keyAndCertificate = (KeyAndCertificate)object;
        if (!this.b.equals(keyAndCertificate.b)) {
            return false;
        }
        if (this.a.length != keyAndCertificate.a.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (this.a[i2].equals(keyAndCertificate.a[i2])) continue;
            return false;
        }
        return true;
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        if (n2 == 1) {
            outputStream.write(this.b.getEncoded());
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2].writeTo(outputStream);
            }
        } else {
            String string = Util.toPemString(this.b);
            outputStream.write(Util.toASCIIBytes(string));
            for (int i3 = 0; i3 < this.a.length; ++i3) {
                string = Util.toPemString(this.a[i3]);
                outputStream.write(Util.toASCIIBytes(string));
            }
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(String string, int n2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.writeTo(fileOutputStream, n2);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isEncrypted() {
        return this.b instanceof EncryptedPrivateKeyInfo;
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        if (this.isEncrypted()) {
            return;
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(this.b);
        if (algorithmID == null) {
            algorithmID = AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC;
        }
        if (secureRandom == null) {
            secureRandom = SecRandom.getDefault();
        }
        encryptedPrivateKeyInfo.encrypt(cArray, algorithmID, secureRandom);
        this.b = encryptedPrivateKeyInfo;
    }

    public PrivateKey decrypt(char[] cArray) throws NoSuchAlgorithmException {
        if (this.isEncrypted()) {
            try {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)this.b;
                this.b = encryptedPrivateKeyInfo.decrypt(cArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException.toString());
            }
        }
        return this.b;
    }
}

