/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import iaik.utils.PasswordGenerator;
import iaik.utils.UTF8CodingException;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class IAIKPasswordStore
implements Externalizable {
    private static final long serialVersionUID = -910010526845530425L;
    private byte a = 1;
    private final Cipher b;
    private final int c;
    private final Mac d;
    private final int e;
    private final SecureRandom f;
    private KeyGenerator g;
    private Hashtable h;
    private PasswordGenerator i;
    private char[] j;

    public IAIKPasswordStore() {
        this(SecRandom.getDefault());
    }

    protected void finalize() throws Throwable {
        this.clear();
        IAIKPasswordStore.a(this.j);
        super.finalize();
    }

    public IAIKPasswordStore(SecureRandom secureRandom) throws ProviderException {
        try {
            this.b = IaikSecurity.getCipherInstance("AES", IAIK.getInstance());
            this.d = IaikSecurity.getMacInstance("CMAC/AES", IAIK.getInstance());
        }
        catch (Exception exception) {
            throw new ProviderException("Could not obtain cryptographic algorithms! Please register the IAIK provider: " + exception);
        }
        this.f = secureRandom;
        this.i = new PasswordGenerator(secureRandom);
        this.c = this.b.getBlockSize();
        this.e = this.d.getMacLength();
    }

    private Hashtable a() {
        if (this.h == null) {
            this.h = new Hashtable();
        }
        return this.h;
    }

    private byte[] a(char[] cArray, byte[] byArray) throws ProviderException {
        byte[] byArray2 = null;
        try {
            byArray2 = Util.getUTF8EncodingFromCharArray(cArray);
        }
        catch (UTF8CodingException uTF8CodingException) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[32];
            this.f.nextBytes(byArray);
        }
        PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(byArray2, byArray, 2048, 16);
        try {
            this.g = IaikSecurity.getKeyGeneratorInstance("PBKDF2", IAIK.getInstance());
            this.g.init(pBEKeyAndParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException("Could not obtain cryptographic algorithms! Please register the IAIK provider: " + noSuchAlgorithmException);
        }
        return byArray;
    }

    static void a(char[] cArray) {
        if (cArray != null) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = '\u0000';
            }
        }
    }

    public void load(String string, char[] cArray) throws IOException {
        this.load(new File(string), cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, char[] cArray) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file may not be null!");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.load(fileInputStream, cArray);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in may not be null!");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("password may not be null or empty!");
        }
        this.clear();
        this.j = (char[])cArray.clone();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            this.readExternal(objectInputStream);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.g = null;
            IAIKPasswordStore.a(this.j);
            this.j = null;
        }
    }

    public void store(String string, char[] cArray) throws IOException {
        this.store(new File(string), cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, char[] cArray) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file may not be null!");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("password may not be null or empty!");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.store(fileOutputStream, cArray);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream outputStream, char[] cArray) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out may not be null!");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("password may not be null or empty!");
        }
        this.j = (char[])cArray.clone();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            this.writeExternal(objectOutputStream);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.g = null;
            IAIKPasswordStore.a(this.j);
            this.j = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        if (objectOutput == null) {
            throw new IllegalArgumentException("out may not be null!");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray2 = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.a());
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] byArray3 = this.a(this.j, null);
        SecretKey secretKey = this.g.generateKey();
        byte[] byArray4 = new byte[this.c];
        this.f.nextBytes(byArray4);
        objectOutput.writeByte(this.a);
        objectOutput.write(byArray4);
        objectOutput.write(byArray3);
        try {
            this.d.init(secretKey);
            this.b.init(1, (Key)secretKey, new IvParameterSpec(byArray4));
            byArray = this.b.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new IOException(this, "Error encrypting the store!", exception){
                private static final long serialVersionUID = 4893922477189466128L;
                private final Exception a;
                private final IAIKPasswordStore b;
                {
                    this.b = iAIKPasswordStore;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
        this.d.update(this.a);
        this.d.update(byArray4);
        this.d.update(byArray3);
        this.d.update(Util.toByteArray(byArray.length));
        byte[] byArray5 = this.d.doFinal(byArray2);
        objectOutput.write(byArray5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Hashtable hashtable;
        byte[] byArray;
        if (objectInput == null) {
            throw new IllegalArgumentException("in may not be null!");
        }
        byte by = objectInput.readByte();
        if (by <= 0 || by > 1) {
            throw new IOException("Unknown file format version!");
        }
        byte[] byArray2 = new byte[this.c];
        objectInput.readFully(byArray2);
        byte[] byArray3 = new byte[32];
        objectInput.readFully(byArray3);
        int n2 = objectInput.readInt();
        this.a(this.j, byArray3);
        SecretKey secretKey = this.g.generateKey();
        byte[] byArray4 = new byte[n2];
        objectInput.readFully(byArray4);
        try {
            this.d.init(secretKey);
            this.b.init(2, (Key)secretKey, new IvParameterSpec(byArray2));
            byArray = this.b.doFinal(byArray4);
        }
        catch (Exception exception) {
            throw new IOException(this, "Format error!", exception){
                private static final long serialVersionUID = -1002259859108202234L;
                private final Exception a;
                private final IAIKPasswordStore b;
                {
                    this.b = iAIKPasswordStore;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        this.d.update(by);
        this.d.update(byArray2);
        this.d.update(byArray3);
        this.d.update(Util.toByteArray(n2));
        byte[] byArray5 = this.d.doFinal(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] byArray6 = new byte[this.e];
        objectInput.readFully(byArray6);
        if (objectInput.available() > 0) {
            throw new IOException("Invalid format!");
        }
        if (!CryptoUtils.equalsBlock(byArray6, byArray5)) {
            throw new IOException("Invalid MAC!");
        }
        this.a = by;
        this.h = hashtable;
    }

    public char[] getPassword(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("alias may not be null or empty!");
        }
        if (this.h == null) {
            return null;
        }
        return ((SerializablePassword)this.h.get(string)).b();
    }

    public void setPasswordEntry(String string, char[] cArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("alias may not be null or empty!");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("password may not be null or empty!");
        }
        this.a().put(string, new SerializablePassword(cArray));
    }

    public char[] generatePasswordEntry(String string, int n2, int n3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("alias may not be null or empty!");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("length must be greater than 0!");
        }
        if ((n3 & 0x1F) == 0) {
            throw new IllegalArgumentException("Invalid bit mask!");
        }
        char[] cArray = this.i.generate(n2, n3);
        this.a().put(string, new SerializablePassword(cArray));
        return cArray;
    }

    public boolean containsAlias(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("alias may not be null or empty!");
        }
        if (this.h == null) {
            return false;
        }
        return this.h.containsValue(string);
    }

    public void deleteEntry(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("alias may not be null or empty!");
        }
        if (this.h == null) {
            return;
        }
        SerializablePassword serializablePassword = (SerializablePassword)this.h.remove(string);
        serializablePassword.a();
    }

    public int size() {
        return this.h == null ? 0 : this.h.size();
    }

    public Enumeration aliases() {
        return this.a().keys();
    }

    public void clear() {
        if (this.h == null || this.h.size() == 0) {
            return;
        }
        Enumeration enumeration = this.h.keys();
        while (enumeration.hasMoreElements()) {
            SerializablePassword serializablePassword = (SerializablePassword)this.h.get(enumeration.nextElement());
            if (serializablePassword == null) continue;
            serializablePassword.a();
        }
        this.h.clear();
        this.h = null;
    }

    static final class SerializablePassword
    implements Serializable {
        private char[] a;

        public SerializablePassword(char[] cArray) {
            this.a = new char[cArray.length];
            System.arraycopy(cArray, 0, this.a, 0, cArray.length);
        }

        protected void finalize() throws Throwable {
            this.a();
            super.finalize();
        }

        public void a() {
            IAIKPasswordStore.a(this.a);
            this.a = null;
        }

        public char[] b() {
            return this.a;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            byte[] byArray = null;
            try {
                byArray = Util.getUTF8EncodingFromCharArray(this.a);
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.write(byArray);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
            finally {
                if (byArray != null) {
                    CryptoUtils.zeroBlock(byArray);
                }
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            int n2 = objectInputStream.readInt();
            if (n2 < 0) {
                throw new IOException("Invalid format!");
            }
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray);
            if (objectInputStream.available() > 0) {
                throw new IOException("Invalid format!");
            }
            try {
                this.a = Util.getCharsFromUTF8Encoding(byArray);
            }
            catch (UTF8CodingException uTF8CodingException) {
                throw new IOException("Invalid UTF8 encoding: " + uTF8CodingException);
            }
            finally {
                CryptoUtils.zeroBlock(byArray);
            }
        }
    }
}

