/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.provider.IAIK;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Random;

public class DumpKeyStore {
    private static String a = System.getProperty("file.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string, String string2, char[] cArray, String string3) {
        String string4;
        File file;
        String string5;
        File file2;
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        File file3 = new File(string2);
        if (!file3.exists()) {
            DumpKeyStore.a("Output directory \"" + string2 + "\" does not exist");
        }
        if (!file3.isDirectory()) {
            DumpKeyStore.a("\"" + string2 + "\" must be a directory!");
        }
        if (!(file2 = new File(string5 = file3.getAbsolutePath() + a + "keys")).exists()) {
            file2.mkdir();
        }
        if (!(file = new File(string4 = file3.getAbsolutePath() + a + "certs")).exists()) {
            file.mkdir();
        }
        try {
            fileInputStream = new FileInputStream(string);
            keyStore = KeyStore.getInstance(string3);
            System.out.println("Loading keystore from " + string);
            keyStore.load(fileInputStream, cArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            DumpKeyStore.a("File not found " + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            DumpKeyStore.a("Error loading KeyStore: " + exception.toString());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        int n2 = 0;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string6;
                Object object;
                Certificate[] certificateArray;
                Serializable serializable;
                String string7 = enumeration.nextElement();
                System.out.println("Processing entry " + string7);
                ++n2;
                if (keyStore.isKeyEntry(string7)) {
                    block40: {
                        serializable = null;
                        try {
                            certificateArray = keyStore.getKey(string7, cArray);
                            if (certificateArray instanceof PrivateKey) {
                                serializable = (PrivateKey)keyStore.getKey(string7, cArray);
                                break block40;
                            }
                            System.out.println("Skipping non-private key entry.");
                            continue;
                        }
                        catch (Exception exception) {
                            DumpKeyStore.a("Error reading key: " + exception.toString());
                        }
                    }
                    certificateArray = keyStore.getCertificateChain(string7);
                    if (serializable == null || certificateArray == null) continue;
                    object = null;
                    try {
                        object = Util.convertCertificateChain(certificateArray);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error reading certificate: " + exception.toString());
                    }
                    string6 = string5 + a + string7;
                    string6 = string6.replace(' ', '_');
                    String string8 = string6 + ".p12";
                    System.out.println("Saving key and certificate to " + string8);
                    try {
                        DumpKeyStore.saveToPKCS12(string7, (X509Certificate[])object, (PrivateKey)serializable, string8, true, cArray, true);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving PKCS#12 file: " + exception.toString());
                    }
                    String string9 = string6 + ".p7c";
                    System.out.println("Saving certificate chain to " + string9);
                    try {
                        DumpKeyStore.saveCertificateChain((X509Certificate[])object, string9, true, true, true);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving PKCS#7 file: " + exception.toString());
                    }
                    String string10 = string6 + ".der";
                    System.out.println("Saving certificate " + string10);
                    try {
                        DumpKeyStore.saveCertificateChain((X509Certificate[])object, string10, true, false, false);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving certificate: " + exception.toString());
                    }
                    continue;
                }
                if (!keyStore.isCertificateEntry(string7) || (serializable = keyStore.getCertificate(string7)) == null) continue;
                certificateArray = null;
                try {
                    certificateArray = Util.convertCertificate(serializable);
                }
                catch (Exception exception) {
                    DumpKeyStore.a("Error reading certificate: " + exception.toString());
                }
                object = string4 + a + DumpKeyStore.a((X509Certificate)certificateArray);
                object = ((String)object).replace(' ', '_');
                string6 = (String)object + ".der";
                System.out.println("Saving certificate " + string6);
                try {
                    DumpKeyStore.saveCertificateChain(new X509Certificate[]{certificateArray}, string6, true, false, false);
                }
                catch (Exception exception) {
                    DumpKeyStore.a("Error saving certificate: " + exception.toString());
                }
            }
            System.out.println("Done! Processed " + n2 + " entries");
        }
        catch (KeyStoreException keyStoreException) {
            DumpKeyStore.a("Error reading KeyStore: " + keyStoreException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCertificateChain(X509Certificate[] x509CertificateArray, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        block38: {
            FileOutputStream fileOutputStream = null;
            try {
                int n2;
                fileOutputStream = new FileOutputStream(string);
                if (bl2) {
                    PKCS7CertList pKCS7CertList = new PKCS7CertList();
                    if (bl3) {
                        pKCS7CertList.setCertificateList(x509CertificateArray);
                    } else {
                        pKCS7CertList.setCertificateList(new X509Certificate[]{x509CertificateArray[0]});
                    }
                    if (bl) {
                        pKCS7CertList.writeTo(fileOutputStream);
                    } else {
                        try {
                            PrintWriter printWriter = null;
                            try {
                                printWriter = new PrintWriter(fileOutputStream);
                                printWriter.println("-----BEGIN PKCS7-----");
                                printWriter.println(new String(Util.Base64Encode(pKCS7CertList.toByteArray())));
                                printWriter.println("-----END PKCS7-----");
                            }
                            finally {
                                if (printWriter != null) {
                                    try {
                                        printWriter.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        catch (PKCSException pKCSException) {
                            throw new IOException(pKCSException.getMessage());
                        }
                    }
                    return;
                }
                int n3 = n2 = bl3 ? x509CertificateArray.length : 1;
                if (bl) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        x509CertificateArray[i2].writeTo(fileOutputStream);
                    }
                    break block38;
                }
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(fileOutputStream);
                    for (int i3 = 0; i3 < n2; ++i3) {
                        printWriter.println("-----BEGIN CERTIFICATE-----");
                        printWriter.println(new String(Util.Base64Encode(x509CertificateArray[i3].toByteArray())));
                        printWriter.println("-----END CERTIFICATE-----");
                    }
                }
                finally {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void saveToPKCS12(String string, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string2, boolean bl, char[] cArray, boolean bl2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        try {
            Object object;
            String string3 = string != null ? string : DumpKeyStore.a(x509CertificateArray[0]);
            byte[] byArray = DumpKeyStore.a(x509CertificateArray[0], string3);
            int n2 = x509CertificateArray.length;
            if (!bl2) {
                n2 = 1;
            }
            CertificateBag[] certificateBagArray = new CertificateBag[n2];
            certificateBagArray[n2 - 1] = new CertificateBag(x509CertificateArray[0]);
            certificateBagArray[n2 - 1].setFriendlyName(string3);
            certificateBagArray[n2 - 1].setLocalKeyID(byArray);
            if (bl2) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    certificateBagArray[n2 - 1 - i2] = new CertificateBag(x509CertificateArray[i2]);
                    try {
                        object = DumpKeyStore.a(x509CertificateArray[i2]);
                        if (object == null) continue;
                        certificateBagArray[n2 - 1 - i2].setFriendlyName((String)object);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            KeyBag keyBag = new KeyBag(privateKey, string3, byArray);
            object = new PKCS12(keyBag, certificateBagArray, true);
            ((PKCS12)object).encrypt(cArray);
            if (bl) {
                ((PKCS12)object).writeTo(fileOutputStream);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ((PKCS12)object).writeTo(byteArrayOutputStream);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("-----BEGIN PKCS12-----");
                printWriter.println(new String(Util.Base64Encode(byteArrayOutputStream.toByteArray())));
                printWriter.println("-----END PKCS12-----");
                printWriter.close();
            }
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.getMessage());
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String a(X509Certificate x509Certificate) {
        Name name = (Name)x509Certificate.getSubjectDN();
        String string = null;
        if (name != null && (string = name.getRDN(ObjectID.commonName)) == null) {
            string = name.toString();
        }
        return string;
    }

    private static byte[] a(X509Certificate x509Certificate, String string) {
        Object object;
        byte[] byArray = null;
        try {
            object = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            if (object != null) {
                byArray = ((SubjectKeyIdentifier)object).get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray == null) {
            try {
                byArray = new SubjectKeyIdentifier(x509Certificate.getPublicKey()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byArray == null) {
            try {
                byArray = x509Certificate.getFingerprint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byArray == null && string != null) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = string.getBytes();
                }
            }
        }
        if (byArray == null) {
            object = new Random();
            byArray = new byte[8];
            ((Random)object).nextBytes(byArray);
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        IAIK.addAsProvider();
        try {
            object2 = Class.forName("iaik.security.ecc.provider.ECCProvider");
            object = (Provider)((Class)object2).newInstance();
            Security.insertProviderAt((Provider)object, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray.length < 3 || stringArray.length > 4) {
            DumpKeyStore.a();
            System.exit(-1);
        }
        object2 = stringArray[0];
        object = stringArray[1];
        char[] cArray = stringArray[2].toCharArray();
        String string = stringArray.length == 4 ? stringArray[3] : "IAIKKeyStore";
        DumpKeyStore dumpKeyStore = new DumpKeyStore();
        dumpKeyStore.dump((String)object2, (String)object, cArray, string);
    }

    private static final void a() {
        System.out.println("Usage:\n");
        System.out.println("java DumpKeyStore <KeyStore File> <Out Dir> <password> [<KeyStore Type>]\n");
        System.out.println("e.g.:");
        System.out.println("java DumpKeyStore keystore.ks certs/ks password IAIKKeyStore\n");
    }

    private static final void a(String string) {
        System.err.println(string);
        Util.waitKey();
        System.exit(-1);
    }
}

