/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.NumberTheory;
import iaik.utils.Util;
import java.math.BigInteger;
import java.util.Random;

public final class CryptoUtils {
    private CryptoUtils() {
    }

    public static void zeroBlock(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                byArray[i2] = 0;
            }
        }
    }

    public static void zeroBlock(int[] nArray, int n2, int n3) {
        if (nArray != null) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                nArray[i2] = 0;
            }
        }
    }

    public static void zeroBlock(long[] lArray, int n2, int n3) {
        if (lArray != null) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                lArray[i2] = 0L;
            }
        }
    }

    public static void zeroBlock(byte[] byArray) {
        CryptoUtils.zeroBlock(byArray, 0, byArray.length);
    }

    public static void zeroBlock(int[] nArray) {
        CryptoUtils.zeroBlock(nArray, 0, nArray.length);
    }

    public static void zeroBlock(long[] lArray) {
        CryptoUtils.zeroBlock(lArray, 0, lArray.length);
    }

    public static void randomBlock(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = (byte)(Math.random() * 256.0);
        }
    }

    public static void randomBlock(byte[] byArray) {
        CryptoUtils.randomBlock(byArray, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5) {
        int n6 = n4;
        while (n6 < n4 + n5) {
            byArray3[n6++] = (byte)(byArray[n2++] ^ byArray2[n3++]);
        }
    }

    public static void xorBlock(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4, int n5) {
        int n6 = n4;
        while (n6 < n4 + n5) {
            nArray3[n6++] = nArray[n2++] ^ nArray2[n3++];
        }
    }

    public static void xorBlock(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4, int n5) {
        int n6 = n4;
        while (n6 < n4 + n5) {
            lArray3[n6++] = lArray[n2++] ^ lArray2[n3++];
        }
    }

    public static void xorBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
    }

    public static void xorBlock(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = nArray[i2] ^ nArray2[i2];
        }
    }

    public static void xorBlock(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray3[i2] = lArray[i2] ^ lArray2[i2];
        }
    }

    public static void copyBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + n4) {
            byArray2[n5++] = byArray[n2++];
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[i2];
        }
    }

    public static void copyBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            nArray2[i2] = nArray[n2++];
        }
    }

    public static void copyBlock(int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
    }

    public static void copyBlock(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + n4) {
            lArray2[n5++] = lArray[n2++];
        }
    }

    public static void copyBlock(long[] lArray, long[] lArray2) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray2[i2] = lArray[i2];
        }
    }

    public static boolean equalsBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (byArray[i2] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equalsBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (nArray[i2] != nArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equalsBlock(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (lArray[i2] != lArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsBlock(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsBlock(long[] lArray, long[] lArray2) {
        if (lArray.length != lArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] == lArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean secureEqualsBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            n5 = (byte)(n5 | byArray[n6++] ^ byArray2[n3++]);
        }
        return n5 == 0;
    }

    public static boolean secureEqualsBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            n5 |= nArray[n6++] ^ nArray2[n3++];
        }
        return n5 == 0;
    }

    public static boolean secureEqualsBlock(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        long l2 = 0L;
        int n5 = n2;
        while (n5 < n2 + n4) {
            l2 |= lArray[n5++] ^ lArray2[n3++];
        }
        return l2 == 0L;
    }

    public static boolean secureEqualsBlock(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 = (byte)(n2 | byArray[i2] ^ byArray2[i2]);
        }
        return n2 == 0;
    }

    public static boolean secureEqualsBlock(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 |= nArray[i2] ^ nArray2[i2];
        }
        return n2 == 0;
    }

    public static boolean secureEqualsBlock(long[] lArray, long[] lArray2) {
        if (lArray.length != lArray2.length) {
            return false;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            l2 |= lArray[i2] ^ lArray2[i2];
        }
        return l2 == 0L;
    }

    public static int compareBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (byArray[i2] != byArray2[n3]) {
                return i2 - n2;
            }
            ++n3;
        }
        return -1;
    }

    public static int compareBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (nArray[i2] != nArray2[n3]) {
                return i2 - n2;
            }
            ++n3;
        }
        return -1;
    }

    public static int compareBlock(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (lArray[i2] != lArray2[n3]) {
                return i2 - n2;
            }
            ++n3;
        }
        return -1;
    }

    public static int compareBlock(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = CryptoUtils.compareBlock(byArray, 0, byArray2, 0, n2);
        if (n3 != -1) {
            return n3;
        }
        if (byArray.length != byArray2.length) {
            return n2;
        }
        return -1;
    }

    public static int compareBlock(int[] nArray, int[] nArray2) {
        int n2 = nArray.length < nArray2.length ? nArray.length : nArray2.length;
        int n3 = CryptoUtils.compareBlock(nArray, 0, nArray2, 0, n2);
        if (n3 != -1) {
            return n3;
        }
        if (nArray.length != nArray2.length) {
            return n2;
        }
        return -1;
    }

    public static int compareBlock(long[] lArray, long[] lArray2) {
        int n2 = lArray.length < lArray2.length ? lArray.length : lArray2.length;
        int n3 = CryptoUtils.compareBlock(lArray, 0, lArray2, 0, n2);
        if (n3 != -1) {
            return n3;
        }
        if (lArray.length != lArray2.length) {
            return n2;
        }
        return -1;
    }

    public static void fillBlock(byte[] byArray, int n2, byte by, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = by;
        }
    }

    public static void fillBlock(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            nArray[i2] = n3;
        }
    }

    public static void fillBlock(long[] lArray, int n2, long l2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            lArray[i2] = l2;
        }
    }

    public static void fillBlock(byte[] byArray, byte by) {
        CryptoUtils.fillBlock(byArray, 0, by, byArray.length);
    }

    public static void fillBlock(int[] nArray, int n2) {
        CryptoUtils.fillBlock(nArray, 0, n2, nArray.length);
    }

    public static void fillBlock(long[] lArray, long l2) {
        CryptoUtils.fillBlock(lArray, 0, l2, lArray.length);
    }

    public static void spreadIntsToBytes(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 2)) {
            byArray[n5++] = (byte)(nArray[n2] >>> 24);
            byArray[n5++] = (byte)(nArray[n2] >>> 16);
            byArray[n5++] = (byte)(nArray[n2] >>> 8);
            byArray[n5++] = (byte)nArray[n2++];
        }
    }

    public static void spreadIntToBytes(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    public static void spreadIntsToBytesLE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 2)) {
            byArray[n5++] = (byte)nArray[n2];
            byArray[n5++] = (byte)(nArray[n2] >>> 8);
            byArray[n5++] = (byte)(nArray[n2] >>> 16);
            byArray[n5++] = (byte)(nArray[n2++] >>> 24);
        }
    }

    public static void spreadIntToBytesLE(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)n2;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3] = (byte)(n2 >>> 24);
    }

    public static void spreadLongsToBytes(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 3)) {
            byArray[n5++] = (byte)(lArray[n2] >>> 56);
            byArray[n5++] = (byte)(lArray[n2] >>> 48);
            byArray[n5++] = (byte)(lArray[n2] >>> 40);
            byArray[n5++] = (byte)(lArray[n2] >>> 32);
            byArray[n5++] = (byte)(lArray[n2] >>> 24);
            byArray[n5++] = (byte)(lArray[n2] >>> 16);
            byArray[n5++] = (byte)(lArray[n2] >>> 8);
            byArray[n5++] = (byte)lArray[n2++];
        }
    }

    public static void spreadLongsToBytesLE(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 3)) {
            byArray[n5++] = (byte)lArray[n2];
            byArray[n5++] = (byte)(lArray[n2] >>> 8);
            byArray[n5++] = (byte)(lArray[n2] >>> 16);
            byArray[n5++] = (byte)(lArray[n2] >>> 24);
            byArray[n5++] = (byte)(lArray[n2] >>> 32);
            byArray[n5++] = (byte)(lArray[n2] >>> 40);
            byArray[n5++] = (byte)(lArray[n2] >>> 48);
            byArray[n5++] = (byte)(lArray[n2++] >>> 56);
        }
    }

    public static void squashBytesToLongs(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 3)) {
            lArray[n3++] = (long)(byArray[n5++] & 0xFF) << 56 | (long)(byArray[n5++] & 0xFF) << 48 | (long)(byArray[n5++] & 0xFF) << 40 | (long)(byArray[n5++] & 0xFF) << 32 | (long)(byArray[n5++] & 0xFF) << 24 | (long)(byArray[n5++] & 0xFF) << 16 | (long)(byArray[n5++] & 0xFF) << 8 | (long)(byArray[n5++] & 0xFF);
        }
    }

    public static void squashBytesToLongsLE(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 3)) {
            lArray[n3++] = (long)(byArray[n5++] & 0xFF) | (long)(byArray[n5++] & 0xFF) << 8 | (long)(byArray[n5++] & 0xFF) << 16 | (long)(byArray[n5++] & 0xFF) << 24 | (long)(byArray[n5++] & 0xFF) << 32 | (long)(byArray[n5++] & 0xFF) << 40 | (long)(byArray[n5++] & 0xFF) << 48 | (long)(byArray[n5++] & 0xFF) << 56;
        }
    }

    public static void squashBytesToInts(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 2)) {
            nArray[n3++] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        }
    }

    public static int squashBytesToInt(byte[] byArray, int n2) {
        int n3 = n2;
        return (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
    }

    public static void squashBytesToIntsPadZero(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n4 >> 2;
        int n6 = n4 & 3;
        if (n5 != 0) {
            CryptoUtils.squashBytesToInts(byArray, n2, nArray, n3, n5);
        }
        if (n6 != 0) {
            n2 += n4 - n6;
            n3 += n5;
            switch (n6) {
                case 3: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8;
                    break;
                }
                case 2: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16;
                    break;
                }
                case 1: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24;
                }
            }
        }
    }

    public static int squashBytesToIntsLEPadZero(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n4 >> 2;
        int n6 = n4 & 3;
        if (n5 != 0) {
            CryptoUtils.squashBytesToIntsLE(byArray, n2, nArray, n3, n5);
        }
        if (n6 != 0) {
            n2 += n4 - n6;
            n3 += n5;
            switch (n6) {
                case 3: {
                    nArray[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16;
                    break;
                }
                case 2: {
                    nArray[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
                    break;
                }
                case 1: {
                    nArray[n3] = byArray[n2++] & 0xFF;
                }
            }
            return n5 + 1;
        }
        return n5;
    }

    public static void squashBytesToIntsLE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 2)) {
            nArray[n3++] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5++] << 24;
        }
    }

    public static void squashBytesToShortsBE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 1)) {
            nArray[n3++] = (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        }
    }

    public static void squashBytesToShortsLE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n2;
        while (n5 < n2 + (n4 << 1)) {
            nArray[n3++] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8;
        }
    }

    public static void spreadShortsToBytesBE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 1)) {
            byArray[n5++] = (byte)(nArray[n2] >>> 8);
            byArray[n5++] = (byte)nArray[n2++];
        }
    }

    public static void spreadShortsToBytesLE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        while (n5 < n3 + (n4 << 1)) {
            byArray[n5++] = (byte)nArray[n2];
            byArray[n5++] = (byte)(nArray[n2++] >>> 8);
        }
    }

    public static byte[] resizeArray(byte[] byArray, int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Invalid length: " + n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, byArray.length));
        return byArray2;
    }

    public static void reverseArray(byte[] byArray, int n2, int n3) {
        if (byArray != null && byArray.length > 0) {
            int n4 = n2 + n3 - 1;
            int n5 = n2 + (n3 >>> 1);
            for (int i2 = n2; i2 < n5; ++i2) {
                byte by = byArray[i2];
                byArray[i2] = byArray[n4];
                byArray[n4--] = by;
            }
        }
    }

    public static byte[] increment(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] == 0) continue;
        }
        return byArray;
    }

    public static byte[] incrementExtended(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4 = n3--;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (byArray[n4] == 0) continue;
        }
        if (n3 == -1) {
            byArray2 = new byte[n2 + 1];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, n2);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray2, 0, byArray3, n2, n3);
        return byArray3;
    }

    public static int[] concatenate(int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3];
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        System.arraycopy(nArray2, 0, nArray3, n2, n3);
        return nArray3;
    }

    public static long[] concatenate(long[] lArray, long[] lArray2) {
        int n2 = lArray.length;
        int n3 = lArray2.length;
        long[] lArray3 = new long[n2 + n3];
        System.arraycopy(lArray, 0, lArray3, 0, n2);
        System.arraycopy(lArray2, 0, lArray3, n2, n3);
        return lArray3;
    }

    public static BigInteger getStrongPrime(int n2, Random random) {
        return NumberTheory.getStrongPrime(n2, random);
    }

    public static int gcd(int n2, int n3) {
        return NumberTheory.gcd(n2, n3);
    }

    public static int[] extGcd(int n2, int n3) {
        return NumberTheory.extGcd(n2, n3);
    }

    public static byte[] shiftRight(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = (byte)((byArray[i2] & 0xFF) >>> 1 | n2);
            n2 = byArray[i2] << 7;
        }
        return byArray2;
    }

    public static int[] shiftRight(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2] >>> 1 | n2;
            n2 = nArray[i2] << 31;
        }
        return nArray2;
    }

    public static long[] shiftRight(long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray2[i2] = lArray[i2] >>> 1 | l2;
            l2 = lArray[i2] << 63;
        }
        return lArray2;
    }

    public static byte[] shiftLeft(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray2[i2] = (byte)((byArray[i2] & 0xFF) << 1 | n2);
            n2 = byArray[i2] >>> 7 & 1;
        }
        return byArray2;
    }

    public static int[] shiftLeft(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            nArray2[i2] = nArray[i2] << 1 | n2;
            n2 = nArray[i2] >>> 31 & 1;
        }
        return nArray2;
    }

    public static long[] shiftLeft(long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        long l2 = 0L;
        for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
            lArray2[i2] = lArray[i2] << 1 | l2;
            l2 = lArray[i2] >>> 63 & 1L;
        }
        return lArray2;
    }

    public static byte[] addModBlockSize(int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[n2];
        if (byArray != null) {
            if (byArray2 != null) {
                int n3;
                int n4 = byArray.length;
                int n5 = byArray2.length;
                if (n4 < n5) {
                    byte[] byArray4 = byArray;
                    byArray = byArray2;
                    byArray2 = byArray4;
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                int n6 = n2 - 1;
                n3 = 0;
                int n7 = n4 - 1;
                int n8 = n5 - 1;
                while (n7 >= 0 && n6 >= 0) {
                    int n9 = byArray[n7] & 0xFF;
                    int n10 = n8 >= 0 ? byArray2[n8] & 0xFF : 0;
                    int n11 = n9 + n10 + n3 & 0xFF;
                    n3 = n11 < n9 || n11 < n10 ? 1 : 0;
                    byArray3[n6] = (byte)n11;
                    --n7;
                    --n8;
                    --n6;
                }
                if (n3 > 0 && n6 >= 0) {
                    byArray3[n6] = (byte)n3;
                }
            } else {
                int n12 = Math.max(Math.min(byArray.length, n2), 0);
                System.arraycopy(byArray, 0, byArray3, n2 - n12, n12);
            }
        } else {
            int n13 = Math.max(Math.min(byArray2.length, n2), 0);
            System.arraycopy(byArray2, 0, byArray3, n2 - n13, n13);
        }
        return byArray3;
    }

    static {
        Util.toString(null, -1, 1);
    }
}

