/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.security.provider.IAIK;
import iaik.utils.PasswordDialog;
import iaik.utils.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Locale;

public class ConvertKeyStore {
    private static final String[] a = new String[]{"IAIKKeyStore", "IAIK"};
    private static final String[] b = new String[]{"PKCS12", "IAIK"};
    private static final String[] c = new String[]{"JKS", "SUN"};
    private static final String[] d = new String[]{"JCEKS", "SunJCE"};
    private String e;
    private String f;
    private String g;
    private String h;
    private boolean i;

    public ConvertKeyStore(String string, String string2, String string3, String string4) {
        this.e = string;
        this.f = string2;
        this.g = string3;
        this.h = string4;
    }

    public void setVerbose(boolean bl) {
        this.i = bl;
    }

    void a(String string, String string2, char[] cArray) {
        Object object;
        KeyStore keyStore = null;
        File file = new File(string);
        if (!file.exists()) {
            ConvertKeyStore.c("Cannot find source KeyStore file \"" + string + "\"");
        }
        ConvertKeyStore.a("Loading source KeyStore from " + string);
        if (cArray != null) {
            try {
                keyStore = this.a(file, this.e, this.f, cArray, true);
            }
            catch (Exception exception) {
                ConvertKeyStore.a("Error loading KeyStore from \"" + string + "\": " + exception.getMessage(), exception);
            }
        } else {
            int n2;
            int n3 = n2 = 2;
            object = null;
            do {
                PasswordDialog passwordDialog = new PasswordDialog("Please enter KeyStore Password");
                passwordDialog.setVisible(true);
                cArray = (char[])passwordDialog.b().clone();
                passwordDialog.c();
                passwordDialog.dispose();
                try {
                    keyStore = this.a(file, this.e, this.f, cArray, true);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ConvertKeyStore.a("Error loaading source KeyStore from \"" + string + "\": " + fileNotFoundException.getMessage(), fileNotFoundException);
                }
                catch (KeyStoreException keyStoreException) {
                    ConvertKeyStore.a("Error losading source KeyStore from \"" + string + "\": " + keyStoreException.getMessage(), keyStoreException);
                }
                catch (IOException iOException) {
                    object = iOException;
                }
                catch (CertificateException certificateException) {
                    object = certificateException;
                }
            } while (n3-- > 0);
            if (keyStore == null) {
                ConvertKeyStore.a("No correct KeyStore password entered after " + n2 + " tries, exiting!", (Exception)object);
            }
        }
        KeyStore keyStore2 = null;
        File file2 = new File(string2);
        if (file2.exists()) {
            this.b("Target KeyStore file \"" + string2 + "\" already exists. Making backup copy.");
            object = null;
            try {
                object = new File(file2.getCanonicalPath() + ".bak");
                if (!((File)object).exists()) {
                    ((File)object).createNewFile();
                }
                if (((File)object).exists()) {
                    ConvertKeyStore.copyFile(file2, (File)object);
                }
            }
            catch (IOException iOException) {
                ConvertKeyStore.a("Cannot backup target KeyStore: " + iOException.getMessage(), iOException);
            }
        }
        try {
            keyStore2 = this.a(file2, this.g, this.h, null, false);
        }
        catch (Exception exception) {
            ConvertKeyStore.a("Error losading target KeyStore: " + exception.getMessage(), exception);
        }
        ConvertKeyStore.a("Copy entries....");
        object = null;
        try {
            object = this.a(keyStore, keyStore2, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            ConvertKeyStore.a("Error copying KeyStore: " + keyStoreException.getMessage(), keyStoreException);
        }
        if (object[0] > 0) {
            try {
                ConvertKeyStore.a("Saving target KeyStore to " + string2);
                this.a(keyStore2, string2, cArray);
            }
            catch (Exception exception) {
                ConvertKeyStore.a("Error saving target KeyStore: " + exception.getMessage(), exception);
            }
        }
        ConvertKeyStore.a("\nDone. " + (object[1] > 0 ? "Not all entries copied!" : "No Errors."));
    }

    private KeyStore a(File file, String string, String string2, char[] cArray, boolean bl) throws IOException, KeyStoreException, CertificateException {
        KeyStore keyStore = null;
        try {
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(noSuchProviderException.toString());
        }
        InputStream inputStream = null;
        try {
            if (bl) {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            keyStore.load(inputStream, cArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    private KeyStore a(KeyStore keyStore, String string, char[] cArray) throws IOException, KeyStoreException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            keyStore.store(fileOutputStream, cArray);
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.toString());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    private int[] a(KeyStore keyStore, KeyStore keyStore2, char[] cArray) throws KeyStoreException {
        int n2 = 0;
        int n3 = 0;
        Enumeration<String> enumeration = keyStore.aliases();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            String string = enumeration.nextElement();
            boolean bl = keyStore.isKeyEntry(string);
            this.a("Processing " + (bl ? "key " : "cert") + " entry: " + string, false);
            ++n2;
            if (bl) {
                try {
                    serializable = keyStore.getKey(string, cArray);
                    if (serializable != null) {
                        Certificate[] certificateArray = null;
                        if (serializable instanceof PrivateKey && (certificateArray = keyStore.getCertificateChain(string)) == null) {
                            throw new KeyStoreException("Cannot get certificate chain!");
                        }
                        keyStore2.setKeyEntry(string, (Key)serializable, cArray, certificateArray);
                        this.b("");
                        continue;
                    }
                    this.b("  -empty");
                    stringBuffer.append("     " + string + " (empty)\n");
                    ++n3;
                }
                catch (Exception exception) {
                    this.b(" -skipped (" + exception.toString() + ")");
                    stringBuffer.append("     " + string + " (" + exception.getMessage() + ")\n");
                    ++n3;
                }
                continue;
            }
            serializable = keyStore.getCertificate(string);
            if (serializable != null) {
                try {
                    keyStore2.setCertificateEntry(string, (Certificate)serializable);
                    this.b("");
                }
                catch (Exception exception) {
                    this.b(" -skipped (" + exception.toString() + ")");
                    stringBuffer.append("     " + string + " (" + exception.getMessage() + ")\n");
                    ++n3;
                }
                continue;
            }
            this.b("  -empty");
            stringBuffer.append("     " + string + " (empty)\n");
            ++n3;
        }
        int n4 = n2 - n3;
        StringBuffer stringBuffer2 = new StringBuffer("\n");
        switch (n4) {
            case 0: {
                stringBuffer2.append("No entries copied. ");
                break;
            }
            case 1: {
                stringBuffer2.append("1 entry copied. ");
                break;
            }
            default: {
                stringBuffer2.append(n4 + " entries copied. ");
            }
        }
        if (n3 > 0) {
            if (n3 == 1) {
                stringBuffer2.append("\n1 entry skipped:\n");
            } else {
                stringBuffer2.append("\n" + n3 + " entries skipped:\n");
            }
            stringBuffer2.append(stringBuffer.toString());
        }
        ConvertKeyStore.a(stringBuffer2.toString());
        return new int[]{n2, n3};
    }

    private static void a(String string) {
        System.out.println(string);
    }

    private void a(String string, boolean bl) {
        if (this.i) {
            if (bl) {
                System.out.println(string);
            } else {
                System.out.print(string);
            }
        } else {
            System.out.print(".");
        }
    }

    private void b(String string) {
        if (this.i) {
            System.out.println(string);
        } else {
            System.out.print(".");
        }
    }

    private static void c(String string) {
        ConvertKeyStore.a(string, (Exception)null);
    }

    private static void a(String string, Exception exception) {
        System.out.println(string);
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
        System.out.println();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            File file3 = file2.isDirectory() ? new File(file2, file.getName()) : file2;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            Util.copyStream(bufferedInputStream, filterOutputStream, null);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void a() {
        System.out.println();
        System.out.println("Usage: java ConvertKeyStore <SourceKeyStoreFile> <TargetKeyStoreFile> [<Password>]");
        System.out.println(" e.g.: java ConvertKeyStore -skstype IAIKKeyStore -tkstype PKCS12 iaikKeyStore.ks pkcs12KeyStore.p12 topSecret");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("  -skstype (source keystore type)");
        System.out.println("  -sksprov (source keystore provider)");
        System.out.println("  -tkstype (target keystore type)");
        System.out.println("  -tksprov (target keystore provider)");
        System.out.println("  -v (verbose: dump progress information)");
        System.out.println();
        System.exit(1);
    }

    private static String a(int n2, String string, String[] stringArray) throws ArrayIndexOutOfBoundsException {
        if (n2 >= stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("Missing " + string + " argument");
        }
        return stringArray[n2];
    }

    private static String[] a(String string, String string2) {
        String[] stringArray = null;
        stringArray = string2 == null ? ConvertKeyStore.d(string) : new String[]{ConvertKeyStore.e(string2), string2};
        return stringArray;
    }

    private static String[] d(String string) {
        String[] stringArray = a;
        String string2 = string.toUpperCase(Locale.US);
        if (string2.endsWith(c[0])) {
            stringArray = c;
        } else if (string2.endsWith(".p12") || string2.endsWith(".pfx")) {
            stringArray = b;
        } else if (string2.endsWith(d[0])) {
            stringArray = d;
        }
        return stringArray;
    }

    private static String e(String string) {
        String string2 = null;
        if (string.equals(a[1])) {
            string2 = a[0];
        } else if (string.equals(c[1])) {
            string2 = c[0];
        } else if (string.equals(d[1])) {
            string2 = d[0];
        }
        return string2;
    }

    private static void b() {
        IAIK.addAsProvider();
        Provider provider = null;
        try {
            Class<?> clazz = Class.forName("iaik.security.ec.provider.ECCelerate");
            provider = (Provider)clazz.newInstance();
            try {
                Method method = clazz.getDeclaredMethod("enforceSP80057Recommendations", Boolean.TYPE);
                method.invoke(clazz, Boolean.FALSE);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (provider == null) {
            try {
                provider = (Provider)Class.forName("iaik.security.ecc.provider.ECCProvider").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (provider != null) {
            Security.insertProviderAt(provider, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        int n2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        char[] cArray = null;
        if (stringArray.length < 2 || stringArray.length > 12) {
            ConvertKeyStore.a();
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string7 = stringArray[i2].toLowerCase(Locale.US);
                if (string7.equals("-v")) {
                    bl = true;
                    continue;
                }
                if (string7.equals("-skstype")) {
                    string2 = ConvertKeyStore.a(++i2, string7, stringArray);
                    continue;
                }
                if (string7.equals("-sksprov")) {
                    string3 = ConvertKeyStore.a(++i2, string7, stringArray);
                    continue;
                }
                if (string7.equals("-tkstype")) {
                    string5 = ConvertKeyStore.a(++i2, string7, stringArray);
                    continue;
                }
                if (string7.equals("-tksprov")) {
                    string6 = ConvertKeyStore.a(++i2, string7, stringArray);
                    continue;
                }
                if (string7.startsWith("-")) {
                    System.out.println("\nInvalid argumet: " + string7);
                    ConvertKeyStore.a();
                    continue;
                }
                if (string == null) {
                    string = stringArray[i2];
                    continue;
                }
                if (string4 == null) {
                    string4 = stringArray[i2];
                    continue;
                }
                if (cArray == null) {
                    cArray = stringArray[i2].toCharArray();
                    continue;
                }
                ConvertKeyStore.a();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("\n" + arrayIndexOutOfBoundsException.getMessage());
            ConvertKeyStore.a();
        }
        if (string2 == null) {
            ConvertKeyStore.a("Type of source keystore not specified. Trying to determine it...");
            String[] stringArray2 = ConvertKeyStore.a(string, string3);
            string2 = stringArray2[0];
            if (string2 == null) {
                ConvertKeyStore.a("Cannot not determine type of source key store");
                ConvertKeyStore.a();
            }
            string3 = stringArray2[1];
            ConvertKeyStore.a("Source keystore type is " + string2 + ".");
            ConvertKeyStore.a("Source keystore provider is " + string3 + ".");
        }
        if (string5 == null) {
            ConvertKeyStore.a("Type of target keystore not specified. Trying to determine it...");
            String[] stringArray3 = ConvertKeyStore.a(string4, string6);
            string5 = stringArray3[0];
            if (string5 == null) {
                ConvertKeyStore.a("Cannot not determine type of target key store");
                ConvertKeyStore.a();
            }
            string6 = stringArray3[1];
            ConvertKeyStore.a("Target keystore type is " + string5 + ".");
            ConvertKeyStore.a("Target keystore provider is " + string6 + ".");
        }
        ConvertKeyStore.b();
        ConvertKeyStore convertKeyStore = new ConvertKeyStore(string2, string3, string5, string6);
        convertKeyStore.setVerbose(bl);
        try {
            convertKeyStore.a(string, string4, cArray);
            if (cArray == null) return;
            n2 = 0;
        }
        catch (Throwable throwable) {
            if (cArray != null) {
                for (int i3 = 0; i3 < cArray.length; ++i3) {
                    cArray[i3] = false;
                }
            }
            cArray = null;
            throw throwable;
        }
        while (n2 < cArray.length) {
            cArray[n2] = false;
            ++n2;
        }
        return;
    }
}

