/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.kdf.KeyDerivationParameterSpec;
import iaik.security.rsa.RsaKemAlgorithmParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RsaKemAlgorithmParameters
extends AlgorithmParametersSpi {
    private AlgorithmID b;
    private int c;
    static Class a;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RsaKemAlgorithmParameterSpec)) {
            throw new InvalidParameterSpecException("Supports only instance of RsaKemAlgorithmParameterSpec");
        }
        KeyDerivationParameterSpec keyDerivationParameterSpec = ((RsaKemAlgorithmParameterSpec)algorithmParameterSpec).getKdfParams();
        this.b = keyDerivationParameterSpec.getAlgorithmId();
        this.c = keyDerivationParameterSpec.getKeyLength();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = new ASN1(byArray).toASN1Object();
            if (aSN1Object.countComponents() != 2) {
                throw new IOException("corrupted parameters. expecting 2 components, got " + aSN1Object.countComponents() + " components");
            }
            this.b = new AlgorithmID(aSN1Object.getComponentAt(0));
            if (!aSN1Object.getComponentAt(1).isA(ASN.INTEGER)) {
                throw new IOException("corrupted ASN.1 SEQUENCE. Expecting INTEGER 2nd");
            }
            this.c = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
        }
        catch (CodingException codingException) {
            throw new IOException("corrupted ASN.1");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.isAssignableFrom(a == null ? (a = RsaKemAlgorithmParameters.class$("iaik.security.rsa.RsaKemAlgorithmParameterSpec")) : a)) {
            throw new InvalidParameterSpecException(clazz.getName() + " not supported");
        }
        try {
            KeyDerivationParameterSpec keyDerivationParameterSpec = (KeyDerivationParameterSpec)this.b.getAlgorithmParameterSpec();
            keyDerivationParameterSpec.setKeyLength(this.c);
            return new RsaKemAlgorithmParameterSpec(keyDerivationParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterSpecException("provided kdf not supported");
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b.toASN1Object(false));
        sEQUENCE.addComponent(new INTEGER(this.c));
        try {
            return new ASN1(sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "RsaKem(" + this.b + ", " + this.c + ")";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

