/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.pkcs.pkcs1.RSACipher;
import iaik.security.kdf.KeyDerivationParameterSpec;
import iaik.security.kem.KeyEncapsulationMechanismSpi;
import iaik.security.random.SecRandom;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.security.rsa.RsaKemAlgorithmParameterSpec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.KeyGenerator;

public class RsaKem
extends KeyEncapsulationMechanismSpi {
    private SecureRandom a;
    private RsaKemAlgorithmParameterSpec b;
    private boolean c;

    protected void engineInit(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException("can only be initiated with algorithm parameter specs");
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new UnsupportedOperationException("can only be initiated with algorithm parameter specs");
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(key, algorithmParameterSpec);
        this.a = SecRandom.getDefault();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(key, algorithmParameterSpec);
        this.a = secureRandom == null ? SecRandom.getDefault() : secureRandom;
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("RsaKem");
            algorithmParameters.init(this.b);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RsaKem AlgorithmParameters not registered?");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("RsaKem AlgorithmParameters not registered?");
        }
        return algorithmParameters;
    }

    protected void engineDeriveKey(byte[] byArray, List list) throws DigestException {
        try {
            KeyDerivationParameterSpec keyDerivationParameterSpec = this.b.getKdfParams();
            KeyGenerator keyGenerator = KeyGenerator.getInstance(keyDerivationParameterSpec.getKdf());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                byteArrayOutputStream.write((byte[])iterator.next());
            }
            keyDerivationParameterSpec.setSecretValue(byteArrayOutputStream.toByteArray());
            keyGenerator.init(keyDerivationParameterSpec);
            System.arraycopy(keyGenerator.generateKey().getEncoded(), 0, byArray, 0, byArray.length);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new DigestException("Could not build desired kdf: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new DigestException("Could not init kdf: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException in ByteArrayOutputStream??");
        }
    }

    protected byte[] engineEncapsule(byte[] byArray) throws InvalidKeyException, DigestException {
        BigInteger bigInteger;
        if (!this.c) {
            throw new IllegalStateException("wrong state - expected decap");
        }
        if (this.b.getKdfParams().getKeyLength() != byArray.length) {
            throw new DigestException("Session key length doesnt match with provided KDF parameters");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.key;
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        RSACipher rSACipher = new RSACipher();
        rSACipher.setUseBlinding(false);
        while ((bigInteger = new BigInteger(bigInteger2.bitLength(), this.a)).compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger3 = rSACipher.rawPublicRSA(bigInteger, rSAPublicKey);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(bigInteger.toByteArray());
        this.engineDeriveKey(byArray, arrayList);
        return bigInteger3.toByteArray();
    }

    protected void engineDecapsule(byte[] byArray, byte[] byArray2) throws InvalidKeyException, DigestException, InvalidParameterException {
        if (this.c) {
            throw new IllegalStateException("wrong state - expected encap");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.key;
        RSACipher rSACipher = new RSACipher();
        rSACipher.setUseBlinding(false);
        BigInteger bigInteger = rSACipher.rawPrivateRSA(new BigInteger(byArray), rSAPrivateKey, null);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(bigInteger.toByteArray());
        this.engineDeriveKey(byArray2, arrayList);
    }

    private void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RsaKemAlgorithmParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only support RsaKemAlgorithmParameters");
        }
        this.key = key;
        this.b = (RsaKemAlgorithmParameterSpec)algorithmParameterSpec;
        if (key instanceof RSAPublicKey) {
            this.c = true;
        } else if (key instanceof RSAPrivateKey) {
            this.c = false;
        } else {
            throw new InvalidKeyException("Invalid key");
        }
    }
}

