/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.pkcs.pkcs1.RSASSAPkcs1v15ParameterSpec;
import iaik.security.provider.IAIK;
import iaik.security.rsa.Md2RSASignature;
import iaik.security.rsa.Md5RSASignature;
import iaik.security.rsa.RSASignature;
import iaik.security.rsa.RipeMd128RSASignature;
import iaik.security.rsa.RipeMd160RSASignature;
import iaik.security.rsa.RipeMd256RSASignature;
import iaik.security.rsa.Sha224RSASignature;
import iaik.security.rsa.Sha256RSASignature;
import iaik.security.rsa.Sha384RSASignature;
import iaik.security.rsa.Sha512RSASignature;
import iaik.security.rsa.ShaRSASignature;
import iaik.security.rsa.WhirlpoolRSASignature;
import iaik.utils.IaikSecurity;
import iaik.utils.PretendedMessageDigest;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;

public class RawRSAPkcs1v15Signature
extends RSASignature {
    private static final HashMap a = new HashMap();

    public RawRSAPkcs1v15Signature() {
        super("Raw RSASSA-PKCS1-v1_5", (MessageDigest)new PretendedMessageDigest());
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (!(object instanceof RSASSAPkcs1v15ParameterSpec)) {
            throw new InvalidParameterException("Parameters must be a RSASSAPkcs1v15ParameterSpec!");
        }
        try {
            this.engineSetParameter((RSASSAPkcs1v15ParameterSpec)object);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSASSAPkcs1v15ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a RSASSAPkcs1v15ParameterSpec!");
        }
        this.c = ((RSASSAPkcs1v15ParameterSpec)algorithmParameterSpec).getHashAlgorithm();
        this.a((byte[][])a.get(this.c.getAlgorithm()));
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return this.engineGetParameters();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.c != null) {
            try {
                RSASSAPkcs1v15ParameterSpec rSASSAPkcs1v15ParameterSpec = new RSASSAPkcs1v15ParameterSpec(this.c);
                algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("RSASSA-PKCS1-v1_5", IAIK.getInstance());
                algorithmParameters.init(rSASSAPkcs1v15ParameterSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    static {
        a.put(Md2RSASignature.a.getAlgorithm(), Md2RSASignature.b);
        a.put(Md5RSASignature.a.getAlgorithm(), Md5RSASignature.b);
        a.put(ShaRSASignature.a.getAlgorithm(), ShaRSASignature.b);
        a.put(Sha224RSASignature.a.getAlgorithm(), Sha224RSASignature.b);
        a.put(Sha256RSASignature.a.getAlgorithm(), Sha256RSASignature.b);
        a.put(Sha384RSASignature.a.getAlgorithm(), Sha384RSASignature.b);
        a.put(Sha512RSASignature.a.getAlgorithm(), Sha512RSASignature.b);
        a.put(RipeMd128RSASignature.a.getAlgorithm(), RipeMd128RSASignature.d);
        a.put(RipeMd128RSASignature.b.getAlgorithm(), RipeMd128RSASignature.d);
        a.put(RipeMd160RSASignature.a.getAlgorithm(), RipeMd160RSASignature.d);
        a.put(RipeMd160RSASignature.b.getAlgorithm(), RipeMd160RSASignature.d);
        a.put(RipeMd256RSASignature.a.getAlgorithm(), RipeMd256RSASignature.b);
        a.put(WhirlpoolRSASignature.a.getAlgorithm(), WhirlpoolRSASignature.b);
    }
}

