/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSACipher;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.InternalErrorException;
import iaik.utils.NumberTheory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;

public class RSAPrivateKey
extends PrivateKeyInfo
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -6672816640245521016L;
    private transient ASN1 c;
    int d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private BigInteger h;
    private BigInteger i;
    private BigInteger j;
    private BigInteger k;
    private BigInteger l;

    protected RSAPrivateKey() {
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, NumberTheory.ZERO, bigInteger2, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        this.a(true);
    }

    public RSAPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
        if (rSAPrivateKeySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)rSAPrivateKeySpec;
            this.a(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        } else {
            this.a(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        this.a(true);
    }

    public RSAPrivateKey(java.security.interfaces.RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            this.a(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        } else {
            this.a(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        this.a(true);
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public RSAPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(bigInteger, NumberTheory.ZERO, bigInteger2, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO, NumberTheory.ZERO);
    }

    void a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.g = bigInteger3;
        this.f = bigInteger2;
        this.e = bigInteger;
        this.h = bigInteger4;
        this.i = bigInteger5;
        this.j = bigInteger6;
        this.k = bigInteger7;
        this.l = bigInteger8;
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = ((BigInteger)this.c.getComponentAt(0).getValue()).intValue();
            this.e = (BigInteger)this.c.getComponentAt(1).getValue();
            this.f = (BigInteger)this.c.getComponentAt(2).getValue();
            this.g = (BigInteger)this.c.getComponentAt(3).getValue();
            this.h = (BigInteger)this.c.getComponentAt(4).getValue();
            this.i = (BigInteger)this.c.getComponentAt(5).getValue();
            this.j = (BigInteger)this.c.getComponentAt(6).getValue();
            this.k = (BigInteger)this.c.getComponentAt(7).getValue();
            this.l = (BigInteger)this.c.getComponentAt(8).getValue();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No RSA Private Key: " + exception.toString());
        }
    }

    public static RSAPrivateKey parse(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        rSAPrivateKey.decode(byArray);
        rSAPrivateKey.a(true);
        return rSAPrivateKey;
    }

    public BigInteger crypt(BigInteger bigInteger) {
        return new RSACipher().rawPrivateRSA(bigInteger, this, null);
    }

    void a(boolean bl) {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.d));
            sEQUENCE.addComponent(new INTEGER(this.e));
            sEQUENCE.addComponent(new INTEGER(this.f));
            sEQUENCE.addComponent(new INTEGER(this.g));
            sEQUENCE.addComponent(new INTEGER(this.h));
            sEQUENCE.addComponent(new INTEGER(this.i));
            sEQUENCE.addComponent(new INTEGER(this.j));
            sEQUENCE.addComponent(new INTEGER(this.k));
            sEQUENCE.addComponent(new INTEGER(this.l));
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        if (bl) {
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            this.createPrivateKeyInfo();
        }
    }

    public byte[] encode() {
        return this.c.toByteArray(true);
    }

    public PublicKey getPublicKey() {
        return new RSAPublicKey(this.e, this.f);
    }

    public BigInteger getPrivateExponent() {
        return this.g;
    }

    public BigInteger getPublicExponent() {
        return this.f;
    }

    public BigInteger getModulus() {
        return this.e;
    }

    public BigInteger getPrimeP() {
        return this.h;
    }

    public BigInteger getPrimeQ() {
        return this.i;
    }

    public BigInteger getPrimeExponentP() {
        return this.j;
    }

    public BigInteger getPrimeExponentQ() {
        return this.k;
    }

    public BigInteger getCrtCoefficient() {
        return this.l;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public int hashCode() {
        return this.e.hashCode() ^ this.f.hashCode() ^ this.g.hashCode() ^ this.h.hashCode() ^ this.i.hashCode() ^ this.j.hashCode() ^ this.k.hashCode() ^ this.l.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAlgorithm() + " private key (" + this.e.bitLength() + " bits):\n");
        stringBuffer.append("modulus: " + this.e.toString(16) + "\n");
        stringBuffer.append("public exponent: " + this.f.toString(16) + "\n");
        stringBuffer.append("private exponent: " + this.g.toString(16) + "\n");
        stringBuffer.append("primeP: " + this.h.toString(16) + "\n");
        stringBuffer.append("primeQ: " + this.i.toString(16) + "\n");
        stringBuffer.append("primeExponentP: " + this.j.toString(16) + "\n");
        stringBuffer.append("primeExponentQ: " + this.k.toString(16) + "\n");
        stringBuffer.append("crt_coefficient: " + this.l.toString(16) + "\n");
        return stringBuffer.toString();
    }
}

