/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.security.provider.IAIK;
import iaik.security.rsa.RSAOaepPublicKey;
import iaik.security.rsa.RSAPrivateKey;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAOaepPrivateKey
extends RSAPrivateKey {
    private static final long serialVersionUID = -8569629836653146622L;
    private transient RSAOaepParameterSpec e;
    static Class c;

    RSAOaepPrivateKey() {
    }

    public RSAOaepPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(bigInteger, bigInteger2);
        try {
            this.a();
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
    }

    public RSAOaepPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(bigInteger, bigInteger2);
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAOaepParameterSpec)) {
                throw new InvalidParameterSpecException("Parameters must be RSAOaepParameterSpec!");
            }
            this.e = (RSAOaepParameterSpec)algorithmParameterSpec;
        }
        this.a();
    }

    public RSAOaepPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        try {
            this.a();
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
    }

    public RSAOaepPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAOaepParameterSpec)) {
                throw new InvalidParameterSpecException("Parameters must be RSAOaepParameterSpec!");
            }
            this.e = (RSAOaepParameterSpec)algorithmParameterSpec;
        }
        this.a();
    }

    public RSAOaepPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAOaepPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public RSAOaepPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        super.decode(byArray);
        if (!this.private_key_algorithm.equals(AlgorithmID.rsaesOAEP)) {
            throw new InvalidKeyException("Invalid algorithm id (" + this.private_key_algorithm.getAlgorithm().getID() + ") Not an OAEP key!");
        }
        ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
        if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
            try {
                AlgorithmParameters algorithmParameters = this.private_key_algorithm.getAlgorithmParameters("RSAES-OAEP", IAIK.getInstance());
                this.e = (RSAOaepParameterSpec)algorithmParameters.getParameterSpec(c == null ? (c = RSAOaepPrivateKey.class$("iaik.pkcs.pkcs1.RSAOaepParameterSpec")) : c);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Error parsing OAEP parameters: " + exception.toString());
            }
        }
    }

    private void a() throws InvalidParameterSpecException {
        super.a(false);
        this.private_key_algorithm = (AlgorithmID)AlgorithmID.rsaesOAEP.clone();
        if (this.e != null) {
            try {
                AlgorithmParameters algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("RSAES-OAEP", IAIK.getInstance());
                algorithmParameters.init(this.e);
                this.private_key_algorithm.setAlgorithmParameters(algorithmParameters);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException("Invalid OAEP parameters: " + exception.toString());
            }
        } else {
            this.private_key_algorithm.encodeAbsentParametersAsNull(false);
        }
        this.createPrivateKeyInfo();
    }

    public PublicKey getPublicKey() {
        try {
            return new RSAOaepPublicKey(this.getModulus(), this.getPublicExponent(), this.e);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException.toString());
        }
    }

    public String getAlgorithm() {
        return "RSAES-OAEP";
    }

    public AlgorithmParameterSpec getParams() {
        return this.e;
    }

    public boolean validateParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        return RSAOaepPublicKey.a(this.e, algorithmParameterSpec);
    }

    public int hashCode() {
        int n2 = super.hashCode();
        if (this.e != null) {
            n2 ^= this.e.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAOaepPrivateKey && (bl = super.equals(object))) {
            RSAOaepPrivateKey rSAOaepPrivateKey = (RSAOaepPrivateKey)object;
            bl = this.e != null && rSAOaepPrivateKey.e != null ? this.e.equals(rSAOaepPrivateKey.e) : this.e == null && rSAOaepPrivateKey.e == null;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.e != null) {
            stringBuffer.append("parameters:\n" + this.e);
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

