/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.security.rsa.OaepKeyPairGenerator;
import iaik.security.rsa.RSAKeyPairGenerator;
import iaik.security.rsa.RSAOaepPrivateKey;
import iaik.security.rsa.RSAOaepPublicKey;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.security.rsa.b;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAOaepKeyPairGenerator
extends RSAKeyPairGenerator
implements OaepKeyPairGenerator {
    RSAOaepParameterSpec b;

    public RSAOaepKeyPairGenerator() {
        super("RSAES-OAEP");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, null);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        try {
            this.initialize(-1, null, algorithmParameterSpec, secureRandom);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException.getMessage());
        }
    }

    public void initialize(int n2, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterException {
        this.initialize(n2, null, algorithmParameterSpec, null);
    }

    public void initialize(int n2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        this.initialize(n2, null, algorithmParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(int n2, BigInteger bigInteger, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidParameterException {
        b b2 = null;
        if (algorithmParameterSpec instanceof RSAOaepParameterSpec) {
            this.b = (RSAOaepParameterSpec)algorithmParameterSpec;
        } else {
            if (algorithmParameterSpec == null || !"java.security.spec.RSAKeyGenParameterSpec".equals(algorithmParameterSpec.getClass().getName())) throw new InvalidParameterException("Not a RSAOaepParameterSpec or RSAKeyGenParameterSpec");
            try {
                b2 = new b(algorithmParameterSpec);
                AlgorithmParameterSpec algorithmParameterSpec2 = b2.c();
                if (algorithmParameterSpec2 != null) {
                    this.b = new RSAOaepParameterSpec(algorithmParameterSpec2);
                }
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
            }
        }
        try {
            super.a(n2, bigInteger, b2, secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    RSAPublicKey a(BigInteger bigInteger, BigInteger bigInteger2) {
        try {
            return new RSAOaepPublicKey(bigInteger, bigInteger2, this.b);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
    }

    RSAPrivateKey a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        try {
            return new RSAOaepPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, this.b);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
    }
}

