/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.pkcs.pkcs1.RSACipher;
import iaik.security.random.SHA256FIPS186Random;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.security.rsa.b;
import iaik.utils.NumberTheory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private static final BigDecimal b = BigDecimal.valueOf(2L);
    protected int keylen;
    protected SecureRandom random;
    protected BigInteger public_exponent = null;
    protected boolean initialized = false;
    static final BigInteger a = BigInteger.valueOf(65537L);
    private static final BigInteger c = new BigInteger("1234567890ABCDEF1234567890ABCDEF", 16);

    public RSAKeyPairGenerator() {
        super("RSA");
    }

    RSAKeyPairGenerator(String string) {
        super(string);
    }

    public void initialize(int n2) {
        this.initialize(n2, null, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.initialize(n2, null, secureRandom);
    }

    public void initialize(int n2, BigInteger bigInteger, SecureRandom secureRandom) {
        this.initialized = false;
        this.public_exponent = null;
        this.random = null;
        if (n2 <= 0) {
            n2 = this.keylen <= 0 ? 2048 : this.keylen;
        }
        this.keylen = 0;
        this.a(n2, bigInteger, secureRandom);
        if (this.public_exponent == null) {
            if (bigInteger == null) {
                this.public_exponent = a;
            } else {
                if (!bigInteger.testBit(0)) {
                    throw new InvalidParameterException("The public exponent must be odd");
                }
                this.public_exponent = bigInteger;
            }
        }
        if (this.random == null) {
            this.a(secureRandom);
        }
        this.initialized = true;
        this.keylen = n2;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, null);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        b b2 = new b(algorithmParameterSpec);
        this.a(-1, null, b2, secureRandom);
    }

    void a(int n2, BigInteger bigInteger, b b2, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (b2 != null) {
            int n3 = b2.a();
            if (n2 > 0) {
                if (n3 > 0 && n3 != n2) {
                    throw new InvalidAlgorithmParameterException("strength (" + n2 + ") differs from params keysize (" + n3 + ")");
                }
            } else {
                n2 = n3;
            }
            BigInteger bigInteger2 = b2.b();
            if (bigInteger != null) {
                if (bigInteger2 != null && !bigInteger.equals(bigInteger2)) {
                    throw new InvalidAlgorithmParameterException("publicExponent differs from params publicExponent");
                }
            } else {
                bigInteger = bigInteger2;
            }
        }
        this.initialize(n2, bigInteger, secureRandom);
    }

    void a(int n2, BigInteger bigInteger, SecureRandom secureRandom) throws InvalidParameterException {
        if (n2 < 320) {
            throw new InvalidParameterException("Unsupported key size!");
        }
        if (bigInteger != null && bigInteger.compareTo(NumberTheory.ONE) <= 0) {
            throw new InvalidParameterException("The public exponent must be greater than 1!");
        }
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        if (!this.initialized) {
            this.initialize(2048);
        }
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = null;
        BigInteger bigInteger6 = null;
        BigInteger bigInteger7 = null;
        boolean bl = false;
        for (int i2 = 0; i2 < 100; ++i2) {
            do {
                BigInteger[] bigIntegerArray;
                if ((bigInteger2 = (bigIntegerArray = this.a())[0]).compareTo(bigInteger3 = bigIntegerArray[1]) >= 0) continue;
                bigInteger = bigInteger2;
                bigInteger2 = bigInteger3;
                bigInteger3 = bigInteger;
            } while (this.public_exponent.gcd(bigInteger6 = (bigInteger4 = bigInteger2.subtract(NumberTheory.ONE)).multiply(bigInteger5 = bigInteger3.subtract(NumberTheory.ONE))).compareTo(NumberTheory.ONE) != 0);
            bigInteger7 = bigInteger2.multiply(bigInteger3);
            if (bigInteger7.bitLength() != this.keylen) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new RuntimeException("Could not generate " + this.keylen + " bit key!");
        }
        BigInteger bigInteger8 = this.public_exponent.modInverse(bigInteger6);
        bigInteger = bigInteger8.mod(bigInteger4);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger5);
        BigInteger bigInteger10 = bigInteger3.modInverse(bigInteger2);
        RSAPublicKey rSAPublicKey = this.a(bigInteger7, this.public_exponent);
        RSAPrivateKey rSAPrivateKey = this.a(bigInteger7, this.public_exponent, bigInteger8, bigInteger2, bigInteger3, bigInteger, bigInteger9, bigInteger10);
        RSACipher rSACipher = new RSACipher();
        BigInteger bigInteger11 = rSACipher.rawPublicRSA(c, rSAPublicKey);
        rSACipher = new RSACipher();
        rSACipher.setUseBlinding(false);
        BigInteger bigInteger12 = rSACipher.rawPrivateRSA(bigInteger11, rSAPrivateKey, this.random);
        if (bigInteger12.compareTo(c) != 0) {
            throw new RuntimeException("RSA keypair generation error!");
        }
        return new KeyPair(rSAPublicKey, rSAPrivateKey);
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = this.public_exponent;
        BigInteger bigInteger5 = new BigDecimal(bigInteger.subtract(NumberTheory.ONE)).divide(b, 2).toBigInteger();
        BigInteger bigInteger6 = bigInteger2.subtract(NumberTheory.ONE).shiftRight(1);
        int n2 = bigInteger6.bitLength() + bigInteger5.bitLength() >> 1;
        while (true) {
            BigInteger bigInteger7;
            if ((bigInteger7 = new BigInteger(n2, this.random)).compareTo(bigInteger5) < 0 || bigInteger7.compareTo(bigInteger6) > 0) {
                continue;
            }
            BigInteger bigInteger8 = bigInteger7.shiftLeft(1);
            bigInteger3 = bigInteger8.add(NumberTheory.ONE);
            BigInteger bigInteger9 = bigInteger8.gcd(bigInteger4);
            if (bigInteger9.compareTo(NumberTheory.ONE) == 0 && NumberTheory.millerRabin(bigInteger3)) break;
        }
        return bigInteger3;
    }

    BigInteger[] a() {
        int n2 = this.keylen + 1 >> 1;
        BigInteger bigInteger = NumberTheory.ZERO.setBit(n2 - 1);
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).subtract(NumberTheory.ONE);
        BigInteger bigInteger3 = this.b(bigInteger, bigInteger2);
        BigDecimal bigDecimal = new BigDecimal(NumberTheory.ZERO.setBit(this.keylen - 1));
        bigDecimal = bigDecimal.divide(new BigDecimal(bigInteger3), 1, 4);
        BigDecimal bigDecimal2 = bigDecimal.multiply(b);
        BigInteger bigInteger4 = bigDecimal.toBigInteger().add(NumberTheory.ONE);
        BigInteger bigInteger5 = bigDecimal2.toBigInteger();
        BigInteger bigInteger6 = this.b(bigInteger4, bigInteger5);
        return new BigInteger[]{bigInteger3, bigInteger6};
    }

    RSAPublicKey a(BigInteger bigInteger, BigInteger bigInteger2) {
        return new RSAPublicKey(bigInteger, bigInteger2);
    }

    RSAPrivateKey a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        return new RSAPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    void a(SecureRandom secureRandom) {
        this.random = secureRandom == null ? new SHA256FIPS186Random() : secureRandom;
    }
}

