/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.random;

import iaik.security.md.SHA;
import iaik.security.random.RandomException;
import iaik.security.random.VarLengthSeedGenerator;
import iaik.utils.Util;
import java.security.MessageDigest;

public abstract class HashObjectSeedGenerator
extends VarLengthSeedGenerator {
    private int g;
    private int h;
    private byte[] i;
    private MessageDigest j;

    protected HashObjectSeedGenerator(int n2) {
        super(n2);
        this.reinit(n2);
        this.j = this.getMessageDigest();
        this.j.reset();
    }

    public void reinit(int n2) {
        super.reinit(n2);
        this.g = n2;
        this.h = n2;
    }

    protected MessageDigest getMessageDigest() {
        return new SHA();
    }

    public final int[] getStatus() {
        return new int[]{this.g - this.h, this.g};
    }

    protected final void updateHash(byte[] byArray) {
        this.j.update(byArray);
    }

    protected final void updateHash(String string) {
        this.j.update(string.getBytes());
    }

    protected final void updateHash(long l2) {
        this.j.update(Util.toByteArray(l2));
    }

    protected abstract int extractSeedData(Object var1) throws RandomException;

    public final boolean addSeedObject(Object object) throws RandomException {
        if (this.h <= 0) {
            return false;
        }
        this.h -= this.extractSeedData(object);
        if (this.h < 0) {
            this.h = 0;
        }
        this.callSeedGenListener();
        return this.h <= 0;
    }

    public final byte[] getSeed() {
        if (this.i == null || this.hasSeedLengthChanged()) {
            if (this.h > 0) {
                return null;
            }
            this.i = this.j.digest();
        }
        return (byte[])this.i.clone();
    }
}

