/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.random;

import iaik.security.random.RandomException;
import iaik.security.random.RandomInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Random;

public class FIPS140Test {
    byte[] a;
    InputStream b;
    static int[] c;
    private static final int[] e;
    private static final int[] f;
    PrintWriter d;

    public FIPS140Test(Random random) {
        this(new RandomInputStream(random));
    }

    public FIPS140Test(InputStream inputStream) {
        this.b = inputStream;
        this.a = new byte[2500];
    }

    public void setDebugStream(PrintStream printStream) {
        this.d = printStream == null ? null : new PrintWriter(printStream);
    }

    public void setDebugStream(PrintWriter printWriter) {
        this.d = printWriter;
    }

    private int a(int n2) {
        int n3 = n2 >> 3;
        int n4 = n2 & 7;
        return (this.a[n3] & 0xFF) >>> 7 - n4 & 1;
    }

    public boolean monoBitTest() {
        this.a("running monobit test...");
        int n2 = 0;
        for (int i2 = 0; i2 < 2500; ++i2) {
            n2 += c[this.a[i2] & 0xFF];
        }
        this.a("number of one bits: 9654 < " + n2 + " < " + 10346);
        if (this.a(n2, 9654, 10346)) {
            this.a("monobit test passed");
            return true;
        }
        this.a("monobit test FAILED!");
        return false;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > n3 && n2 < n4;
    }

    public boolean runsTest() {
        int n2;
        this.a("running runs test");
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        int n3 = this.a(0);
        int n4 = 0;
        for (n2 = 0; n2 < 20000; ++n2) {
            if (n3 == this.a(n2)) {
                ++n4;
                continue;
            }
            if (n4 > 6) {
                n4 = 6;
            }
            int[] nArray3 = nArrayArray[n3];
            int n5 = n4;
            nArray3[n5] = nArray3[n5] + 1;
            n3 ^= 1;
            n4 = 0;
        }
        for (n2 = 1; n2 <= 6; ++n2) {
            this.a("blocks/gaps of length " + n2 + ": " + nArray2[n2] + "/" + nArray[n2]);
        }
        for (n2 = 1; n2 <= 6; ++n2) {
            if (this.a(nArray[n2] + nArray2[n2], e[n2], f[n2])) continue;
            this.a("runs of length " + n2 + " failed test: not " + e[n2] + " < " + (nArray[n2] + nArray2[n2]) + " < " + f[n2]);
            this.a("runs test FAILED");
            return false;
        }
        this.a("runs test passed");
        return true;
    }

    public boolean longRunsTest() {
        this.a("running long runs test");
        int n2 = this.a(0);
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < 20000; ++i2) {
            if (n2 == this.a(i2)) {
                ++n3;
                continue;
            }
            if (n3 >= 34) {
                this.a("long run of length " + n3 + " detected");
                this.a("long runs test FAILED");
                return false;
            }
            if (n3 > n4) {
                n4 = n3;
            }
            n2 ^= 1;
            n3 = 0;
        }
        this.a("longest run: " + n4);
        this.a("long runs test passed");
        return true;
    }

    public boolean pokerTest() {
        this.a("running poker test");
        int[] nArray = new int[16];
        for (int i2 = 0; i2 < 2500; ++i2) {
            int n2 = (this.a[i2] & 0xF0) >> 4;
            nArray[n2] = nArray[n2] + 1;
            int n3 = this.a[i2] & 0xF;
            nArray[n3] = nArray[n3] + 1;
        }
        long l2 = 0L;
        for (int i3 = 0; i3 <= 15; ++i3) {
            l2 += (long)(nArray[i3] * nArray[i3]);
        }
        float f2 = 0.0032f * (float)l2 - 5000.0f;
        this.a("poker test result: 1.03 < " + f2 + " < " + 57.4f);
        boolean bl = 1.03f < f2 && f2 < 57.4f;
        this.a("poker test " + (bl ? "passed" : "FAILED!"));
        return bl;
    }

    public void initTests() throws RandomException {
        try {
            int n2 = this.b.read(this.a);
            if (n2 != this.a.length) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw new RandomException("Error reading random data!");
        }
    }

    public boolean runTests() {
        return this.startTests();
    }

    public boolean startTests() {
        return this.startTests(false);
    }

    public boolean startTests(boolean bl) {
        this.a("initializing...");
        try {
            this.initTests();
        }
        catch (RandomException randomException) {
            this.a(randomException.getMessage());
            return false;
        }
        boolean bl2 = true;
        if (!bl && !(bl2 &= this.monoBitTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.pokerTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.runsTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.longRunsTest())) {
            return false;
        }
        if (bl2) {
            this.a("all tests passed");
        }
        return bl2;
    }

    private void a(Object object) {
        if (this.d != null) {
            this.d.println("FIPS140Test: " + object);
            this.d.flush();
        }
    }

    static {
        e = new int[]{0, 2267, 1079, 502, 223, 90, 90};
        f = new int[]{0, 2733, 1421, 748, 402, 223, 223};
        c = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = 0;
            for (int i3 = i2; i3 != 0; i3 >>= 1) {
                if ((i3 & 1) == 0) continue;
                ++n2;
            }
            FIPS140Test.c[i2] = n2;
        }
    }
}

