/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.mac;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBKDF2KeyAndParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2PBMAC1ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import iaik.pkcs.pkcs5.PBMAC1ParameterSpec;
import iaik.security.cipher.PBEKey;
import iaik.security.provider.IAIK;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PBMAC1
extends MacSpi {
    private static final AlgorithmID a = (AlgorithmID)AlgorithmID.pbkdf2.clone();
    private static final AlgorithmID b = (AlgorithmID)AlgorithmID.hMAC_SHA256.clone();
    private Mac c;
    private PBMAC1ParameterSpec d;

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cloneable cloneable;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("Key must be a PBEKey object");
        }
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("params must not be null!");
        }
        if (!(algorithmParameterSpec instanceof PBMAC1ParameterSpec) && !(algorithmParameterSpec instanceof PBKDF2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof PBMAC1ParameterSpec!");
        }
        if (algorithmParameterSpec instanceof PBKDF2ParameterSpec) {
            cloneable = (PBKDF2ParameterSpec)algorithmParameterSpec;
            this.d = new PBKDF2PBMAC1ParameterSpec((PBKDF2ParameterSpec)cloneable, (AlgorithmID)cloneable.getPrf().clone());
        } else {
            this.d = (PBMAC1ParameterSpec)algorithmParameterSpec;
        }
        cloneable = this.d.getKeyDerivationFunction();
        if (!AlgorithmID.pbkdf2.equals(cloneable)) {
            throw new InvalidAlgorithmParameterException("Only PBKDF2 supported!");
        }
        AlgorithmID algorithmID = this.d.getMessageAuthScheme();
        if (algorithmID == null) {
            throw new InvalidAlgorithmParameterException("No message authentication scheme specified!");
        }
        try {
            this.c = algorithmID.getMacInstance();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException("No Mac engine avaiable for " + algorithmID + "!");
        }
        String string = null;
        try {
            string = algorithmID.getJcaStandardName();
        }
        catch (Exception exception) {
            try {
                string = algorithmID.getImplementationName();
            }
            catch (Exception exception2) {
                string = algorithmID.getName();
            }
        }
        SecretKey secretKey = this.a((PBEKey)key, (AlgorithmID)cloneable, string);
        AlgorithmParameterSpec algorithmParameterSpec2 = null;
        if (algorithmID.getParameter() != null) {
            algorithmParameterSpec2 = algorithmID.getAlgorithmParameterSpec();
            this.c.init(secretKey, algorithmParameterSpec2);
        } else {
            this.c.init(secretKey);
        }
        this.engineReset();
    }

    private SecretKey a(PBEKey pBEKey, AlgorithmID algorithmID, String string) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmID.getParameter() == null) {
            throw new InvalidAlgorithmParameterException("Missing parameters in PBKDF2 AlgorithmID!");
        }
        PBKDF2ParameterSpec pBKDF2ParameterSpec = null;
        pBKDF2ParameterSpec = this.d instanceof PBKDF2PBMAC1ParameterSpec ? (PBKDF2ParameterSpec)((PBKDF2PBMAC1ParameterSpec)this.d).getKDFParameterSpec() : (PBKDF2ParameterSpec)algorithmID.getAlgorithmParameterSpec(IAIK.getInstance());
        byte[] byArray = pBKDF2ParameterSpec.getSalt();
        int n2 = pBKDF2ParameterSpec.getIterationCount();
        int n3 = pBKDF2ParameterSpec.getDerivedKeyLength();
        AlgorithmID algorithmID2 = pBKDF2ParameterSpec.getPrf();
        SecretKey secretKey = PBMAC1.a(pBEKey, byArray, n2, n3, algorithmID2, string);
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecretKey a(PBEKey pBEKey, byte[] byArray, int n2, int n3, AlgorithmID algorithmID, String string) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey secretKey = null;
        PBKDF2KeyAndParameterSpec pBKDF2KeyAndParameterSpec = null;
        byte[] byArray2 = pBEKey.getEncoded();
        try {
            KeyGenerator keyGenerator = null;
            try {
                keyGenerator = KeyGenerator.getInstance("PBKDF2", IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("PBKDF2 not available!");
            }
            pBKDF2KeyAndParameterSpec = new PBKDF2KeyAndParameterSpec(byArray2, byArray, n2, n3);
            pBKDF2KeyAndParameterSpec.setPrf(algorithmID);
            keyGenerator.init(pBKDF2KeyAndParameterSpec, null);
            secretKey = keyGenerator.generateKey();
            secretKey = new SecretKeySpec(secretKey.getEncoded(), string);
            if (byArray2 == null) return secretKey;
        }
        catch (Throwable throwable) {
            if (byArray2 == null) throw throwable;
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray2[i2] = 0;
            }
            byArray2 = null;
            throw throwable;
        }
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            byArray2[i3] = 0;
        }
        return secretKey;
    }

    public void engineUpdate(byte by) {
        if (this.c == null) {
            throw new IllegalStateException("Mac engine not initialized yet!");
        }
        this.c.update(by);
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.c == null) {
            throw new IllegalStateException("Mac engine not initialized yet!");
        }
        this.c.update(byArray, n2, n3);
    }

    public void engineReset() {
        if (this.c != null) {
            this.c.reset();
        }
    }

    public int engineGetMacLength() {
        if (this.c == null) {
            throw new IllegalStateException("Mac engine not initialized yet!");
        }
        return this.c.getMacLength();
    }

    public byte[] engineDoFinal() {
        if (this.c == null) {
            throw new IllegalStateException("Mac engine not initialized yet!");
        }
        byte[] byArray = this.c.doFinal();
        this.engineReset();
        return byArray;
    }
}

