/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.mac;

import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public class HMac
extends MacSpi {
    private int a;
    private byte[] b;
    private int c;
    private MessageDigest d;
    private byte[] e;
    private byte[] f;

    public HMac(String string) throws NoSuchAlgorithmException {
        this(string, 64);
    }

    public HMac(String string, int n2) throws NoSuchAlgorithmException {
        try {
            this.d = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
        }
        catch (Throwable throwable) {
            this.d = MessageDigest.getInstance(string);
        }
        this.c = this.d.getDigestLength();
        this.a = n2;
        this.e = new byte[this.a];
        this.f = new byte[this.a];
    }

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must be a SecretKey object");
        }
        this.b = new byte[this.a];
        byte[] byArray = key.getEncoded();
        this.d.reset();
        if (byArray.length > this.a) {
            byArray = this.d.digest(byArray);
        }
        System.arraycopy(byArray, 0, this.b, 0, byArray.length);
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.e[i2] = (byte)(0x36 ^ this.b[i2]);
            this.f[i2] = (byte)(0x5C ^ this.b[i2]);
        }
        this.engineReset();
    }

    public void engineUpdate(byte by) {
        this.d.update(by);
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        this.d.update(byArray, n2, n3);
    }

    public void engineReset() {
        this.d.reset();
        this.d.update(this.e);
    }

    public int engineGetMacLength() {
        return this.c;
    }

    public byte[] engineDoFinal() {
        byte[] byArray = this.d.digest();
        this.d.update(this.f);
        this.d.update(byArray);
        byArray = this.d.digest();
        this.engineReset();
        return byArray;
    }
}

