/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.keystore;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.cipher.SecretKey;
import iaik.security.keystore.IAIKKeyStoreParsingException;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;

public final class IAIKKeyStore
extends KeyStoreSpi {
    private static int a = 1;
    private static int b;
    private static int c;
    private static final byte[] d;
    private static final byte[] e;
    private SecureRandom f = SecRandom.getDefault();
    private Hashtable g = new Hashtable();
    private int h = c;

    public static final void setKeyStoreVersion(int n2) {
        if (n2 != 0 && n2 != a && n2 != b) {
            throw new IllegalArgumentException("Invalid version number: " + n2 + ". Must be 0, 1 or 2!");
        }
        c = n2;
    }

    private byte[] a() {
        byte[] byArray = this.h == 0 ? new byte[16] : new byte[32];
        this.f.nextBytes(byArray);
        return byArray;
    }

    private ASN1Object a(byte[] byArray) {
        OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
        ObjectID objectID = new ObjectID("1.2.840.113549.1.5.9", null, null, false);
        AlgorithmID algorithmID = new AlgorithmID(objectID, oCTET_STRING);
        return algorithmID.toASN1Object();
    }

    private INTEGER b() {
        Date date = new Date();
        BigInteger bigInteger = BigInteger.valueOf(date.getTime());
        return new INTEGER(bigInteger);
    }

    private Date a(INTEGER iNTEGER) {
        BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
        return new Date(bigInteger.longValue());
    }

    private byte[] a(int n2, Key key, byte[] byArray) throws KeyStoreException {
        try {
            int n3 = 24;
            int n4 = 8;
            String string = "DESede/CBC/PKCS5Padding";
            String string2 = "DESede";
            if (this.h > 0) {
                n3 = 32;
                n4 = 16;
                string = "AES/CBC/PKCS5Padding";
                string2 = "AES";
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, n3, n4);
            SecretKey secretKey = new SecretKey(byArray, 0, n3, string2);
            Cipher cipher = IaikSecurity.getCipherInstance(string, IAIK.getInstance());
            int n5 = n2 == 0 ? 1 : 2;
            cipher.init(n5, (Key)secretKey, ivParameterSpec, null);
            byte[] byArray2 = key.getEncoded();
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (Exception exception) {
            throw new KeyStoreException("Crypt failed: " + exception.toString());
        }
    }

    private SecretKey a(char[] cArray, byte[] byArray) {
        SecretKey secretKey;
        block10: {
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = null;
            byte[] byArray2 = IAIKKeyStore.a(cArray);
            try {
                SecretKey secretKey2;
                int n2 = 48;
                int n3 = 2000;
                if (this.h == 0) {
                    n2 = 32;
                    n3 = 1000;
                } else if (this.h == b) {
                    n3 = 10000;
                }
                KeyGenerator keyGenerator = null;
                keyGenerator = IaikSecurity.getKeyGeneratorInstance("PBKDF2", IAIK.getInstance());
                pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(byArray2, byArray, n3, n2);
                keyGenerator.init(pBEKeyAndParameterSpec, null);
                secretKey = secretKey2 = (SecretKey)keyGenerator.generateKey();
                if (pBEKeyAndParameterSpec == null) break block10;
                byArray2 = pBEKeyAndParameterSpec.getPassword();
            }
            catch (Exception exception) {
                try {
                    throw new InternalErrorException("Could not generate key: " + exception.toString());
                }
                catch (Throwable throwable) {
                    if (pBEKeyAndParameterSpec != null) {
                        byArray2 = pBEKeyAndParameterSpec.getPassword();
                        for (int i2 = 0; i2 < byArray2.length; ++i2) {
                            byArray2[i2] = 0;
                        }
                    }
                    throw throwable;
                }
            }
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                byArray2[i3] = 0;
            }
        }
        return secretKey;
    }

    private int a(SEQUENCE sEQUENCE) {
        if (sEQUENCE == null) {
            return 10;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 > 3 || n2 < 1) {
            return 10;
        }
        int n3 = -1;
        try {
            sEQUENCE.getComponentAt(0);
            if (n2 == 1) {
                return 11;
            }
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
            n3 = cON_SPEC.getAsnType().getTag();
        }
        catch (Exception exception) {
            return 10;
        }
        switch (n3) {
            case 0: {
                return 12;
            }
            case 1: {
                return 13;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
        }
        return 10;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray;
        byte[] byArray2;
        OCTET_STRING oCTET_STRING;
        Object object;
        if (string == null) {
            throw new UnrecoverableKeyException("Alias has to be specified.");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            throw new UnrecoverableKeyException("Invalid keystore record.");
        }
        if (n2 == 15) {
            throw new UnrecoverableKeyException("This alias specifies a certificate entry.");
        }
        if (n2 == 11) {
            throw new UnrecoverableKeyException("This alias specifies a date entry.");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n3 = cON_SPEC.getAsnType().getTag();
        if (n3 == 2) {
            ASN1Object aSN1Object = cON_SPEC.getComponentAt(0);
            try {
                if (cArray == null || cArray.length == 0) {
                    return new EncryptedPrivateKeyInfo(aSN1Object);
                }
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(aSN1Object);
                return encryptedPrivateKeyInfo.decrypt(cArray);
            }
            catch (Exception exception) {
                throw new UnrecoverableKeyException("Wrong password: " + exception.toString());
            }
        }
        if (cArray == null || cArray.length == 0) {
            throw new UnrecoverableKeyException("Password has to be specified!");
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(0);
        byte[] byArray3 = null;
        try {
            object = (ObjectID)sEQUENCE3.getComponentAt(0);
            if (!((ObjectID)object).getID().equals("1.2.840.113549.1.5.9")) {
                throw new UnrecoverableKeyException("Unknown OID: " + object);
            }
            oCTET_STRING = (OCTET_STRING)sEQUENCE3.getComponentAt(1);
            byArray3 = oCTET_STRING.getWholeValue();
            if (byArray3.length != 32 && this.h == 0 && byArray3.length != 16) {
                throw new UnrecoverableKeyException("Invalid salt");
            }
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Cannot parse key: " + exception.toString());
        }
        object = this.a(cArray, byArray3);
        oCTET_STRING = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
        try {
            byArray2 = oCTET_STRING.getWholeValue();
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Cannot parse key: " + iOException.toString());
        }
        SecretKey secretKey = new SecretKey(byArray2, "RAW");
        try {
            byArray = this.a(1, secretKey, ((SecretKey)object).getEncoded());
        }
        catch (KeyStoreException keyStoreException) {
            throw new UnrecoverableKeyException(keyStoreException.getMessage());
        }
        if (n3 == 0) {
            return new SecretKey(byArray, "RAW");
        }
        try {
            return PrivateKeyInfo.getPrivateKey(byArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 != 3) {
            return null;
        }
        int n3 = this.a(sEQUENCE);
        if (n3 == 13 || n3 == 14) {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
            SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
            int n4 = sEQUENCE2.countComponents();
            Certificate[] certificateArray = new X509Certificate[n4];
            try {
                for (int i2 = 0; i2 < n4; ++i2) {
                    ASN1Object aSN1Object = sEQUENCE2.getComponentAt(i2);
                    X509Certificate x509Certificate = aSN1Object.isA(ASN.OCTET_STRING) ? new X509Certificate((byte[])aSN1Object.getValue()) : new X509Certificate(aSN1Object);
                    certificateArray[i2] = x509Certificate;
                }
            }
            catch (CertificateException certificateException) {
                return null;
            }
            return certificateArray;
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        X509Certificate x509Certificate;
        CON_SPEC cON_SPEC;
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        int n3 = this.a(sEQUENCE);
        if (n3 == 15) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        } else if (n2 == 3) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
        } else {
            return null;
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        ASN1Object aSN1Object = sEQUENCE2.getComponentAt(0);
        try {
            x509Certificate = aSN1Object.isA(ASN.OCTET_STRING) ? new X509Certificate((byte[])aSN1Object.getValue()) : new X509Certificate(aSN1Object);
        }
        catch (CertificateException certificateException) {
            throw new InternalErrorException(certificateException.getMessage());
        }
        return x509Certificate;
    }

    public Date engineGetCreationDate(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            return null;
        }
        INTEGER iNTEGER = (INTEGER)sEQUENCE.getComponentAt(0);
        return this.a(iNTEGER);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Object object;
        Object object2;
        int n2;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (key == null) {
            throw new KeyStoreException("Key has to be specified.");
        }
        if (key instanceof EncryptedPrivateKeyInfo) {
            n2 = 14;
        } else {
            if (cArray == null) {
                throw new KeyStoreException("Password has to be specified.");
            }
            if (key instanceof javax.crypto.SecretKey) {
                n2 = 12;
            } else {
                try {
                    PrivateKeyInfo.getPrivateKey(key.getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new KeyStoreException("Unknown private key type.");
                }
                n2 = 13;
            }
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        if (n2 == 14) {
            sEQUENCE.addComponent(new CON_SPEC(2, ((EncryptedPrivateKeyInfo)key).toASN1Object(), false));
        } else {
            object2 = this.a();
            SecretKey secretKey = this.a(cArray, (byte[])object2);
            object = this.a(0, key, secretKey.getEncoded());
            ASN1Object aSN1Object = this.a((byte[])object2);
            OCTET_STRING oCTET_STRING = new OCTET_STRING((byte[])object);
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(aSN1Object);
            sEQUENCE2.addComponent(oCTET_STRING);
            if (n2 == 12) {
                sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2, false));
            }
            if (n2 == 13) {
                sEQUENCE.addComponent(new CON_SPEC(1, sEQUENCE2, false));
            }
        }
        if (certificateArray != null && certificateArray[0] != null) {
            object2 = new SEQUENCE();
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                try {
                    object = this.h == 0 ? DerCoder.decode(certificateArray[i2].getEncoded()) : new OCTET_STRING(certificateArray[i2].getEncoded());
                    ((ConstructedType)object2).addComponent((ASN1Object)object);
                    continue;
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not encode certificate: " + exception.toString());
                }
            }
            sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object2, false));
        }
        this.g.put(string, sEQUENCE);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified. ");
        }
        if (byArray == null || byArray.length == 0) {
            throw new KeyStoreException("Key has to be specified. ");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            sEQUENCE.addComponent(new CON_SPEC(2, encryptedPrivateKeyInfo.toASN1Object(), false));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException("Key is not a PKCS#8-EncryptedPrivateKeyInfo. ");
        }
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        if (certificateArray != null && certificateArray[0] != null) {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                try {
                    ASN1Object aSN1Object = this.h == 0 ? DerCoder.decode(certificateArray[i2].getEncoded()) : new OCTET_STRING(certificateArray[i2].getEncoded());
                    sEQUENCE2.addComponent(aSN1Object);
                    continue;
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not decode certificate: " + exception.toString());
                }
            }
            sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        }
        this.g.put(string, sEQUENCE);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        ASN1Object aSN1Object;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (certificate == null) {
            throw new KeyStoreException("Certificate has to be specified.");
        }
        if (this.engineIsKeyEntry(string)) {
            throw new KeyStoreException("This alias is already used by a key.");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b());
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        try {
            aSN1Object = this.h == 0 ? DerCoder.decode(certificate.getEncoded()) : new OCTET_STRING(certificate.getEncoded());
        }
        catch (Exception exception) {
            throw new KeyStoreException("Could not encoding certificate: " + exception.toString());
        }
        sEQUENCE2.addComponent(aSN1Object);
        sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        this.g.put(string, sEQUENCE);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.g.remove(string);
        }
    }

    public Enumeration engineAliases() {
        return this.g.keys();
    }

    public boolean engineContainsAlias(String string) {
        if (string == null) {
            return false;
        }
        return this.g.containsKey(string);
    }

    public int engineSize() {
        return this.g.size();
    }

    public boolean engineIsKeyEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        int n2 = this.a(sEQUENCE);
        switch (n2) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.g.get(string);
        int n2 = this.a(sEQUENCE);
        return n2 == 15;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        try {
            byte[] byArray = certificate.getEncoded();
            Enumeration enumeration = this.engineAliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray2;
                String string = (String)enumeration.nextElement();
                Certificate certificate2 = this.engineGetCertificate(string);
                if (certificate2 == null || !CryptoUtils.equalsBlock(byArray, byArray2 = certificate2.getEncoded())) continue;
                return string;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        ConstructedType constructedType;
        ConstructedType constructedType2;
        Object object;
        Mac mac;
        if (cArray == null || cArray.length == 0) {
            throw new IOException("Password must be specified.");
        }
        byte[] byArray = this.a();
        SecretKey secretKey = this.a(cArray, byArray);
        String string = this.h > 0 ? "HMAC/SHA3-512" : "HMAC/SHA1";
        try {
            mac = IaikSecurity.getMacInstance(string, IAIK.getInstance());
            mac.init(secretKey);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not initialize HMAC: " + exception.toString());
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        Object object2 = this.g.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            constructedType2 = new OCTET_STRING(IAIKKeyStore.a((String)object));
            constructedType = new SEQUENCE();
            constructedType.addComponent(constructedType2);
            constructedType.addComponent((ASN1Object)this.g.get(object));
            sEQUENCE.addComponent(constructedType);
        }
        mac.update(DerCoder.encode(sEQUENCE));
        object2 = this.a(byArray);
        object = mac.doFinal(DerCoder.encode((ASN1Object)object2));
        constructedType2 = new SEQUENCE();
        constructedType2.addComponent(sEQUENCE);
        constructedType2.addComponent((ASN1Object)object2);
        constructedType = new OCTET_STRING((byte[])object);
        if (this.h > a) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(new INTEGER(this.h));
            sEQUENCE2.addComponent(constructedType);
            constructedType2.addComponent(sEQUENCE2);
        } else {
            constructedType2.addComponent(constructedType);
        }
        outputStream.write(DerCoder.encode(constructedType2));
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.g.clear();
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new IOException("Password must be specified.");
        }
        this.h = -1;
        try {
            Mac mac;
            Object object;
            Object object2;
            ASN1 aSN1 = new ASN1(inputStream);
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1.getComponentAt(0);
            SEQUENCE sEQUENCE2 = (SEQUENCE)aSN1.getComponentAt(1);
            ASN1Object aSN1Object = sEQUENCE2.getComponentAt(1);
            if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                throw new IAIKKeyStoreParsingException("Invalid ASN.1 KDF params. Must be OCTET_STRING!");
            }
            OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object;
            aSN1Object = aSN1.getComponentAt(2);
            if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                if (!aSN1Object.isA(ASN.SEQUENCE)) {
                    throw new IAIKKeyStoreParsingException("Invalid ASN.1 mac value. Must be OCTET_STRING!");
                }
                object2 = (SEQUENCE)aSN1Object;
                if (((ConstructedType)object2).countComponents() != 2) {
                    throw new IAIKKeyStoreParsingException("Invalid number of components! Must be two");
                }
                object = ((ConstructedType)object2).getComponentAt(0);
                if (!((ASN1Object)object).isA(ASN.INTEGER)) {
                    throw new IAIKKeyStoreParsingException("Invalid ASN.1 version value. Must be INTEGER!");
                }
                this.h = ((BigInteger)((ASN1Object)object).getValue()).intValue();
                if (this.h != b) {
                    throw new IAIKKeyStoreParsingException("Invalid version number. Must be " + b + "!");
                }
                aSN1Object = ((ConstructedType)object2).getComponentAt(1);
                if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                    throw new IAIKKeyStoreParsingException("Invalid ASN.1 mac value. Must be OCTET_STRING!");
                }
            }
            if (((byte[])(object2 = (byte[])aSN1Object.getValue())).length == 20) {
                this.h = 0;
                object = "HMAC/SHA1";
            } else {
                if (((Object)object2).length != 64) {
                    throw new IAIKKeyStoreParsingException("Invalid mac length: " + ((Object)object2).length + "!");
                }
                if (this.h == -1) {
                    this.h = a;
                }
                object = "HMAC/SHA3-512";
            }
            byte[] byArray = (byte[])oCTET_STRING.getValue();
            SecretKey secretKey = this.a(cArray, byArray);
            try {
                mac = IaikSecurity.getMacInstance((String)object, IAIK.getInstance());
                mac.init(secretKey);
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Could not initialize HMAC: " + exception.toString());
            }
            mac.update(aSN1.getFirstObject());
            byte[] byArray2 = mac.doFinal(DerCoder.encode(sEQUENCE2));
            if (!CryptoUtils.secureEqualsBlock((byte[])object2, byArray2)) {
                throw new IOException(this, "Integrity verification failed! HMAC not valid. "){
                    private static final long serialVersionUID = 1811236715520167575L;
                    private final IAIKKeyStore a;
                    {
                        this.a = iAIKKeyStore;
                    }

                    public Throwable getCause() {
                        return new UnrecoverableKeyException("Integrity verification failed! HMAC not valid. Wrong password!");
                    }
                };
            }
            for (int i2 = 0; i2 < sEQUENCE.countComponents(); ++i2) {
                SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE.getComponentAt(i2);
                OCTET_STRING oCTET_STRING2 = (OCTET_STRING)sEQUENCE3.getComponentAt(0);
                SEQUENCE sEQUENCE4 = (SEQUENCE)sEQUENCE3.getComponentAt(1);
                this.g.put(IAIKKeyStore.b((byte[])oCTET_STRING2.getValue()), sEQUENCE4);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (CodingException codingException) {
            throw new IAIKKeyStoreParsingException(codingException.toString());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Error loading KeyStore: " + exception.toString());
        }
    }

    private static byte[] a(char[] cArray) {
        try {
            return UTF8String.getUTF8EncodingFromCharArray(cArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static byte[] a(String string) {
        try {
            return UTF8String.getUTF8EncodingFromString(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static String b(byte[] byArray) {
        try {
            return UTF8String.getStringFromUTF8Encoding(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    public static final KeyStore convertKeyStore(KeyStore keyStore, char[] cArray) throws KeyStoreException {
        try {
            KeyStore keyStore2 = IaikSecurity.getKeyStoreInstance("IAIKKeyStore", IAIK.getInstance());
            keyStore2.load(null, null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                String string = enumeration.nextElement();
                if (keyStore.isKeyEntry(string)) {
                    serializable = keyStore.getKey(string, cArray);
                    Certificate[] certificateArray = null;
                    if (serializable instanceof PrivateKey) {
                        certificateArray = keyStore.getCertificateChain(string);
                    }
                    keyStore2.setKeyEntry(string, (Key)serializable, cArray, certificateArray);
                    continue;
                }
                if (keyStore.isCertificateEntry(string)) {
                    serializable = keyStore.getCertificate(string);
                    keyStore2.setCertificateEntry(string, (Certificate)serializable);
                    continue;
                }
                throw new KeyStoreException("KeyStore entry with alias \"" + string + "\" is neither key nor certificate entry");
            }
            return keyStore2;
        }
        catch (Exception exception) {
            throw new KeyStoreException("Error converting KeyStore: " + exception.toString());
        }
    }

    static {
        c = b = 2;
        d = new byte[]{-75, -50, -12, 108, 5, -103, -61, -17, -16, -91, -93, -10, 119, -71, 42, -113, 82, 90, 4, 66, -92, -128, -80, -107, 5, -82, 25, -14, -13, 110, -78, 44};
        e = new byte[]{-75, -50, -12, 108, 5, -103, -61, -17, -16, -91, -93, -10, 119, -71, 42, -113, 82, 90, 4, 66, -92, -128, -80, -107, 5, -82, 25, -14, -13, 110, -78, 44, 20, -57, 49, -14, -57, 31, -61, -11, -73, -95, 82, -44, 28, 125, 74, -45};
        Util.toString(null, -1, 1);
    }
}

