/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kem;

import iaik.security.kem.KeyEncapsulationMechanismSpi;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyEncapsulationMechanism {
    private final KeyEncapsulationMechanismSpi a;
    private final Provider b;
    private final String c;
    private boolean d;

    protected KeyEncapsulationMechanism(KeyEncapsulationMechanismSpi keyEncapsulationMechanismSpi, Provider provider, String string) {
        this.a = keyEncapsulationMechanismSpi;
        this.b = provider;
        this.c = string;
        this.d = false;
    }

    public static KeyEncapsulationMechanism getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return KeyEncapsulationMechanism.a(string, null, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalErrorException(noSuchProviderException);
        }
    }

    public static KeyEncapsulationMechanism getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyEncapsulationMechanism.a(string, string2, null);
    }

    public static KeyEncapsulationMechanism getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider must not be null!");
        }
        return KeyEncapsulationMechanism.a(string, null, provider);
    }

    private static KeyEncapsulationMechanism a(String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        IaikSecurity iaikSecurity = provider != null ? new IaikSecurity(string, "KeyEncapsulationMechanism", provider) : new IaikSecurity(string, "KeyEncapsulationMechanism", string2);
        KeyEncapsulationMechanismSpi keyEncapsulationMechanismSpi = (KeyEncapsulationMechanismSpi)iaikSecurity.getImplementation();
        return new KeyEncapsulationMechanism(keyEncapsulationMechanismSpi, iaikSecurity.getProvider(), string);
    }

    public String getAlgorithm() {
        return this.c;
    }

    public Provider getProvider() {
        return this.b;
    }

    public void init(Key key) throws InvalidKeyException {
        this.a.engineInit(key);
        this.d = true;
    }

    public void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.a.engineInit(key, secureRandom);
        this.d = true;
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a.engineInit(key, algorithmParameterSpec);
        this.d = true;
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a.engineInit(key, algorithmParameterSpec, secureRandom);
        this.d = true;
    }

    public byte[] encapsule(byte[] byArray) throws InvalidKeyException, DigestException {
        if (!this.d) {
            throw new IllegalStateException("kem not initialized");
        }
        return this.a.engineEncapsule(byArray);
    }

    public AlgorithmParameters getParameters() {
        if (!this.d) {
            throw new IllegalStateException("kem not initialized");
        }
        return this.a.engineGetParameters();
    }

    public void decapsule(byte[] byArray, byte[] byArray2) throws InvalidKeyException, DigestException {
        if (!this.d) {
            throw new IllegalStateException("kem not initialized");
        }
        this.a.engineDecapsule(byArray, byArray2);
    }

    public String toString() {
        return "Key Encapsulation Mechanism: " + this.getAlgorithm();
    }
}

