/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.security.kdf.KeyDerivationParameterSpec;
import java.security.InvalidAlgorithmParameterException;

public class KDF1ParameterSpec
extends MGF1ParameterSpec
implements KeyDerivationParameterSpec {
    private int a;
    private byte[] b;
    private byte[] c;

    KDF1ParameterSpec(AlgorithmID algorithmID) {
        super(algorithmID);
    }

    public KDF1ParameterSpec(AlgorithmID algorithmID, int n2) {
        this(algorithmID, n2, null);
    }

    public KDF1ParameterSpec(AlgorithmID algorithmID, int n2, byte[] byArray) {
        this(algorithmID, n2, byArray, null);
    }

    public KDF1ParameterSpec(AlgorithmID algorithmID, int n2, byte[] byArray, byte[] byArray2) {
        super(algorithmID);
        this.a = n2;
        this.b = byArray;
        this.c = byArray2;
    }

    public int getKeyLength() {
        return this.a;
    }

    public void setKeyLength(int n2) {
        this.a = n2;
    }

    public AlgorithmID getAlgorithmId() {
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.kdf1.clone();
            algorithmID.setAlgorithmParameterSpec(this);
            return algorithmID;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException();
        }
    }

    public byte[] getSecretValue() {
        return this.b;
    }

    public void setSecretValue(byte[] byArray) {
        this.b = byArray;
    }

    public byte[] getOtherInfo() {
        return this.c;
    }

    public void setOtherInfo(byte[] byArray) {
        this.c = byArray;
    }

    public String getKdf() {
        return "KDF1";
    }
}

