/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.kdf.KDF1ParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class KDF1AlgorithmParameters
extends AlgorithmParametersSpi {
    private AlgorithmID b;
    static Class a;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof KDF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate AlgorithmParameterSpec. Expecting KDF1ParameterSpec");
        }
        this.b = ((KDF1ParameterSpec)algorithmParameterSpec).getHashAlgorithm();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = new ASN1(byArray).toASN1Object();
            if (aSN1Object.countComponents() != 2) {
                throw new IOException("corrupted parameters. expecting 2 components, got " + aSN1Object.countComponents() + " components");
            }
            if (!AlgorithmID.kdf1.getAlgorithm().equals(aSN1Object.getComponentAt(0))) {
                throw new CodingException("Expecting OID for KDF1, but got " + aSN1Object.getComponentAt(0).toString());
            }
            this.b = new AlgorithmID(aSN1Object.getComponentAt(1));
        }
        catch (CodingException codingException) {
            throw new IOException("corrupted ASN.1");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.isAssignableFrom(a == null ? (a = KDF1AlgorithmParameters.class$("iaik.security.kdf.KDF1ParameterSpec")) : a)) {
            throw new InvalidParameterSpecException(clazz.getName() + " not supported");
        }
        return new KDF1ParameterSpec((AlgorithmID)this.b.clone());
    }

    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.kdf1.clone();
        algorithmID.setParameter(this.b.toASN1Object());
        try {
            return new ASN1(algorithmID.toASN1Object()).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException("Could not serialize parameters");
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "KDF1(" + this.b.toString() + ")";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

