/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.cipher.SecretKey;
import iaik.security.kdf.HashBasedGenerationFunction;
import iaik.security.kdf.KDF1ParameterSpec;
import iaik.utils.InternalErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;

public class KDF1
extends KeyGeneratorSpi {
    public static final ObjectID OID = AlgorithmID.kdf1.getAlgorithm();
    private HashBasedGenerationFunction a;
    private byte[] b;
    private int c;

    protected String name() {
        return "KDF1";
    }

    protected HashBasedGenerationFunction generateHBGF(KDF1ParameterSpec kDF1ParameterSpec) {
        return new HashBasedGenerationFunction(kDF1ParameterSpec.getHashAlgorithm(), 0, kDF1ParameterSpec.getOtherInfo());
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("iaik.security.kdf." + this.name() + ".engineInit(" + "SecureRandom) method is not supported. ");
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("iaik.security.kdf." + this.name() + ".engineInit(int, " + "SecureRandom) method is not supported. ");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof KDF1ParameterSpec) {
            KDF1ParameterSpec kDF1ParameterSpec = (KDF1ParameterSpec)algorithmParameterSpec;
            this.b = kDF1ParameterSpec.getSecretValue();
            this.c = kDF1ParameterSpec.getKeyLength();
            this.a = this.generateHBGF(kDF1ParameterSpec);
            try {
                this.a.setHashEngine(kDF1ParameterSpec.getHashEngine());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("No hash engine available for the requested hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        } else {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec must be an instance of iaik.security.kdf." + this.name() + "ParameterSpec");
        }
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        byte[] byArray = new byte[this.c];
        try {
            this.a.generateOctets(this.b, 0, this.b.length, this.c, byArray, 0);
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalErrorException("Class not is not initialized. Call init(AlgorithmParameterSpec, random)");
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error calculating keying material: " + exception, exception);
        }
        return new SecretKey(byArray, "RAW");
    }
}

