/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.asn1.structures.AlgorithmID;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashBasedGenerationFunction
implements Cloneable {
    private final int a;
    private final boolean b;
    private final byte[] c;
    private AlgorithmID d;
    private MessageDigest e;

    public HashBasedGenerationFunction(AlgorithmID algorithmID, int n2) {
        this(algorithmID, n2, null, false);
    }

    public HashBasedGenerationFunction(AlgorithmID algorithmID, int n2, byte[] byArray) {
        this(algorithmID, n2, byArray, false);
    }

    public HashBasedGenerationFunction(AlgorithmID algorithmID, int n2, byte[] byArray, boolean bl) {
        this.d = algorithmID;
        this.a = n2;
        this.c = byArray;
        this.b = bl;
    }

    public void generateOctets(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, int n5) {
        byte[] byArray3 = new byte[4];
        CryptoUtils.spreadIntsToBytes(new int[]{this.a}, 0, byArray3, 0, 1);
        int n6 = 0;
        while (n6 < n4) {
            if (this.b) {
                this.e.update(byArray3);
                this.e.update(byArray, n2, n3);
            } else {
                this.e.update(byArray, n2, n3);
                this.e.update(byArray3);
            }
            if (this.c != null) {
                this.e.update(this.c);
            }
            byte[] byArray4 = this.e.digest();
            CryptoUtils.increment(byArray3);
            int n7 = 0;
            while (n7 < byArray4.length && n6 < n4) {
                int n8 = n5++;
                byArray2[n8] = (byte)(byArray2[n8] ^ byArray4[n7++]);
                ++n6;
            }
        }
    }

    public AlgorithmID getHashAlgorithm() {
        return this.d;
    }

    public void setHashAlgorithm(AlgorithmID algorithmID) {
        this.d = algorithmID;
    }

    public void engineReset() {
        if (this.e != null) {
            this.e.reset();
        }
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.e = messageDigest;
    }

    public void setHashEngine() throws NoSuchAlgorithmException {
        if (this.e == null) {
            if (this.d != null) {
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        this.e = this.d.getMessageDigestInstance(IAIK.getInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.e == null) {
                    this.e = this.d.getMessageDigestInstance();
                }
            }
        } else {
            this.e.reset();
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
            this.d = (AlgorithmID)this.d.clone();
            if (this.e != null) {
                this.e = (MessageDigest)this.e.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }
}

