/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.security.kdf.HKDFExpandOnlyParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HKDFParameterSpec
extends HKDFExpandOnlyParameterSpec {
    private byte[] a;
    private SecretKey b;

    public HKDFParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        super(byArray3, n2);
        if (byArray2 == null || byArray2.length == 0) {
            throw new IllegalArgumentException("ikm must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("L must not be negative!");
        }
        this.a = byArray;
        this.b = new SecretKeySpec(byArray2, "HKDF-IKM");
    }

    public HKDFParameterSpec(byte[] byArray, SecretKey secretKey, byte[] byArray2, int n2) {
        super(byArray2, n2);
        if (secretKey == null || secretKey.getEncoded().length == 0) {
            throw new IllegalArgumentException("ikm must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("L must not be negative!");
        }
        this.a = byArray;
        this.b = secretKey;
    }

    public byte[] getSalt() {
        return this.a;
    }

    public SecretKey getIKM() {
        return this.b;
    }

    byte[] a() {
        return this.b.getEncoded();
    }
}

