/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HKDFExpandOnlyParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private int b;
    private SecretKey c;

    public HKDFExpandOnlyParameterSpec(SecretKey secretKey, byte[] byArray, int n2) {
        if (secretKey == null) {
            throw new IllegalArgumentException("prk must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("L must not be negative!");
        }
        this.c = secretKey;
        this.a = byArray;
        this.b = n2;
    }

    public HKDFExpandOnlyParameterSpec(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("prk must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("L must not be negative!");
        }
        this.c = new SecretKeySpec(byArray, "HKDF-PRK");
        this.a = byArray2;
        this.b = n2;
    }

    HKDFExpandOnlyParameterSpec(byte[] byArray, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("L must not be negative!");
        }
        this.a = byArray;
        this.b = n2;
    }

    public SecretKey getPRK() {
        return this.c;
    }

    public byte[] getInfo() {
        return this.a;
    }

    public int getL() {
        return this.b;
    }
}

