/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.kdf;

import iaik.security.cipher.SecretKey;
import iaik.security.kdf.HKDFExpandOnlyParameterSpec;
import iaik.security.kdf.HKDFParameterSpec;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class HKDF
extends KeyGeneratorSpi {
    private Mac a;
    private int b;
    private int c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private javax.crypto.SecretKey h;

    HKDF(String string) throws NoSuchAlgorithmException {
        if (string.startsWith("SHA-")) {
            string = "SHA" + string.substring(4);
        }
        String string2 = "Hmac" + string;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                this.a = IaikSecurity.getMacInstance(string2, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.a == null) {
            try {
                this.a = Mac.getInstance(string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("No implementation for " + string2 + ": " + exception.getMessage());
            }
        }
        this.b = this.a.getMacLength();
        this.c = this.b * 255;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null) {
            byArray = new byte[this.b];
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "Raw");
        byte[] byArray3 = this.a(secretKeySpec, byArray2);
        return byArray3;
    }

    private byte[] a(javax.crypto.SecretKey secretKey, byte[] byArray) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("IKM must not be null!");
        }
        if (secretKey == null) {
            secretKey = new SecretKeySpec(new byte[this.b], "Raw");
        }
        this.a.init(secretKey);
        this.a.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.a.doFinal();
        return byArray2;
    }

    private byte[] a(byte[] byArray, byte[] byArray2, int n2) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("PRK must not be null!");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HKDF-PRK");
        return this.a(secretKeySpec, byArray2, n2);
    }

    private byte[] a(javax.crypto.SecretKey secretKey, byte[] byArray, int n2) throws InvalidKeyException {
        if (secretKey == null) {
            throw new InvalidKeyException("prk must not be null!");
        }
        byte[] byArray2 = secretKey.getEncoded();
        if (byArray2 == null) {
            throw new InvalidKeyException("prk key material must not be null!");
        }
        if (byArray2.length < this.b) {
            throw new InvalidKeyException("PRK must be at least " + this.b + " octest long!");
        }
        if (n2 < 0) {
            throw new InvalidKeyException("L must not be negative!");
        }
        if (n2 > this.c) {
            throw new InvalidKeyException("L (" + n2 + ") to great. Must be <= " + this.c);
        }
        this.a.init(secretKey);
        int n3 = (n2 + this.b - 1) / this.b;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] byArray3 = new byte[n2];
        int n4 = 0;
        byte[] byArray4 = new byte[]{};
        for (int i2 = 1; i2 <= n3; ++i2) {
            this.a.update(byArray4);
            this.a.update(byArray);
            this.a.update((byte)i2);
            byArray4 = this.a.doFinal();
            int n5 = n2 - n4;
            if (n5 > this.b) {
                n5 = this.b;
            }
            System.arraycopy(byArray4, 0, byArray3, n4, n5);
            n4 += n5;
        }
        return byArray3;
    }

    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidKeyException {
        byte[] byArray4 = this.a(byArray, byArray2);
        byte[] byArray5 = this.a(byArray4, byArray3, n2);
        return byArray5;
    }

    public javax.crypto.SecretKey engineGenerateKey() {
        byte[] byArray = null;
        try {
            byArray = this.h == null ? this.a(this.d, this.e, this.f, this.g) : this.a(this.h, this.f, this.g);
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error calculating keying material: " + exception.toString(), exception);
        }
        return new SecretKey(byArray, "RAW");
    }

    public void engineInit(int n2, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("iaik.security.kdf.HKDF.engineInit(int, SecureRandom) method is not supported. ");
    }

    public void engineInit(SecureRandom secureRandom) {
        throw new RuntimeException("iaik.security.kdf.HKDF.engineInit(SecureRandom) method is not supported. ");
    }

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof HKDFExpandOnlyParameterSpec) {
            HKDFExpandOnlyParameterSpec hKDFExpandOnlyParameterSpec = (HKDFExpandOnlyParameterSpec)algorithmParameterSpec;
            this.h = hKDFExpandOnlyParameterSpec.getPRK();
            this.f = hKDFExpandOnlyParameterSpec.getInfo();
            this.g = hKDFExpandOnlyParameterSpec.getL();
            if (algorithmParameterSpec instanceof HKDFParameterSpec) {
                HKDFParameterSpec hKDFParameterSpec = (HKDFParameterSpec)algorithmParameterSpec;
                this.e = hKDFParameterSpec.a();
                this.d = hKDFParameterSpec.getSalt();
            }
        } else {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec must be an instance of iaik.security.kdf.HKDF(ExpandOnly)ParameterSpec");
        }
    }

    public static final class HKDFwithSHA512
    extends HKDF {
        public HKDFwithSHA512() throws NoSuchAlgorithmException {
            super("SHA512");
        }
    }

    public static final class HKDFwithSHA384
    extends HKDF {
        public HKDFwithSHA384() throws NoSuchAlgorithmException {
            super("SHA384");
        }
    }

    public static final class HKDFwithSHA256
    extends HKDF {
        public HKDFwithSHA256() throws NoSuchAlgorithmException {
            super("SHA256");
        }
    }

    public static final class HKDFwithSHA224
    extends HKDF {
        public HKDFwithSHA224() throws NoSuchAlgorithmException {
            super("SHA224");
        }
    }

    public static final class HKDFwithSHA1
    extends HKDF {
        public HKDFwithSHA1() throws NoSuchAlgorithmException {
            super("SHA1");
        }
    }
}

