/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.dsa.DSA;
import iaik.security.dsa.DSAKeyPairGenerator;
import iaik.security.dsa.DetSigDSAParameterSpec;
import iaik.security.dsa.a;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.IaikSecurity;
import iaik.utils.NumberTheory;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public final class RawDSA
extends SignatureSpi {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private SecureRandom f;
    private byte[] g;
    private ByteArrayOutputStream h = new ByteArrayOutputStream(32);
    private DetSigDSAParameterSpec i;
    private boolean j;
    private a k;

    private static final int a(int n2) {
        int n3;
        switch (n2) {
            case 160: {
                n3 = 80;
                break;
            }
            case 224: {
                n3 = 112;
                break;
            }
            case 256: {
                n3 = 128;
                break;
            }
            case 384: {
                n3 = 192;
                break;
            }
            case 512: {
                n3 = 256;
                break;
            }
            default: {
                n3 = -1;
            }
        }
        return n3;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPublicKey!");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.b = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            this.a(dSAParams);
        }
        this.h.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Boolean bl;
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPrivateKey!");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.a = dSAPrivateKey.getX();
        this.a(dSAPrivateKey.getParams());
        this.h.reset();
        if (this.i != null && this.i.a()) {
            try {
                this.k = new a(this.i.b(), new DSAParameterSpec(this.c, this.d, this.e));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException(noSuchAlgorithmException.toString());
            }
        }
        this.j = (bl = DSA.d()) == null ? this.k != null : bl;
        if (this.j && privateKey instanceof PrivateKeyInfo) {
            try {
                PublicKey publicKey = ((PrivateKeyInfo)privateKey).getPubKey();
                if (publicKey != null && publicKey instanceof DSAPublicKey) {
                    this.b = ((DSAPublicKey)publicKey).getY();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.f = secureRandom;
        this.engineInitSign(privateKey);
    }

    private void a(DSAParams dSAParams) {
        this.c = dSAParams.getP();
        this.d = dSAParams.getQ();
        this.e = dSAParams.getG();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.h.write(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.h.write(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = RawDSA.a(this.dsaSignRS());
            return byArray;
        }
        finally {
            this.h.reset();
        }
    }

    public BigInteger[] dsaSignRS() throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        byte[] byArray = this.h.toByteArray();
        if (!DSA.b()) {
            int n2 = byArray.length * 8;
            int n3 = this.d.bitLength();
            int n4 = RawDSA.a(n2);
            int n5 = RawDSA.a(n3);
            if (n4 == -1) {
                throw new SignatureException("Cannot determine the security strength for the hash algorithm. You may use DSA in backwards compatibility mode.");
            }
            if (n4 < n5) {
                throw new SignatureException("Hash output length (" + n2 + ") too small for qLen (" + n3 + ")! " + "Use DSA with a stronger hash algorithm.");
            }
        }
        if (this.k != null) {
            this.k.a(this.a, byArray);
        }
        while ((bigInteger3 = this.a(bigInteger2 = this.a())).equals(NumberTheory.ZERO) || (bigInteger = this.a(bigInteger2, bigInteger3, byArray)).equals(NumberTheory.ZERO)) {
        }
        if (this.j) {
            if (this.b == null) {
                DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(this.c, this.d, this.e);
                this.b = DSAKeyPairGenerator.a(dSAParameterSpec, this.a);
            }
            if (!this.dsaVerifyRS(bigInteger3, bigInteger)) {
                throw new SignatureException("Faulty signature!");
            }
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger};
        return bigIntegerArray;
    }

    static byte[] a(BigInteger[] bigIntegerArray) throws SignatureException {
        return RawDSA.a(bigIntegerArray[0], bigIntegerArray[1]);
    }

    static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(bigInteger));
        sEQUENCE.addComponent(new INTEGER(bigInteger2));
        try {
            byte[] byArray = new ASN1(sEQUENCE).toByteArray();
            return byArray;
        }
        catch (CodingException codingException) {
            throw new SignatureException();
        }
    }

    private BigInteger a() {
        BigInteger bigInteger;
        if (this.k != null) {
            bigInteger = this.k.a();
        } else {
            BigInteger bigInteger2;
            if (this.g == null) {
                if (this.f == null) {
                    this.f = SecRandom.getDefault();
                }
                int n2 = this.d.bitLength() + 64;
                bigInteger2 = new BigInteger(n2, this.f);
            } else {
                bigInteger2 = new BigInteger(1, this.g);
                bigInteger2 = bigInteger2.subtract(NumberTheory.ONE);
            }
            bigInteger = bigInteger2.mod(this.d.subtract(NumberTheory.ONE)).add(NumberTheory.ONE);
        }
        return bigInteger;
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.e.modPow(bigInteger, this.c);
        BigInteger bigInteger3 = bigInteger2.mod(this.d);
        return bigInteger3;
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        BigInteger bigInteger3 = null;
        int n2 = byArray.length * 8;
        int n3 = this.d.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        BigInteger bigInteger5 = n3 >= n2 ? bigInteger4 : bigInteger4.shiftRight(n2 - n3);
        BigInteger bigInteger6 = bigInteger.modInverse(this.d);
        BigInteger bigInteger7 = this.a.multiply(bigInteger2);
        if (DSA.a()) {
            BigInteger bigInteger8 = this.b();
            BigInteger bigInteger9 = bigInteger8.multiply(this.a).mod(this.d);
            bigInteger9 = bigInteger9.multiply(bigInteger2).mod(this.d);
            BigInteger bigInteger10 = bigInteger8.multiply(bigInteger5).mod(this.d);
            BigInteger bigInteger11 = bigInteger9.add(bigInteger10).mod(this.d);
            bigInteger11 = bigInteger11.multiply(bigInteger6).mod(this.d);
            bigInteger8 = bigInteger8.modInverse(this.d);
            bigInteger3 = bigInteger11.multiply(bigInteger8).mod(this.d);
        } else {
            BigInteger bigInteger12 = bigInteger5.add(bigInteger7);
            BigInteger bigInteger13 = bigInteger6.multiply(bigInteger12);
            bigInteger3 = bigInteger13.mod(this.d);
        }
        return bigInteger3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            boolean bl = this.dsaVerifyRS(RawDSA.a(byArray));
            return bl;
        }
        finally {
            this.h.reset();
        }
    }

    static BigInteger[] a(byte[] byArray) throws SignatureException {
        boolean bl = DSA.c();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Object aSN1Object = DerCoder.decode(byteArrayInputStream, bl);
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new SignatureException("Invalid signature value encoding! Must be ASN.1 SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 != 2) {
                throw new SignatureException("Invalid number (" + n2 + ") of ASN.1 Signature! Must be 2!");
            }
            if (bl && byteArrayInputStream.available() > 0) {
                throw new SignatureException("Signature value encoding contains more octets than specified in length field!");
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.INTEGER)) {
                throw new SignatureException("Invalid signature value encoding! r component must be ASN.1 INTEGER!");
            }
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(1);
            if (!aSN1Object3.isA(ASN.INTEGER)) {
                throw new SignatureException("Invalid signature value encoding! s component must be ASN.1 INTEGER!");
            }
            BigInteger bigInteger = (BigInteger)aSN1Object2.getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object3.getValue();
            BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2};
            return bigIntegerArray;
        }
        catch (Exception exception) {
            throw new SignatureException();
        }
    }

    public boolean dsaVerifyRS(BigInteger[] bigIntegerArray) {
        return this.dsaVerifyRS(bigIntegerArray[0], bigIntegerArray[1]);
    }

    public boolean dsaVerifyRS(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            return false;
        }
        if (bigInteger.compareTo(this.d) >= 0 || bigInteger2.compareTo(this.d) >= 0) {
            return false;
        }
        BigInteger bigInteger3 = this.b(bigInteger, bigInteger2);
        BigInteger bigInteger4 = this.a(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger5 = this.b(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger6 = this.c(bigInteger4, bigInteger5);
        return bigInteger.equals(bigInteger6);
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.modInverse(this.d);
        return bigInteger3;
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        byte[] byArray = this.h.toByteArray();
        int n2 = byArray.length * 8;
        int n3 = this.d.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        BigInteger bigInteger5 = n3 >= n2 ? bigInteger4 : bigInteger4.shiftRight(n2 - n3);
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger3);
        BigInteger bigInteger5 = bigInteger4.mod(this.d);
        return bigInteger5;
    }

    private BigInteger c(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.e.modPow(bigInteger, this.c);
        BigInteger bigInteger4 = this.b.modPow(bigInteger2, this.c);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.mod(this.c);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (string != null && string.equals("KSEED")) {
            if (object == null) {
                this.g = null;
                return;
            } else if (object instanceof byte[]) {
                this.g = (byte[])object;
                return;
            } else {
                if (!(object instanceof BigInteger)) throw new InvalidParameterException("KSEED must be a either a byte array or a BigInteger");
                this.g = ((BigInteger)object).toByteArray();
            }
            return;
        }
        if (object instanceof SecureRandom) {
            this.f = (SecureRandom)object;
            return;
        }
        if (!(object instanceof DSAParameterSpec)) throw new InvalidParameterException("Invalid parameter; only KSEED, SecureRandom or DSAParameterSpec are allowed!");
        if (string != null && !string.equals("DSAParameterSpec")) {
            throw new InvalidParameterException("Invalid param name for DSAParameterSpec: " + string);
        }
        try {
            this.engineSetParameter((DSAParameterSpec)object);
            return;
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Not a DSAParameterSpec");
            }
            if (algorithmParameterSpec instanceof DetSigDSAParameterSpec) {
                DetSigDSAParameterSpec detSigDSAParameterSpec;
                this.i = detSigDSAParameterSpec = (DetSigDSAParameterSpec)algorithmParameterSpec;
            }
            this.a((DSAParameterSpec)algorithmParameterSpec);
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (string != null && string.equals("KSEED")) {
            return this.g;
        }
        return this.engineGetParameters();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.c != null && this.d != null && this.e != null) {
            try {
                DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(this.c, this.d, this.e);
                algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("DSA", IAIK.getInstance());
                algorithmParameters.init(dSAParameterSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    void a(SecureRandom secureRandom) {
        this.f = secureRandom;
    }

    private BigInteger b() {
        BigInteger bigInteger = null;
        int n2 = 10;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.f == null) {
                this.f = SecRandom.getDefault();
            }
            if (!(bigInteger = new BigInteger(this.d.bitLength() - 1, this.f)).equals(NumberTheory.ZERO) && !bigInteger.equals(NumberTheory.ONE)) break;
            if (i2 != n2 - 1) continue;
            throw new ProviderException("Secure random seems to deliver non-random bits. Unable to generate random blinding factor.");
        }
        return bigInteger;
    }

    static {
        Util.toString(null, -1, 1);
    }
}

