/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.security.dsa.DSAParams;
import iaik.security.md.SHA;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.IaikSecurity;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    MessageDigest a = new SHA();
    SecureRandom b = null;
    private int c = -1;

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.b = secureRandom;
        this.c = n2;
        this.a();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.b = secureRandom;
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameter must be null.");
        }
        this.a();
    }

    private void a() throws IllegalArgumentException {
        if (this.c < 512 || this.c > 1024 || this.c % 64 != 0) {
            throw new IllegalArgumentException("Prime must be at least 512, at most 1024, and a multiple of 64!");
        }
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.b == null) {
            this.b = SecRandom.getDefault();
        }
        if (this.c == -1) {
            this.c = 1024;
        }
        if (this.c < 512) {
            this.c = 512;
        }
        if (this.c > 1024) {
            this.c = 1024;
        }
        this.c &= 0xFFC0;
        DSAParams dSAParams = this.a(this.c);
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        try {
            AlgorithmParameters algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("DSA", IAIK.getInstance());
            algorithmParameters.init(dSAParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
    }

    private DSAParams a(int n2) {
        BigInteger[] bigIntegerArray = this.b((n2 - 512) / 64);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = this.a(bigInteger, bigInteger2);
        return new DSAParams(bigInteger, bigInteger2, bigInteger3);
    }

    private synchronized BigInteger[] b(int n2) {
        int n3 = 512 + 64 * n2;
        int n4 = (n3 - 1) / 160;
        int n5 = (n3 - 1) % 160;
        BigInteger bigInteger = NumberTheory.TWO.pow(159);
        BigInteger bigInteger2 = NumberTheory.TWO.pow(160);
        this.a.reset();
        while (true) {
            BigInteger bigInteger3;
            BigInteger bigInteger4 = new BigInteger(160, this.b);
            BigInteger bigInteger5 = bigInteger4.or(bigInteger);
            BigInteger bigInteger6 = bigInteger5.add(NumberTheory.ONE).mod(bigInteger2);
            BigInteger[] bigIntegerArray = new BigInteger(1, this.a.digest(bigInteger5.toByteArray()));
            BigInteger bigInteger7 = bigIntegerArray.xor(bigInteger3 = new BigInteger(1, this.a.digest(bigInteger6.toByteArray())));
            BigInteger bigInteger8 = bigInteger7.or(bigInteger).or(NumberTheory.ONE);
            if (!NumberTheory.isProbablePrime(bigInteger8)) continue;
            int n6 = 0;
            int n7 = 2;
            do {
                BigInteger bigInteger9;
                bigIntegerArray = new BigInteger[n4 + 1];
                bigInteger3 = BigInteger.valueOf(n7);
                for (int i2 = 0; i2 <= n4; ++i2) {
                    BigInteger bigInteger10 = BigInteger.valueOf(i2);
                    bigIntegerArray[i2] = new BigInteger(1, this.a.digest(bigInteger5.add(bigInteger3).add(bigInteger10).mod(bigInteger2).toByteArray()));
                }
                bigIntegerArray[n4] = bigIntegerArray[n4].mod(NumberTheory.TWO.pow(n5));
                bigInteger7 = NumberTheory.ZERO;
                int n8 = 0;
                for (int i3 = 0; i3 <= n4; ++i3) {
                    bigInteger7 = bigInteger7.add(bigIntegerArray[i3].shiftLeft(n8));
                    n8 += 160;
                }
                BigInteger bigInteger11 = bigInteger7.add(NumberTheory.TWO.pow(n3 - 1));
                BigInteger bigInteger12 = bigInteger11.subtract((bigInteger9 = bigInteger11.mod(bigInteger8.shiftLeft(1))).subtract(NumberTheory.ONE));
                if (bigInteger12.compareTo(NumberTheory.TWO.pow(n3 - 1)) >= 0 && NumberTheory.isProbablePrime(bigInteger12)) {
                    BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger12, bigInteger8};
                    return bigIntegerArray2;
                }
                n7 += n4 + 1;
            } while (++n6 < 4096);
        }
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger.subtract(NumberTheory.ONE).divide(bigInteger2);
        BigInteger bigInteger5 = NumberTheory.ONE;
        while ((bigInteger3 = (bigInteger5 = bigInteger5.add(NumberTheory.ONE)).modPow(bigInteger4, bigInteger)).compareTo(NumberTheory.ONE) == 0) {
        }
        return bigInteger3;
    }
}

