/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.dh.DHPublicKey;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPublicKeySpec;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.spec.DHParameterSpec;

public class ESDHPublicKey
extends PublicKeyInfo
implements javax.crypto.interfaces.DHPublicKey {
    private static final BigInteger a = BigInteger.valueOf(2L);
    private static final long serialVersionUID = -6611022487229363575L;
    private transient ASN1 c;
    private BigInteger d;
    private transient ESDHParameterSpec e;

    public static void validatePublicKey(ESDHPublicKey eSDHPublicKey) throws InvalidKeyException {
        BigInteger bigInteger = eSDHPublicKey.getY();
        DHParameterSpec dHParameterSpec = eSDHPublicKey.getParams();
        BigInteger bigInteger2 = dHParameterSpec.getP();
        BigInteger bigInteger3 = dHParameterSpec.getG();
        DHPublicKey.validatePublicKey(bigInteger, bigInteger2, bigInteger3);
    }

    public ESDHPublicKey(BigInteger bigInteger, ESDHParameterSpec eSDHParameterSpec) {
        this.d = bigInteger;
        this.e = eSDHParameterSpec;
        this.a();
    }

    public ESDHPublicKey(ESDHPublicKeySpec eSDHPublicKeySpec) {
        this.d = eSDHPublicKeySpec.getY();
        this.e = new ESDHParameterSpec(eSDHPublicKeySpec.getP(), eSDHPublicKeySpec.getG(), eSDHPublicKeySpec.getQ(), eSDHPublicKeySpec.getJ(), eSDHPublicKeySpec.getSeed(), eSDHPublicKeySpec.getPGenCounter());
        this.a();
    }

    public ESDHPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ESDHPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public ESDHPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = (BigInteger)this.c.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            if (aSN1Object != null) {
                BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
                BigInteger bigInteger3 = (BigInteger)aSN1Object.getComponentAt(2).getValue();
                BigInteger bigInteger4 = null;
                byte[] byArray2 = null;
                int n2 = 0;
                for (int i2 = 0; i2 < aSN1Object.countComponents() - 3; ++i2) {
                    if (aSN1Object.getComponentAt(i2 + 3) instanceof INTEGER) {
                        bigInteger4 = (BigInteger)aSN1Object.getComponentAt(i2 + 3).getValue();
                    }
                    if (!(aSN1Object.getComponentAt(i2 + 3) instanceof SEQUENCE)) continue;
                    SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object.getComponentAt(i2 + 3);
                    byArray2 = (byte[])sEQUENCE.getComponentAt(0).getValue();
                    n2 = ((BigInteger)sEQUENCE.getComponentAt(1).getValue()).intValue();
                }
                this.e = new ESDHParameterSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray2, n2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No ESDH Public Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.c = new ASN1(new INTEGER(this.d));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.e.getP()));
            sEQUENCE.addComponent(new INTEGER(this.e.getG()));
            sEQUENCE.addComponent(new INTEGER(this.e.getQ()));
            if (this.e.getJ() != null) {
                sEQUENCE.addComponent(new INTEGER(this.e.getJ()));
            }
            if (this.e.getSeed() != null) {
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(new BIT_STRING(this.e.getSeed()));
                sEQUENCE2.addComponent(new INTEGER(this.e.getPGenCounter()));
                sEQUENCE.addComponent(sEQUENCE2);
            }
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.esdh.clone();
            this.public_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public byte[] encode() {
        return this.c.toByteArray();
    }

    public String getAlgorithm() {
        return "ESDH";
    }

    public BigInteger getY() {
        return this.d;
    }

    public DHParameterSpec getParams() {
        return this.e;
    }

    public byte[] getFingerprint() {
        return this.c.fingerprint();
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.e.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESDH public key");
        stringBuffer.append(this.e == null ? ":\n" : " (" + this.e.getP().bitLength() + " bits):\n");
        stringBuffer.append("y: " + this.d.toString(16) + "\n");
        if (this.e != null) {
            stringBuffer.append("key parameters:\n" + this.e.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

